/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * Resource
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:30:21.574+08:00[Asia/Shanghai]")
public class Resource {
  @SerializedName("project_id")
  private Long projectId = null;

  @SerializedName("app_id")
  private Long appId = null;

  @SerializedName("service")
  private String service = null;

  @SerializedName("resource_type")
  private String resourceType = null;

  @SerializedName("business_identity")
  private String businessIdentity = null;

  public Resource projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 项目id
   * @return projectId
  **/
  @Schema(description = "项目id")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public Resource appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 应用id
   * @return appId
  **/
  @Schema(description = "应用id")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  public Resource service(String service) {
    this.service = service;
    return this;
  }

   /**
   * 资源范围
   * @return service
  **/
  @Schema(required = true, description = "资源范围")
  public String getService() {
    return service;
  }

  public void setService(String service) {
    this.service = service;
  }

  public Resource resourceType(String resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源类型
   * @return resourceType
  **/
  @Schema(required = true, description = "资源类型")
  public String getResourceType() {
    return resourceType;
  }

  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }

  public Resource businessIdentity(String businessIdentity) {
    this.businessIdentity = businessIdentity;
    return this;
  }

   /**
   * 资源唯一键
   * @return businessIdentity
  **/
  @Schema(required = true, description = "资源唯一键")
  public String getBusinessIdentity() {
    return businessIdentity;
  }

  public void setBusinessIdentity(String businessIdentity) {
    this.businessIdentity = businessIdentity;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Resource resource = (Resource) o;
    return Objects.equals(this.projectId, resource.projectId) &&
        Objects.equals(this.appId, resource.appId) &&
        Objects.equals(this.service, resource.service) &&
        Objects.equals(this.resourceType, resource.resourceType) &&
        Objects.equals(this.businessIdentity, resource.businessIdentity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, appId, service, resourceType, businessIdentity);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Resource {\n");
    
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    businessIdentity: ").append(toIndentedString(businessIdentity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
