/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.TagDistribution;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * TagCustomAnalysisResult
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-14T16:15:54.436+08:00[Asia/Shanghai]")
public class TagCustomAnalysisResult {
  @SerializedName("segName")
  private String segName = null;

  @SerializedName("isExperimental")
  private Boolean isExperimental = null;

  @SerializedName("segCount")
  private Long segCount = null;

  @SerializedName("tagSumInMau")
  private Long tagSumInMau = null;

  @SerializedName("tagSumInSeg")
  private Long tagSumInSeg = null;

  @SerializedName("segValidProportion")
  private Double segValidProportion = null;

  @SerializedName("tagId")
  private Integer tagId = null;

  @SerializedName("tagDistributions")
  private List<TagDistribution> tagDistributions = new ArrayList<TagDistribution>();

  public TagCustomAnalysisResult segName(String segName) {
    this.segName = segName;
    return this;
  }

   /**
   * 人群名称
   * @return segName
  **/
  @Schema(required = true, description = "人群名称")
  public String getSegName() {
    return segName;
  }

  public void setSegName(String segName) {
    this.segName = segName;
  }

  public TagCustomAnalysisResult isExperimental(Boolean isExperimental) {
    this.isExperimental = isExperimental;
    return this;
  }

   /**
   * 是否是对照分组
   * @return isExperimental
  **/
  @Schema(description = "是否是对照分组")
  public Boolean isIsExperimental() {
    return isExperimental;
  }

  public void setIsExperimental(Boolean isExperimental) {
    this.isExperimental = isExperimental;
  }

  public TagCustomAnalysisResult segCount(Long segCount) {
    this.segCount = segCount;
    return this;
  }

   /**
   * 人群数量
   * @return segCount
  **/
  @Schema(required = true, description = "人群数量")
  public Long getSegCount() {
    return segCount;
  }

  public void setSegCount(Long segCount) {
    this.segCount = segCount;
  }

  public TagCustomAnalysisResult tagSumInMau(Long tagSumInMau) {
    this.tagSumInMau = tagSumInMau;
    return this;
  }

   /**
   * 标签在全量人群中的总人数
   * @return tagSumInMau
  **/
  @Schema(required = true, description = "标签在全量人群中的总人数")
  public Long getTagSumInMau() {
    return tagSumInMau;
  }

  public void setTagSumInMau(Long tagSumInMau) {
    this.tagSumInMau = tagSumInMau;
  }

  public TagCustomAnalysisResult tagSumInSeg(Long tagSumInSeg) {
    this.tagSumInSeg = tagSumInSeg;
    return this;
  }

   /**
   * 标签在所选人群中的总人数
   * @return tagSumInSeg
  **/
  @Schema(required = true, description = "标签在所选人群中的总人数")
  public Long getTagSumInSeg() {
    return tagSumInSeg;
  }

  public void setTagSumInSeg(Long tagSumInSeg) {
    this.tagSumInSeg = tagSumInSeg;
  }

  public TagCustomAnalysisResult segValidProportion(Double segValidProportion) {
    this.segValidProportion = segValidProportion;
    return this;
  }

   /**
   * 人群有效占比
   * @return segValidProportion
  **/
  @Schema(required = true, description = "人群有效占比")
  public Double getSegValidProportion() {
    return segValidProportion;
  }

  public void setSegValidProportion(Double segValidProportion) {
    this.segValidProportion = segValidProportion;
  }

  public TagCustomAnalysisResult tagId(Integer tagId) {
    this.tagId = tagId;
    return this;
  }

   /**
   * 标签id
   * @return tagId
  **/
  @Schema(required = true, description = "标签id")
  public Integer getTagId() {
    return tagId;
  }

  public void setTagId(Integer tagId) {
    this.tagId = tagId;
  }

  public TagCustomAnalysisResult tagDistributions(List<TagDistribution> tagDistributions) {
    this.tagDistributions = tagDistributions;
    return this;
  }

  public TagCustomAnalysisResult addTagDistributionsItem(TagDistribution tagDistributionsItem) {
    this.tagDistributions.add(tagDistributionsItem);
    return this;
  }

   /**
   * 标签分布
   * @return tagDistributions
  **/
  @Schema(required = true, description = "标签分布")
  public List<TagDistribution> getTagDistributions() {
    return tagDistributions;
  }

  public void setTagDistributions(List<TagDistribution> tagDistributions) {
    this.tagDistributions = tagDistributions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TagCustomAnalysisResult tagCustomAnalysisResult = (TagCustomAnalysisResult) o;
    return Objects.equals(this.segName, tagCustomAnalysisResult.segName) &&
        Objects.equals(this.isExperimental, tagCustomAnalysisResult.isExperimental) &&
        Objects.equals(this.segCount, tagCustomAnalysisResult.segCount) &&
        Objects.equals(this.tagSumInMau, tagCustomAnalysisResult.tagSumInMau) &&
        Objects.equals(this.tagSumInSeg, tagCustomAnalysisResult.tagSumInSeg) &&
        Objects.equals(this.segValidProportion, tagCustomAnalysisResult.segValidProportion) &&
        Objects.equals(this.tagId, tagCustomAnalysisResult.tagId) &&
        Objects.equals(this.tagDistributions, tagCustomAnalysisResult.tagDistributions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(segName, isExperimental, segCount, tagSumInMau, tagSumInSeg, segValidProportion, tagId, tagDistributions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TagCustomAnalysisResult {\n");
    
    sb.append("    segName: ").append(toIndentedString(segName)).append("\n");
    sb.append("    isExperimental: ").append(toIndentedString(isExperimental)).append("\n");
    sb.append("    segCount: ").append(toIndentedString(segCount)).append("\n");
    sb.append("    tagSumInMau: ").append(toIndentedString(tagSumInMau)).append("\n");
    sb.append("    tagSumInSeg: ").append(toIndentedString(tagSumInSeg)).append("\n");
    sb.append("    segValidProportion: ").append(toIndentedString(segValidProportion)).append("\n");
    sb.append("    tagId: ").append(toIndentedString(tagId)).append("\n");
    sb.append("    tagDistributions: ").append(toIndentedString(tagDistributions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
