/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.TagDateRange;
import code.byted.inter.model.TagDateTimeRange;
import code.byted.inter.model.TagDecimalRange;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.threeten.bp.LocalDate;

/**
 * TagDistribution
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-14T16:15:54.436+08:00[Asia/Shanghai]")
public class TagDistribution {
  @SerializedName("tagProportion")
  private Double tagProportion = null;

  @SerializedName("tagValidProportion")
  private Double tagValidProportion = null;

  @SerializedName("tagTGI")
  private Long tagTGI = null;

  @SerializedName("mauTGI")
  private Long mauTGI = null;

  @SerializedName("customTGI")
  private Long customTGI = null;

  @SerializedName("countInSeg")
  private Long countInSeg = null;

  @SerializedName("countInMau")
  private Long countInMau = null;

  @SerializedName("countInCustomTGISeg")
  private Long countInCustomTGISeg = null;

  @SerializedName("tagShowValue")
  private String tagShowValue = null;

  @SerializedName("tagDateRange")
  private TagDateRange tagDateRange = null;

  @SerializedName("tagDateTimeRange")
  private TagDateTimeRange tagDateTimeRange = null;

  @SerializedName("tagDecimalRange")
  private TagDecimalRange tagDecimalRange = null;

  @SerializedName("tagDecimalValue")
  private Double tagDecimalValue = null;

  @SerializedName("tagStringValue")
  private String tagStringValue = null;

  @SerializedName("tagDateValue")
  private LocalDate tagDateValue = null;

  @SerializedName("tagDateTimeValue")
  private String tagDateTimeValue = null;

  public TagDistribution tagProportion(Double tagProportion) {
    this.tagProportion = tagProportion;
    return this;
  }

   /**
   * 标签值占比
   * @return tagProportion
  **/
  @Schema(required = true, description = "标签值占比")
  public Double getTagProportion() {
    return tagProportion;
  }

  public void setTagProportion(Double tagProportion) {
    this.tagProportion = tagProportion;
  }

  public TagDistribution tagValidProportion(Double tagValidProportion) {
    this.tagValidProportion = tagValidProportion;
    return this;
  }

   /**
   * 标签值有效占比
   * @return tagValidProportion
  **/
  @Schema(required = true, description = "标签值有效占比")
  public Double getTagValidProportion() {
    return tagValidProportion;
  }

  public void setTagValidProportion(Double tagValidProportion) {
    this.tagValidProportion = tagValidProportion;
  }

  public TagDistribution tagTGI(Long tagTGI) {
    this.tagTGI = tagTGI;
    return this;
  }

   /**
   * 标签TGI
   * @return tagTGI
  **/
  @Schema(required = true, description = "标签TGI")
  public Long getTagTGI() {
    return tagTGI;
  }

  public void setTagTGI(Long tagTGI) {
    this.tagTGI = tagTGI;
  }

  public TagDistribution mauTGI(Long mauTGI) {
    this.mauTGI = mauTGI;
    return this;
  }

   /**
   * 大盘TGI
   * @return mauTGI
  **/
  @Schema(required = true, description = "大盘TGI")
  public Long getMauTGI() {
    return mauTGI;
  }

  public void setMauTGI(Long mauTGI) {
    this.mauTGI = mauTGI;
  }

  public TagDistribution customTGI(Long customTGI) {
    this.customTGI = customTGI;
    return this;
  }

   /**
   * 自定义TGI
   * @return customTGI
  **/
  @Schema(description = "自定义TGI")
  public Long getCustomTGI() {
    return customTGI;
  }

  public void setCustomTGI(Long customTGI) {
    this.customTGI = customTGI;
  }

  public TagDistribution countInSeg(Long countInSeg) {
    this.countInSeg = countInSeg;
    return this;
  }

   /**
   * 标签值在所选人群中的数量
   * @return countInSeg
  **/
  @Schema(required = true, description = "标签值在所选人群中的数量")
  public Long getCountInSeg() {
    return countInSeg;
  }

  public void setCountInSeg(Long countInSeg) {
    this.countInSeg = countInSeg;
  }

  public TagDistribution countInMau(Long countInMau) {
    this.countInMau = countInMau;
    return this;
  }

   /**
   * 标签值在全量人群中的数量
   * @return countInMau
  **/
  @Schema(required = true, description = "标签值在全量人群中的数量")
  public Long getCountInMau() {
    return countInMau;
  }

  public void setCountInMau(Long countInMau) {
    this.countInMau = countInMau;
  }

  public TagDistribution countInCustomTGISeg(Long countInCustomTGISeg) {
    this.countInCustomTGISeg = countInCustomTGISeg;
    return this;
  }

   /**
   * 标签值在自定义TGI人群中的数量
   * @return countInCustomTGISeg
  **/
  @Schema(required = true, description = "标签值在自定义TGI人群中的数量")
  public Long getCountInCustomTGISeg() {
    return countInCustomTGISeg;
  }

  public void setCountInCustomTGISeg(Long countInCustomTGISeg) {
    this.countInCustomTGISeg = countInCustomTGISeg;
  }

  public TagDistribution tagShowValue(String tagShowValue) {
    this.tagShowValue = tagShowValue;
    return this;
  }

   /**
   * 标签值展示值
   * @return tagShowValue
  **/
  @Schema(required = true, description = "标签值展示值")
  public String getTagShowValue() {
    return tagShowValue;
  }

  public void setTagShowValue(String tagShowValue) {
    this.tagShowValue = tagShowValue;
  }

  public TagDistribution tagDateRange(TagDateRange tagDateRange) {
    this.tagDateRange = tagDateRange;
    return this;
  }

   /**
   * Get tagDateRange
   * @return tagDateRange
  **/
  @Schema(description = "")
  public TagDateRange getTagDateRange() {
    return tagDateRange;
  }

  public void setTagDateRange(TagDateRange tagDateRange) {
    this.tagDateRange = tagDateRange;
  }

  public TagDistribution tagDateTimeRange(TagDateTimeRange tagDateTimeRange) {
    this.tagDateTimeRange = tagDateTimeRange;
    return this;
  }

   /**
   * Get tagDateTimeRange
   * @return tagDateTimeRange
  **/
  @Schema(description = "")
  public TagDateTimeRange getTagDateTimeRange() {
    return tagDateTimeRange;
  }

  public void setTagDateTimeRange(TagDateTimeRange tagDateTimeRange) {
    this.tagDateTimeRange = tagDateTimeRange;
  }

  public TagDistribution tagDecimalRange(TagDecimalRange tagDecimalRange) {
    this.tagDecimalRange = tagDecimalRange;
    return this;
  }

   /**
   * Get tagDecimalRange
   * @return tagDecimalRange
  **/
  @Schema(description = "")
  public TagDecimalRange getTagDecimalRange() {
    return tagDecimalRange;
  }

  public void setTagDecimalRange(TagDecimalRange tagDecimalRange) {
    this.tagDecimalRange = tagDecimalRange;
  }

  public TagDistribution tagDecimalValue(Double tagDecimalValue) {
    this.tagDecimalValue = tagDecimalValue;
    return this;
  }

   /**
   * 数值型标签值
   * @return tagDecimalValue
  **/
  @Schema(description = "数值型标签值")
  public Double getTagDecimalValue() {
    return tagDecimalValue;
  }

  public void setTagDecimalValue(Double tagDecimalValue) {
    this.tagDecimalValue = tagDecimalValue;
  }

  public TagDistribution tagStringValue(String tagStringValue) {
    this.tagStringValue = tagStringValue;
    return this;
  }

   /**
   * 字符型标签值
   * @return tagStringValue
  **/
  @Schema(description = "字符型标签值")
  public String getTagStringValue() {
    return tagStringValue;
  }

  public void setTagStringValue(String tagStringValue) {
    this.tagStringValue = tagStringValue;
  }

  public TagDistribution tagDateValue(LocalDate tagDateValue) {
    this.tagDateValue = tagDateValue;
    return this;
  }

   /**
   * 特定日期
   * @return tagDateValue
  **/
  @Schema(description = "特定日期")
  public LocalDate getTagDateValue() {
    return tagDateValue;
  }

  public void setTagDateValue(LocalDate tagDateValue) {
    this.tagDateValue = tagDateValue;
  }

  public TagDistribution tagDateTimeValue(String tagDateTimeValue) {
    this.tagDateTimeValue = tagDateTimeValue;
    return this;
  }

   /**
   * 特定日期时间
   * @return tagDateTimeValue
  **/
  @Schema(description = "特定日期时间")
  public String getTagDateTimeValue() {
    return tagDateTimeValue;
  }

  public void setTagDateTimeValue(String tagDateTimeValue) {
    this.tagDateTimeValue = tagDateTimeValue;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TagDistribution tagDistribution = (TagDistribution) o;
    return Objects.equals(this.tagProportion, tagDistribution.tagProportion) &&
        Objects.equals(this.tagValidProportion, tagDistribution.tagValidProportion) &&
        Objects.equals(this.tagTGI, tagDistribution.tagTGI) &&
        Objects.equals(this.mauTGI, tagDistribution.mauTGI) &&
        Objects.equals(this.customTGI, tagDistribution.customTGI) &&
        Objects.equals(this.countInSeg, tagDistribution.countInSeg) &&
        Objects.equals(this.countInMau, tagDistribution.countInMau) &&
        Objects.equals(this.countInCustomTGISeg, tagDistribution.countInCustomTGISeg) &&
        Objects.equals(this.tagShowValue, tagDistribution.tagShowValue) &&
        Objects.equals(this.tagDateRange, tagDistribution.tagDateRange) &&
        Objects.equals(this.tagDateTimeRange, tagDistribution.tagDateTimeRange) &&
        Objects.equals(this.tagDecimalRange, tagDistribution.tagDecimalRange) &&
        Objects.equals(this.tagDecimalValue, tagDistribution.tagDecimalValue) &&
        Objects.equals(this.tagStringValue, tagDistribution.tagStringValue) &&
        Objects.equals(this.tagDateValue, tagDistribution.tagDateValue) &&
        Objects.equals(this.tagDateTimeValue, tagDistribution.tagDateTimeValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tagProportion, tagValidProportion, tagTGI, mauTGI, customTGI, countInSeg, countInMau, countInCustomTGISeg, tagShowValue, tagDateRange, tagDateTimeRange, tagDecimalRange, tagDecimalValue, tagStringValue, tagDateValue, tagDateTimeValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TagDistribution {\n");
    
    sb.append("    tagProportion: ").append(toIndentedString(tagProportion)).append("\n");
    sb.append("    tagValidProportion: ").append(toIndentedString(tagValidProportion)).append("\n");
    sb.append("    tagTGI: ").append(toIndentedString(tagTGI)).append("\n");
    sb.append("    mauTGI: ").append(toIndentedString(mauTGI)).append("\n");
    sb.append("    customTGI: ").append(toIndentedString(customTGI)).append("\n");
    sb.append("    countInSeg: ").append(toIndentedString(countInSeg)).append("\n");
    sb.append("    countInMau: ").append(toIndentedString(countInMau)).append("\n");
    sb.append("    countInCustomTGISeg: ").append(toIndentedString(countInCustomTGISeg)).append("\n");
    sb.append("    tagShowValue: ").append(toIndentedString(tagShowValue)).append("\n");
    sb.append("    tagDateRange: ").append(toIndentedString(tagDateRange)).append("\n");
    sb.append("    tagDateTimeRange: ").append(toIndentedString(tagDateTimeRange)).append("\n");
    sb.append("    tagDecimalRange: ").append(toIndentedString(tagDecimalRange)).append("\n");
    sb.append("    tagDecimalValue: ").append(toIndentedString(tagDecimalValue)).append("\n");
    sb.append("    tagStringValue: ").append(toIndentedString(tagStringValue)).append("\n");
    sb.append("    tagDateValue: ").append(toIndentedString(tagDateValue)).append("\n");
    sb.append("    tagDateTimeValue: ").append(toIndentedString(tagDateTimeValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
