/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.openapi;

import code.byted.inter.ApiCallback;
import code.byted.inter.ApiClient;
import code.byted.inter.ApiException;
import code.byted.inter.ApiResponse;
import code.byted.inter.Configuration;
import code.byted.inter.Pair;
import code.byted.inter.ProgressRequestBody;
import code.byted.inter.ProgressResponseBody;

import code.byted.inter.model.CommonResponseBoolean;
import code.byted.inter.model.CommonResponseLong;
import code.byted.inter.model.CommonResponseOperateResult;
import code.byted.inter.model.CreateDataSourceByNativeRequest;
import code.byted.inter.model.CreateDataSourceRequest;
import code.byted.inter.model.DatasetCreateRequest;
import code.byted.inter.model.DatasetUpdateRequest;
import code.byted.inter.model.ListCdpPropertyVo;
import code.byted.inter.model.ListDataSourceListItemVo;
import code.byted.inter.model.UpdateDataSourceRequest;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.inter.model.CommonResponseListDataSourceMetaVo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasourceApi {
    private ApiClient apiClient;

    public DatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for querypropertyList
     * @param dataSourceId 数据源id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call querypropertyListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","querypropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call querypropertyListValidateBeforeCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyList(Async)");
        }

        com.squareup.okhttp.Call call = querypropertyListCall(dataSourceId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取数据源字段列表
     * 按数据源id获取CDP数据源字段列表，对应CDP元数据管理中的数据源
     * @param dataSourceId 数据源id (required)
     * @return ListCdpPropertyVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpPropertyVo querypropertyList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpPropertyVo> resp = querypropertyListWithHttpInfo(dataSourceId);
        return resp.getData();
    }


    /**
     * 获取数据源字段列表
     * 按数据源id获取CDP数据源字段列表，对应CDP元数据管理中的数据源
     * @param dataSourceId 数据源id (required)
     * @return ApiResponse&lt;ListCdpPropertyVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpPropertyVo> querypropertyListWithHttpInfo(Integer dataSourceId) throws ApiException {
        com.squareup.okhttp.Call call = querypropertyListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取数据源字段列表 (asynchronously)
     * 按数据源id获取CDP数据源字段列表，对应CDP元数据管理中的数据源
     * @param dataSourceId 数据源id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call querypropertyListAsync(Integer dataSourceId, final ApiCallback<ListCdpPropertyVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = querypropertyListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for queryByDbTable
     * @param xTenant 租户id (required)
     * @param subjectId 主体id (required)
     * @param tableType 表类型 (required)
     * @param database 库名 (required)
     * @param table 表名 (required)
     * @param cluster 集群名 (optional)
     * @param region 区域 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryByDbTableCall(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));
        if (tableType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tableType", tableType));
        if (cluster != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("cluster", cluster));
        if (region != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("region", region));
        if (database != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("database", database));
        if (table != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("table", table));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryByDbTable"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-06-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryByDbTableValidateBeforeCall(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryByDbTable(Async)");
        }
        // verify the required parameter 'subjectId' is set
        if (subjectId == null) {
            throw new ApiException("Missing the required parameter 'subjectId' when calling queryByDbTable(Async)");
        }
        // verify the required parameter 'tableType' is set
        if (tableType == null) {
            throw new ApiException("Missing the required parameter 'tableType' when calling queryByDbTable(Async)");
        }
        // verify the required parameter 'database' is set
        if (database == null) {
            throw new ApiException("Missing the required parameter 'database' when calling queryByDbTable(Async)");
        }
        // verify the required parameter 'table' is set
        if (table == null) {
            throw new ApiException("Missing the required parameter 'table' when calling queryByDbTable(Async)");
        }

        com.squareup.okhttp.Call call = queryByDbTableCall(xTenant, subjectId, tableType, database, table, cluster, region, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 根据底表查询数据源
     * 标签审批状态更新
     * @param xTenant 租户id (required)
     * @param subjectId 主体id (required)
     * @param tableType 表类型 (required)
     * @param database 库名 (required)
     * @param table 表名 (required)
     * @param cluster 集群名 (optional)
     * @param region 区域 (optional)
     * @return CommonResponseListDataSourceMetaVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseListDataSourceMetaVo queryByDbTable(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region) throws ApiException {
        ApiResponse<CommonResponseListDataSourceMetaVo> resp = queryByDbTableWithHttpInfo(xTenant, subjectId, tableType, database, table, cluster, region);
        return resp.getData();
    }


    /**
     * 根据底表查询数据源
     * 标签审批状态更新
     * @param xTenant 租户id (required)
     * @param subjectId 主体id (required)
     * @param tableType 表类型 (required)
     * @param database 库名 (required)
     * @param table 表名 (required)
     * @param cluster 集群名 (optional)
     * @param region 区域 (optional)
     * @return ApiResponse&lt;CommonResponseListDataSourceMetaVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseListDataSourceMetaVo> queryByDbTableWithHttpInfo(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region) throws ApiException {
        com.squareup.okhttp.Call call = queryByDbTableValidateBeforeCall(xTenant, subjectId, tableType, database, table, cluster, region, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListDataSourceMetaVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 根据底表查询数据源 (asynchronously)
     * 标签审批状态更新
     * @param xTenant 租户id (required)
     * @param subjectId 主体id (required)
     * @param tableType 表类型 (required)
     * @param database 库名 (required)
     * @param table 表名 (required)
     * @param cluster 集群名 (optional)
     * @param region 区域 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryByDbTableAsync(Long xTenant, Long subjectId, String tableType, String database, String table, String cluster, String region, final ApiCallback<CommonResponseListDataSourceMetaVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = queryByDbTableValidateBeforeCall(xTenant, subjectId, tableType, database, table, cluster, region, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListDataSourceMetaVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createDataSource
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createDataSourceCall(CreateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createDataSource"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createDataSourceValidateBeforeCall(CreateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDataSource(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createDataSource(Async)");
        }

        com.squareup.okhttp.Call call = createDataSourceCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建数据档案
     * 创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return CommonResponseLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLong createDataSource(CreateDataSourceRequest body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = createDataSourceWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建数据档案
     * 创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return ApiResponse&lt;CommonResponseLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLong> createDataSourceWithHttpInfo(CreateDataSourceRequest body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createDataSourceValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建数据档案 (asynchronously)
     * 创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createDataSourceAsync(CreateDataSourceRequest body, Long xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = createDataSourceValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for createDataset
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createDatasetCall(DatasetCreateRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createDataset"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createDatasetValidateBeforeCall(DatasetCreateRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDataset(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createDataset(Async)");
        }

        com.squareup.okhttp.Call call = createDatasetCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建数据集
     * 创建数据集
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return CommonResponseLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLong createDataset(DatasetCreateRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = createDatasetWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建数据集
     * 创建数据集
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;CommonResponseLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLong> createDatasetWithHttpInfo(DatasetCreateRequest body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createDatasetValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建数据集 (asynchronously)
     * 创建数据集
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createDatasetAsync(DatasetCreateRequest body, Integer xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = createDatasetValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteDataset
     * @param id 数据集id (required)
     * @param xTenant  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDatasetCall(Integer id, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("id", id.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteDataset"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDatasetValidateBeforeCall(Integer id, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteDataset(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteDataset(Async)");
        }

        com.squareup.okhttp.Call call = deleteDatasetCall(id, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除数据集
     * 删除数据集
     * @param id 数据集id (required)
     * @param xTenant  (required)
     * @return CommonResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseBoolean deleteDataset(Integer id, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = deleteDatasetWithHttpInfo(id, xTenant);
        return resp.getData();
    }


    /**
     * 删除数据集
     * 删除数据集
     * @param id 数据集id (required)
     * @param xTenant  (required)
     * @return ApiResponse&lt;CommonResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseBoolean> deleteDatasetWithHttpInfo(Integer id, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = deleteDatasetValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除数据集 (asynchronously)
     * 删除数据集
     * @param id 数据集id (required)
     * @param xTenant  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDatasetAsync(Integer id, Integer xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = deleteDatasetValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for updateDataset
     * @param body  (required)
     * @param xTenant  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateDatasetCall(DatasetUpdateRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","updateDataset"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateDatasetValidateBeforeCall(DatasetUpdateRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateDataset(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateDataset(Async)");
        }

        com.squareup.okhttp.Call call = updateDatasetCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 更新数据集
     * 更新数据集
     * @param body  (required)
     * @param xTenant  (required)
     * @return CommonResponseLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLong updateDataset(DatasetUpdateRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = updateDatasetWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 更新数据集
     * 更新数据集
     * @param body  (required)
     * @param xTenant  (required)
     * @return ApiResponse&lt;CommonResponseLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLong> updateDatasetWithHttpInfo(DatasetUpdateRequest body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = updateDatasetValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 更新数据集 (asynchronously)
     * 更新数据集
     * @param body  (required)
     * @param xTenant  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateDatasetAsync(DatasetUpdateRequest body, Integer xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = updateDatasetValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for createDataSourceByNative
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createDataSourceByNativeCall(CreateDataSourceByNativeRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createDataSourceByNative"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createDataSourceByNativeValidateBeforeCall(CreateDataSourceByNativeRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDataSourceByNative(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createDataSourceByNative(Async)");
        }

        com.squareup.okhttp.Call call = createDataSourceByNativeCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 使用原表创建数据档案
     * 使用原表创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return CommonResponseLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLong createDataSourceByNative(CreateDataSourceByNativeRequest body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseLong> resp = createDataSourceByNativeWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 使用原表创建数据档案
     * 使用原表创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return ApiResponse&lt;CommonResponseLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLong> createDataSourceByNativeWithHttpInfo(CreateDataSourceByNativeRequest body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createDataSourceByNativeValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 使用原表创建数据档案 (asynchronously)
     * 使用原表创建数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createDataSourceByNativeAsync(CreateDataSourceByNativeRequest body, Long xTenant, final ApiCallback<CommonResponseLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = createDataSourceByNativeValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLong>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for updateDataSource
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateDataSourceCall(UpdateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","updateDataSource"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateDataSourceValidateBeforeCall(UpdateDataSourceRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateDataSource(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateDataSource(Async)");
        }

        com.squareup.okhttp.Call call = updateDataSourceCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 更新数据档案
     * 更新数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return CommonResponseOperateResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseOperateResult updateDataSource(UpdateDataSourceRequest body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseOperateResult> resp = updateDataSourceWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 更新数据档案
     * 更新数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @return ApiResponse&lt;CommonResponseOperateResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseOperateResult> updateDataSourceWithHttpInfo(UpdateDataSourceRequest body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = updateDataSourceValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseOperateResult>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 更新数据档案 (asynchronously)
     * 更新数据档案
     * @param body  (required)
     * @param xTenant 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateDataSourceAsync(UpdateDataSourceRequest body, Long xTenant, final ApiCallback<CommonResponseOperateResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = updateDataSourceValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseOperateResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for deleteDataSource
     * @param id 数据档案id (required)
     * @param xTenant  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteDataSourceCall(Integer id, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("id", id.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteDataSource"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteDataSourceValidateBeforeCall(Integer id, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteDataSource(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteDataSource(Async)");
        }

        com.squareup.okhttp.Call call = deleteDataSourceCall(id, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除数据档案
     * 删除数据档案
     * @param id 数据档案id (required)
     * @param xTenant  (required)
     * @return CommonResponseOperateResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseOperateResult deleteDataSource(Integer id, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseOperateResult> resp = deleteDataSourceWithHttpInfo(id, xTenant);
        return resp.getData();
    }


    /**
     * 删除数据档案
     * 删除数据档案
     * @param id 数据档案id (required)
     * @param xTenant  (required)
     * @return ApiResponse&lt;CommonResponseOperateResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseOperateResult> deleteDataSourceWithHttpInfo(Integer id, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = deleteDataSourceValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseOperateResult>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除数据档案 (asynchronously)
     * 删除数据档案
     * @param id 数据档案id (required)
     * @param xTenant  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteDataSourceAsync(Integer id, Integer xTenant, final ApiCallback<CommonResponseOperateResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = deleteDataSourceValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseOperateResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for queryDataSourceList
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryDataSourceListCall(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourceName != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("sourceName", sourceName));
        if (sourceType != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("sourceType", sourceType));
        if (subjectId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryDataSourceList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryDataSourceListValidateBeforeCall(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryDataSourceList(Async)");
        }

        com.squareup.okhttp.Call call = queryDataSourceListCall(xTenant, sourceName, sourceType, subjectId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取数据源列表
     * 按租户获取数据源列表
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @return ListDataSourceListItemVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListDataSourceListItemVo queryDataSourceList(Long xTenant, String sourceName, Integer sourceType, Integer subjectId) throws ApiException {
        ApiResponse<ListDataSourceListItemVo> resp = queryDataSourceListWithHttpInfo(xTenant, sourceName, sourceType, subjectId);
        return resp.getData();
    }


    /**
     * 获取数据源列表
     * 按租户获取数据源列表
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @return ApiResponse&lt;ListDataSourceListItemVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListDataSourceListItemVo> queryDataSourceListWithHttpInfo(Long xTenant, String sourceName, Integer sourceType, Integer subjectId) throws ApiException {
        com.squareup.okhttp.Call call = queryDataSourceListValidateBeforeCall(xTenant, sourceName, sourceType, subjectId, null, null);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取数据源列表 (asynchronously)
     * 按租户获取数据源列表
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryDataSourceListAsync(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ApiCallback<ListDataSourceListItemVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryDataSourceListValidateBeforeCall(xTenant, sourceName, sourceType, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
