/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.rocketmq.logging.inner;

import com.volcengine.rocketmq.logging.inner.Appender;
import com.volcengine.rocketmq.logging.inner.Level;
import com.volcengine.rocketmq.logging.inner.LoggingEvent;
import com.volcengine.rocketmq.logging.inner.SysLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Logger
implements Appender.AppenderPipeline {
    private static final String FQCN = Logger.class.getName();
    private static final DefaultLoggerRepository REPOSITORY = new DefaultLoggerRepository(new RootLogger(Level.DEBUG));
    private String name;
    private volatile Level level;
    private volatile Logger parent;
    Appender.AppenderPipelineImpl appenderPipeline;
    private boolean additive = true;

    public static LoggerRepository getRepository() {
        return REPOSITORY;
    }

    private Logger(String name) {
        this.name = name;
    }

    public static Logger getLogger(String name) {
        return Logger.getRepository().getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getRepository().getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return Logger.getRepository().getRootLogger();
    }

    @Override
    public synchronized void addAppender(Appender newAppender) {
        if (this.appenderPipeline == null) {
            this.appenderPipeline = new Appender.AppenderPipelineImpl();
        }
        this.appenderPipeline.addAppender(newAppender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        Logger logger = this;
        while (logger != null) {
            Logger logger2 = logger;
            synchronized (logger2) {
                if (logger.appenderPipeline != null) {
                    writes += logger.appenderPipeline.appendLoopOnAppenders(event);
                }
                if (!logger.additive) {
                    break;
                }
            }
            logger = logger.parent;
        }
        if (writes == 0) {
            Logger.getRepository().emitNoAppenderWarning(this);
        }
    }

    synchronized void closeNestedAppenders() {
        Enumeration enumeration = this.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Appender a = (Appender)enumeration.nextElement();
                if (!(a instanceof Appender.AppenderPipeline)) continue;
                a.close();
            }
        }
    }

    public void debug(Object message) {
        if (Logger.getRepository().isDisabled(10000)) {
            return;
        }
        if (Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (Logger.getRepository().isDisabled(10000)) {
            return;
        }
        if (Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.DEBUG, message, t);
        }
    }

    public void error(Object message) {
        if (Logger.getRepository().isDisabled(40000)) {
            return;
        }
        if (Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (Logger.getRepository().isDisabled(40000)) {
            return;
        }
        if (Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.ERROR, message, t);
        }
    }

    protected void forcedLog(String fqcn, Level level, Object message, Throwable t) {
        this.callAppenders(new LoggingEvent(fqcn, this, level, message, t));
    }

    @Override
    public synchronized Enumeration getAllAppenders() {
        if (this.appenderPipeline == null) {
            return null;
        }
        return this.appenderPipeline.getAllAppenders();
    }

    @Override
    public synchronized Appender getAppender(String name) {
        if (this.appenderPipeline == null || name == null) {
            return null;
        }
        return this.appenderPipeline.getAppender(name);
    }

    public Level getEffectiveLevel() {
        Logger c = this;
        while (c != null) {
            if (c.level != null) {
                return c.level;
            }
            c = c.parent;
        }
        return null;
    }

    public final String getName() {
        return this.name;
    }

    public final Level getLevel() {
        return this.level;
    }

    public void info(Object message) {
        if (Logger.getRepository().isDisabled(20000)) {
            return;
        }
        if (Level.INFO.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (Logger.getRepository().isDisabled(20000)) {
            return;
        }
        if (Level.INFO.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.INFO, message, t);
        }
    }

    @Override
    public boolean isAttached(Appender appender) {
        return appender != null && this.appenderPipeline != null && this.appenderPipeline.isAttached(appender);
    }

    @Override
    public synchronized void removeAllAppenders() {
        if (this.appenderPipeline != null) {
            this.appenderPipeline.removeAllAppenders();
            this.appenderPipeline = null;
        }
    }

    @Override
    public synchronized void removeAppender(Appender appender) {
        if (appender == null || this.appenderPipeline == null) {
            return;
        }
        this.appenderPipeline.removeAppender(appender);
    }

    @Override
    public synchronized void removeAppender(String name) {
        if (name == null || this.appenderPipeline == null) {
            return;
        }
        this.appenderPipeline.removeAppender(name);
    }

    public void setAdditivity(boolean additive) {
        this.additive = additive;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void warn(Object message) {
        if (Logger.getRepository().isDisabled(30000)) {
            return;
        }
        if (Level.WARN.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (Logger.getRepository().isDisabled(30000)) {
            return;
        }
        if (Level.WARN.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.WARN, message, t);
        }
    }

    public static class RootLogger
    extends Logger {
        public RootLogger(Level level) {
            super("root");
            this.setLevel(level);
        }
    }

    public static class DefaultLoggerRepository
    implements LoggerRepository {
        final Hashtable<CategoryKey, Object> ht = new Hashtable();
        Logger root;
        int logLevelInt;
        Level logLevel;
        boolean emittedNoAppenderWarning = false;

        public DefaultLoggerRepository(Logger root) {
            this.root = root;
            this.setLogLevel(Level.ALL);
        }

        @Override
        public void emitNoAppenderWarning(Logger cat) {
            if (!this.emittedNoAppenderWarning) {
                SysLogger.warn("No appenders could be found for logger (" + cat.getName() + ").");
                SysLogger.warn("Please initialize the logger system properly.");
                this.emittedNoAppenderWarning = true;
            }
        }

        @Override
        public Logger exists(String name) {
            Object o = this.ht.get(new CategoryKey(name));
            if (o instanceof Logger) {
                return (Logger)o;
            }
            return null;
        }

        @Override
        public void setLogLevel(Level l) {
            if (l != null) {
                this.logLevelInt = l.level;
                this.logLevel = l;
            }
        }

        @Override
        public Level getLogLevel() {
            return this.logLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Logger getLogger(String name) {
            CategoryKey key = new CategoryKey(name);
            Hashtable<CategoryKey, Object> hashtable = this.ht;
            synchronized (hashtable) {
                Object o = this.ht.get(key);
                if (o == null) {
                    Logger logger = this.makeNewLoggerInstance(name);
                    this.ht.put(key, logger);
                    this.updateParents(logger);
                    return logger;
                }
                if (o instanceof Logger) {
                    return (Logger)o;
                }
                if (o instanceof ProvisionNode) {
                    Logger logger = this.makeNewLoggerInstance(name);
                    this.ht.put(key, logger);
                    this.updateChildren((ProvisionNode)o, logger);
                    this.updateParents(logger);
                    return logger;
                }
                return null;
            }
        }

        public Logger makeNewLoggerInstance(String name) {
            return new Logger(name);
        }

        @Override
        public Enumeration getCurrentLoggers() {
            Vector<Logger> loggers = new Vector<Logger>(this.ht.size());
            Enumeration<Object> elems = this.ht.elements();
            while (elems.hasMoreElements()) {
                Object o = elems.nextElement();
                if (!(o instanceof Logger)) continue;
                Logger logger = (Logger)o;
                loggers.addElement(logger);
            }
            return loggers.elements();
        }

        @Override
        public Logger getRootLogger() {
            return this.root;
        }

        @Override
        public boolean isDisabled(int level) {
            return this.logLevelInt > level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            Logger root = this.getRootLogger();
            root.closeNestedAppenders();
            Hashtable<CategoryKey, Object> hashtable = this.ht;
            synchronized (hashtable) {
                Enumeration cats = this.getCurrentLoggers();
                while (cats.hasMoreElements()) {
                    Logger c = (Logger)cats.nextElement();
                    c.closeNestedAppenders();
                }
                root.removeAllAppenders();
            }
        }

        private void updateParents(Logger cat) {
            String name = cat.name;
            int length = name.length();
            boolean parentFound = false;
            int i = name.lastIndexOf(46, length - 1);
            while (i >= 0) {
                String substr = name.substring(0, i);
                CategoryKey key = new CategoryKey(substr);
                Object o = this.ht.get(key);
                if (o == null) {
                    this.ht.put(key, new ProvisionNode(cat));
                } else {
                    if (o instanceof Logger) {
                        parentFound = true;
                        cat.parent = (Logger)o;
                        break;
                    }
                    if (o instanceof ProvisionNode) {
                        ((ProvisionNode)o).addElement(cat);
                    } else {
                        IllegalStateException e = new IllegalStateException("unexpected object type " + o.getClass() + " in ht.");
                        e.printStackTrace();
                    }
                }
                i = name.lastIndexOf(46, i - 1);
            }
            if (!parentFound) {
                cat.parent = this.root;
            }
        }

        private void updateChildren(ProvisionNode pn, Logger logger) {
            int last = pn.size();
            for (int i = 0; i < last; ++i) {
                Logger l = (Logger)pn.elementAt(i);
                if (l.parent.name.startsWith(logger.name)) continue;
                logger.parent = l.parent;
                l.parent = logger;
            }
        }

        private class CategoryKey {
            String name;
            int hashCache;

            CategoryKey(String name) {
                this.name = name;
                this.hashCache = name.hashCode();
            }

            public final int hashCode() {
                return this.hashCache;
            }

            public final boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o != null && o instanceof CategoryKey) {
                    CategoryKey cc = (CategoryKey)o;
                    return this.name.equals(cc.name);
                }
                return false;
            }
        }
    }

    public static class ProvisionNode
    extends Vector<Logger> {
        ProvisionNode(Logger logger) {
            this.addElement(logger);
        }
    }

    public static interface LoggerRepository {
        public boolean isDisabled(int var1);

        public void setLogLevel(Level var1);

        public void emitNoAppenderWarning(Logger var1);

        public Level getLogLevel();

        public Logger getLogger(String var1);

        public Logger getRootLogger();

        public Logger exists(String var1);

        public void shutdown();

        public Enumeration getCurrentLoggers();
    }
}

