/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.rocketmq.logging.inner;

import com.volcengine.rocketmq.logging.inner.Appender;
import com.volcengine.rocketmq.logging.inner.Layout;
import com.volcengine.rocketmq.logging.inner.Logger;
import com.volcengine.rocketmq.logging.inner.LoggingEvent;
import com.volcengine.rocketmq.logging.inner.SysLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class LoggingBuilder {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    public static final String LOGGING_ENCODING = "rocketmq.logging.inner.encoding";
    public static final String ENCODING = System.getProperty("rocketmq.logging.inner.encoding", "UTF-8");

    public static AppenderBuilder newAppenderBuilder() {
        return new AppenderBuilder();
    }

    public static LayoutBuilder newLayoutBuilder() {
        return new LayoutBuilder();
    }

    public static class DefaultLayout
    extends Layout {
        @Override
        public String format(LoggingEvent event) {
            StringBuilder sb = new StringBuilder();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            String format = simpleDateFormat.format(new Date(event.timeStamp));
            sb.append(format);
            sb.append(" ");
            sb.append(event.getLevel());
            sb.append(" ");
            sb.append(event.getLoggerName());
            sb.append(" - ");
            sb.append(event.getMessage());
            String[] throwableStr = event.getThrowableStr();
            if (throwableStr != null) {
                sb.append("\r\n");
                for (String s : throwableStr) {
                    sb.append(s);
                    sb.append("\r\n");
                }
            }
            sb.append("\r\n");
            return sb.toString();
        }

        @Override
        public boolean ignoresThrowable() {
            return false;
        }
    }

    public static class SimpleLayout
    extends Layout {
        @Override
        public String format(LoggingEvent event) {
            StringBuilder sb = new StringBuilder();
            sb.append(event.getLevel().toString());
            sb.append(" - ");
            sb.append(event.getRenderedMessage());
            sb.append("\r\n");
            return sb.toString();
        }

        @Override
        public boolean ignoresThrowable() {
            return false;
        }
    }

    public static class LayoutBuilder {
        private Layout layout;

        public LayoutBuilder withSimpleLayout() {
            this.layout = new SimpleLayout();
            return this;
        }

        public LayoutBuilder withDefaultLayout() {
            this.layout = new DefaultLayout();
            return this;
        }

        public Layout build() {
            if (this.layout == null) {
                this.layout = new SimpleLayout();
            }
            return this.layout;
        }
    }

    public static class ConsoleAppender
    extends WriterAppender {
        protected String target = "System.out";

        public void setTarget(String value) {
            String v = value.trim();
            if (LoggingBuilder.SYSTEM_OUT.equalsIgnoreCase(v)) {
                this.target = LoggingBuilder.SYSTEM_OUT;
            } else if (LoggingBuilder.SYSTEM_ERR.equalsIgnoreCase(v)) {
                this.target = LoggingBuilder.SYSTEM_ERR;
            } else {
                this.targetWarn(value);
            }
        }

        public String getTarget() {
            return this.target;
        }

        void targetWarn(String val) {
            SysLogger.warn("[" + val + "] should be System.out or System.err.");
            SysLogger.warn("Using previously set target, System.out by default.");
        }

        @Override
        public void activateOptions() {
            if (this.target.equals(LoggingBuilder.SYSTEM_ERR)) {
                this.setWriter(this.createWriter(System.err));
            } else {
                this.setWriter(this.createWriter(System.out));
            }
            super.activateOptions();
        }

        @Override
        protected final void closeWriter() {
        }
    }

    private static class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type = -1;

        RollingCalendar() {
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }

    public static class DailyRollingFileAppender
    extends FileAppender {
        static final int TOP_OF_TROUBLE = -1;
        static final int TOP_OF_MINUTE = 0;
        static final int TOP_OF_HOUR = 1;
        static final int HALF_DAY = 2;
        static final int TOP_OF_DAY = 3;
        static final int TOP_OF_WEEK = 4;
        static final int TOP_OF_MONTH = 5;
        private String datePattern = "'.'yyyy-MM-dd";
        private String scheduledFilename;
        private long nextCheck = System.currentTimeMillis() - 1L;
        Date now = new Date();
        SimpleDateFormat sdf;
        RollingCalendar rc = new RollingCalendar();
        final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

        public void setDatePattern(String pattern) {
            this.datePattern = pattern;
        }

        public String getDatePattern() {
            return this.datePattern;
        }

        @Override
        public void activateOptions() {
            super.activateOptions();
            if (this.datePattern != null && this.fileName != null) {
                this.now.setTime(System.currentTimeMillis());
                this.sdf = new SimpleDateFormat(this.datePattern);
                int type = this.computeCheckPeriod();
                this.printPeriodicity(type);
                this.rc.setType(type);
                File file = new File(this.fileName);
                this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
            } else {
                SysLogger.error("Either File or DatePattern options are not set for appender [" + this.name + "].");
            }
        }

        void printPeriodicity(int type) {
            switch (type) {
                case 0: {
                    SysLogger.debug("Appender [" + this.name + "] to be rolled every minute.");
                    break;
                }
                case 1: {
                    SysLogger.debug("Appender [" + this.name + "] to be rolled on top of every hour.");
                    break;
                }
                case 2: {
                    SysLogger.debug("Appender [" + this.name + "] to be rolled at midday and midnight.");
                    break;
                }
                case 3: {
                    SysLogger.debug("Appender [" + this.name + "] to be rolled at midnight.");
                    break;
                }
                case 4: {
                    SysLogger.debug("Appender [" + this.name + "] to be rolled at start of week.");
                    break;
                }
                case 5: {
                    SysLogger.debug("Appender [" + this.name + "] to be rolled at start of every month.");
                    break;
                }
                default: {
                    SysLogger.warn("Unknown periodicity for appender [" + this.name + "].");
                }
            }
        }

        int computeCheckPeriod() {
            RollingCalendar rollingCalendar = new RollingCalendar(this.gmtTimeZone, Locale.getDefault());
            Date epoch = new Date(0L);
            if (this.datePattern != null) {
                for (int i = 0; i <= 5; ++i) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                    simpleDateFormat.setTimeZone(this.gmtTimeZone);
                    String r0 = simpleDateFormat.format(epoch);
                    rollingCalendar.setType(i);
                    Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                    String r1 = simpleDateFormat.format(next);
                    if (r0 == null || r1 == null || r0.equals(r1)) continue;
                    return i;
                }
            }
            return -1;
        }

        void rollOver() throws IOException {
            File file;
            boolean result;
            if (this.datePattern == null) {
                this.handleError("Missing DatePattern option in rollOver().");
                return;
            }
            String datedFilename = this.fileName + this.sdf.format(this.now);
            if (this.scheduledFilename.equals(datedFilename)) {
                return;
            }
            this.closeFile();
            File target = new File(this.scheduledFilename);
            if (target.exists() && !target.delete()) {
                SysLogger.error("Failed to delete [" + this.scheduledFilename + "].");
            }
            if (result = (file = new File(this.fileName)).renameTo(target)) {
                SysLogger.debug(this.fileName + " -> " + this.scheduledFilename);
            } else {
                SysLogger.error("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
            }
            try {
                this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
            }
            catch (IOException e) {
                this.handleError("setFile(" + this.fileName + ", true) call failed.");
            }
            this.scheduledFilename = datedFilename;
        }

        @Override
        protected void subAppend(LoggingEvent event) {
            long n = System.currentTimeMillis();
            if (n >= this.nextCheck) {
                this.now.setTime(n);
                this.nextCheck = this.rc.getNextCheckMillis(this.now);
                try {
                    this.rollOver();
                }
                catch (IOException ioe) {
                    if (ioe instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    SysLogger.error("rollOver() failed.", ioe);
                }
            }
            super.subAppend(event);
        }
    }

    public static class RollingFileAppender
    extends FileAppender {
        protected long maxFileSize = 0xA00000L;
        protected int maxBackupIndex = 1;
        private long nextRollover = 0L;

        public int getMaxBackupIndex() {
            return this.maxBackupIndex;
        }

        public long getMaximumFileSize() {
            return this.maxFileSize;
        }

        public void rollOver() {
            if (this.qw != null) {
                long size = ((CountingQuietWriter)this.qw).getCount();
                SysLogger.debug("rolling over count=" + size);
                this.nextRollover = size + this.maxFileSize;
            }
            SysLogger.debug("maxBackupIndex=" + this.maxBackupIndex);
            boolean renameSucceeded = true;
            if (this.maxBackupIndex > 0) {
                File target;
                File file = new File(this.fileName + '.' + this.maxBackupIndex);
                if (file.exists()) {
                    renameSucceeded = file.delete();
                }
                for (int i = this.maxBackupIndex - 1; i >= 1 && renameSucceeded; --i) {
                    file = new File(this.fileName + "." + i);
                    if (!file.exists()) continue;
                    target = new File(this.fileName + '.' + (i + 1));
                    SysLogger.debug("Renaming file " + file + " to " + target);
                    renameSucceeded = file.renameTo(target);
                }
                if (renameSucceeded) {
                    target = new File(this.fileName + "." + 1);
                    this.closeFile();
                    file = new File(this.fileName);
                    SysLogger.debug("Renaming file " + file + " to " + target);
                    renameSucceeded = file.renameTo(target);
                    if (!renameSucceeded) {
                        try {
                            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                        }
                        catch (IOException e) {
                            if (e instanceof InterruptedIOException) {
                                Thread.currentThread().interrupt();
                            }
                            SysLogger.error("setFile(" + this.fileName + ", true) call failed.", e);
                        }
                    }
                }
            }
            if (renameSucceeded) {
                try {
                    this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
                    this.nextRollover = 0L;
                }
                catch (IOException e) {
                    if (e instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    SysLogger.error("setFile(" + this.fileName + ", false) call failed.", e);
                }
            }
        }

        @Override
        public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
            super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
            if (append) {
                File f = new File(fileName);
                ((CountingQuietWriter)this.qw).setCount(f.length());
            }
        }

        public void setMaxBackupIndex(int maxBackups) {
            this.maxBackupIndex = maxBackups;
        }

        public void setMaximumFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        protected void setQWForFiles(Writer writer) {
            this.qw = new CountingQuietWriter(writer, this);
        }

        @Override
        protected void subAppend(LoggingEvent event) {
            long size;
            super.subAppend(event);
            if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
                this.rollOver();
            }
        }

        protected class CountingQuietWriter
        extends QuietWriter {
            protected long count;

            public CountingQuietWriter(Writer writer, Appender appender) {
                super(writer, appender);
            }

            @Override
            public void write(String string) {
                try {
                    this.out.write(string);
                    this.count += (long)string.length();
                }
                catch (IOException e) {
                    this.appender.handleError("Write failure.", e, 1);
                }
            }

            public long getCount() {
                return this.count;
            }

            public void setCount(long count) {
                this.count = count;
            }
        }
    }

    public static class FileAppender
    extends WriterAppender {
        protected boolean fileAppend = true;
        protected String fileName = null;
        protected boolean bufferedIO = false;
        protected int bufferSize = 8192;

        public FileAppender() {
        }

        public FileAppender(Layout layout, String filename, boolean append) throws IOException {
            this.layout = layout;
            this.setFile(filename, append, false, this.bufferSize);
        }

        public void setFile(String file) {
            this.fileName = file.trim();
        }

        public boolean getAppend() {
            return this.fileAppend;
        }

        public String getFile() {
            return this.fileName;
        }

        @Override
        public void activateOptions() {
            if (this.fileName != null) {
                try {
                    this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
                }
                catch (IOException e) {
                    this.handleError("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.", e, 4);
                }
            } else {
                SysLogger.warn("File option not set for appender [" + this.name + "].");
                SysLogger.warn("Are you using FileAppender instead of ConsoleAppender?");
            }
        }

        protected void closeFile() {
            if (this.qw != null) {
                try {
                    this.qw.close();
                }
                catch (IOException e) {
                    if (e instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    SysLogger.error("Could not close " + this.qw, e);
                }
            }
        }

        public boolean getBufferedIO() {
            return this.bufferedIO;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public void setAppend(boolean flag) {
            this.fileAppend = flag;
        }

        public void setBufferedIO(boolean bufferedIO) {
            this.bufferedIO = bufferedIO;
            if (bufferedIO) {
                this.immediateFlush = false;
            }
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
            FileOutputStream ostream;
            SysLogger.debug("setFile called: " + fileName + ", " + append);
            if (bufferedIO) {
                this.setImmediateFlush(false);
            }
            this.reset();
            try {
                ostream = new FileOutputStream(fileName, append);
            }
            catch (FileNotFoundException ex) {
                String parentName = new File(fileName).getParent();
                if (parentName != null) {
                    File parentDir = new File(parentName);
                    if (!parentDir.exists() && parentDir.mkdirs()) {
                        ostream = new FileOutputStream(fileName, append);
                    }
                    throw ex;
                }
                throw ex;
            }
            Writer fw = this.createWriter(ostream);
            if (bufferedIO) {
                fw = new BufferedWriter(fw, bufferSize);
            }
            this.setQWForFiles(fw);
            this.fileName = fileName;
            this.fileAppend = append;
            this.bufferedIO = bufferedIO;
            this.bufferSize = bufferSize;
            this.writeHeader();
            SysLogger.debug("setFile ended");
        }

        protected void setQWForFiles(Writer writer) {
            this.qw = new QuietWriter(writer, this);
        }

        @Override
        protected void reset() {
            this.closeFile();
            this.fileName = null;
            super.reset();
        }
    }

    public static class WriterAppender
    extends Appender {
        protected boolean immediateFlush = true;
        protected String encoding;
        protected QuietWriter qw;

        public void setImmediateFlush(boolean value) {
            this.immediateFlush = value;
        }

        public boolean getImmediateFlush() {
            return this.immediateFlush;
        }

        @Override
        public void activateOptions() {
        }

        @Override
        public void append(LoggingEvent event) {
            if (!this.checkEntryConditions()) {
                return;
            }
            this.subAppend(event);
        }

        protected boolean checkEntryConditions() {
            if (this.closed) {
                SysLogger.warn("Not allowed to write to a closed appender.");
                return false;
            }
            if (this.qw == null) {
                this.handleError("No output stream or file set for the appender named [" + this.name + "].");
                return false;
            }
            if (this.layout == null) {
                this.handleError("No layout set for the appender named [" + this.name + "].");
                return false;
            }
            return true;
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.writeFooter();
            this.reset();
        }

        protected void closeWriter() {
            if (this.qw != null) {
                try {
                    this.qw.close();
                }
                catch (IOException e) {
                    this.handleError("Could not close " + this.qw, e, 3);
                }
            }
        }

        protected OutputStreamWriter createWriter(OutputStream os) {
            OutputStreamWriter retval = null;
            String enc = this.getEncoding();
            if (enc != null) {
                try {
                    retval = new OutputStreamWriter(os, enc);
                }
                catch (IOException e) {
                    SysLogger.warn("Error initializing output writer.");
                    SysLogger.warn("Unsupported encoding?");
                }
            }
            if (retval == null) {
                retval = new OutputStreamWriter(os);
            }
            return retval;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String value) {
            this.encoding = value;
        }

        public synchronized void setWriter(Writer writer) {
            this.reset();
            this.qw = new QuietWriter(writer, this);
            this.writeHeader();
        }

        protected void subAppend(LoggingEvent event) {
            String[] s;
            this.qw.write(this.layout.format(event));
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStr()) != null) {
                for (String s1 : s) {
                    this.qw.write(s1);
                    this.qw.write(LINE_SEP);
                }
            }
            if (this.shouldFlush(event)) {
                this.qw.flush();
            }
        }

        protected void reset() {
            this.closeWriter();
            this.qw = null;
        }

        protected void writeFooter() {
            String f;
            if (this.layout != null && (f = this.layout.getFooter()) != null && this.qw != null) {
                this.qw.write(f);
                this.qw.flush();
            }
        }

        protected void writeHeader() {
            String h;
            if (this.layout != null && (h = this.layout.getHeader()) != null && this.qw != null) {
                this.qw.write(h);
            }
        }

        protected boolean shouldFlush(LoggingEvent event) {
            return event != null && this.immediateFlush;
        }
    }

    private static class QuietWriter
    extends FilterWriter {
        protected Appender appender;

        public QuietWriter(Writer writer, Appender appender) {
            super(writer);
            this.appender = appender;
        }

        @Override
        public void write(String string) {
            if (string != null) {
                try {
                    this.out.write(string);
                }
                catch (Exception e) {
                    this.appender.handleError("Failed to write [" + string + "].", e, 1);
                }
            }
        }

        @Override
        public void flush() {
            try {
                this.out.flush();
            }
            catch (Exception e) {
                this.appender.handleError("Failed to flush writer,", e, 2);
            }
        }
    }

    public static class AsyncAppender
    extends Appender
    implements Appender.AppenderPipeline {
        public static final int DEFAULT_BUFFER_SIZE = 128;
        private final List<LoggingEvent> buffer = new ArrayList<LoggingEvent>();
        private final Map<String, DiscardSummary> discardMap = new HashMap<String, DiscardSummary>();
        private int bufferSize = 128;
        private final Appender.AppenderPipelineImpl appenderPipeline = new Appender.AppenderPipelineImpl();
        private final Thread dispatcher = new Thread(new Dispatcher(this, this.buffer, this.discardMap, this.appenderPipeline));
        private boolean blocking = true;

        public AsyncAppender() {
            this.dispatcher.setDaemon(true);
            this.dispatcher.setName("AsyncAppender-Dispatcher-" + this.dispatcher.getName());
            this.dispatcher.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addAppender(Appender newAppender) {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                this.appenderPipeline.addAppender(newAppender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void append(LoggingEvent event) {
            if (this.dispatcher == null || !this.dispatcher.isAlive() || this.bufferSize <= 0) {
                Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
                synchronized (appenderPipelineImpl) {
                    this.appenderPipeline.appendLoopOnAppenders(event);
                }
                return;
            }
            event.getThreadName();
            event.getRenderedMessage();
            List<LoggingEvent> list = this.buffer;
            synchronized (list) {
                block14: {
                    boolean discard;
                    do {
                        int previousSize;
                        if ((previousSize = this.buffer.size()) < this.bufferSize) {
                            this.buffer.add(event);
                            if (previousSize == 0) {
                                this.buffer.notifyAll();
                            }
                            break block14;
                        }
                        discard = true;
                        if (!this.blocking || Thread.interrupted() || Thread.currentThread() == this.dispatcher) continue;
                        try {
                            this.buffer.wait();
                            discard = false;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } while (!discard);
                    String loggerName = event.getLoggerName();
                    DiscardSummary summary = this.discardMap.get(loggerName);
                    if (summary == null) {
                        summary = new DiscardSummary(event);
                        this.discardMap.put(loggerName, summary);
                    } else {
                        summary.add(event);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.buffer;
            synchronized (object) {
                this.closed = true;
                this.buffer.notifyAll();
            }
            try {
                this.dispatcher.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SysLogger.error("Got an InterruptedException while waiting for the dispatcher to finish.", e);
            }
            object = this.appenderPipeline;
            synchronized (object) {
                Enumeration iter = this.appenderPipeline.getAllAppenders();
                if (iter != null) {
                    while (iter.hasMoreElements()) {
                        Object next = iter.nextElement();
                        if (!(next instanceof Appender)) continue;
                        ((Appender)next).close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Enumeration getAllAppenders() {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                return this.appenderPipeline.getAllAppenders();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Appender getAppender(String name) {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                return this.appenderPipeline.getAppender(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAttached(Appender appender) {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                return this.appenderPipeline.isAttached(appender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAllAppenders() {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                this.appenderPipeline.removeAllAppenders();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAppender(Appender appender) {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                this.appenderPipeline.removeAppender(appender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAppender(String name) {
            Appender.AppenderPipelineImpl appenderPipelineImpl = this.appenderPipeline;
            synchronized (appenderPipelineImpl) {
                this.appenderPipeline.removeAppender(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBufferSize(int size) {
            if (size < 0) {
                throw new NegativeArraySizeException("size");
            }
            List<LoggingEvent> list = this.buffer;
            synchronized (list) {
                this.bufferSize = size < 1 ? 1 : size;
                this.buffer.notifyAll();
            }
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBlocking(boolean value) {
            List<LoggingEvent> list = this.buffer;
            synchronized (list) {
                this.blocking = value;
                this.buffer.notifyAll();
            }
        }

        public boolean getBlocking() {
            return this.blocking;
        }

        private class Dispatcher
        implements Runnable {
            private final AsyncAppender parent;
            private final List<LoggingEvent> buffer;
            private final Map<String, DiscardSummary> discardMap;
            private final Appender.AppenderPipelineImpl appenderPipeline;

            public Dispatcher(AsyncAppender parent, List<LoggingEvent> buffer, Map<String, DiscardSummary> discardMap, Appender.AppenderPipelineImpl appenderPipeline) {
                this.parent = parent;
                this.buffer = buffer;
                this.appenderPipeline = appenderPipeline;
                this.discardMap = discardMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                isActive = true;
                try {
                    block6: while (true) {
                        if (isActive == false) return;
                        events = null;
                        var3_4 = this.buffer;
                        // MONITORENTER : this.buffer
                        bufferSize = this.buffer.size();
                        v0 = isActive = this.parent.closed == false;
                        while (bufferSize == 0 && isActive) {
                            this.buffer.wait();
                            bufferSize = this.buffer.size();
                            isActive = this.parent.closed == false;
                        }
                        if (bufferSize > 0) {
                            events = new LoggingEvent[bufferSize + this.discardMap.size()];
                            this.buffer.toArray(events);
                            index = bufferSize;
                            values = this.discardMap.values();
                            for (DiscardSummary value : values) {
                                events[index++] = value.createEvent();
                            }
                            this.buffer.clear();
                            this.discardMap.clear();
                            this.buffer.notifyAll();
                        }
                        // MONITOREXIT : var3_4
                        if (events == null) continue;
                        var3_4 = events;
                        var4_5 = var3_4.length;
                        var5_6 = 0;
                        while (true) {
                            if (var5_6 < var4_5) ** break;
                            continue block6;
                            event = var3_4[var5_6];
                            var7_8 = this.appenderPipeline;
                            // MONITORENTER : var7_8
                            this.appenderPipeline.appendLoopOnAppenders(event);
                            // MONITOREXIT : var7_8
                            ++var5_6;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private final class DiscardSummary {
            private LoggingEvent maxEvent;
            private int count;

            public DiscardSummary(LoggingEvent event) {
                this.maxEvent = event;
                this.count = 1;
            }

            public void add(LoggingEvent event) {
                if (event.getLevel().toInt() > this.maxEvent.getLevel().toInt()) {
                    this.maxEvent = event;
                }
                ++this.count;
            }

            public LoggingEvent createEvent() {
                String msg = MessageFormat.format("Discarded {0} messages due to full event buffer including: {1}", this.count, this.maxEvent.getMessage());
                return new LoggingEvent("AsyncAppender.DONT_REPORT_LOCATION", Logger.getLogger(this.maxEvent.getLoggerName()), this.maxEvent.getLevel(), msg, null);
            }
        }
    }

    public static class AppenderBuilder {
        private AsyncAppender asyncAppender;
        private Appender appender = null;

        private AppenderBuilder() {
        }

        public AppenderBuilder withLayout(Layout layout) {
            this.appender.setLayout(layout);
            return this;
        }

        public AppenderBuilder withName(String name) {
            this.appender.setName(name);
            return this;
        }

        public AppenderBuilder withConsoleAppender(String target) {
            ConsoleAppender consoleAppender = new ConsoleAppender();
            consoleAppender.setTarget(target);
            consoleAppender.activateOptions();
            this.appender = consoleAppender;
            return this;
        }

        public AppenderBuilder withFileAppender(String file) {
            FileAppender appender = new FileAppender();
            appender.setFile(file);
            appender.setAppend(true);
            appender.setBufferedIO(false);
            appender.setEncoding(ENCODING);
            appender.setImmediateFlush(true);
            appender.activateOptions();
            this.appender = appender;
            return this;
        }

        public AppenderBuilder withRollingFileAppender(String file, String maxFileSize, int maxFileIndex) {
            RollingFileAppender appender = new RollingFileAppender();
            appender.setFile(file);
            appender.setAppend(true);
            appender.setBufferedIO(false);
            appender.setEncoding(ENCODING);
            appender.setImmediateFlush(true);
            appender.setMaximumFileSize(Integer.parseInt(maxFileSize));
            appender.setMaxBackupIndex(maxFileIndex);
            appender.activateOptions();
            this.appender = appender;
            return this;
        }

        public AppenderBuilder withDailyFileRollingAppender(String file, String datePattern) {
            DailyRollingFileAppender appender = new DailyRollingFileAppender();
            appender.setFile(file);
            appender.setAppend(true);
            appender.setBufferedIO(false);
            appender.setEncoding(ENCODING);
            appender.setImmediateFlush(true);
            appender.setDatePattern(datePattern);
            appender.activateOptions();
            this.appender = appender;
            return this;
        }

        public AppenderBuilder withAsync(boolean blocking, int buffSize) {
            AsyncAppender asyncAppender = new AsyncAppender();
            asyncAppender.setBlocking(blocking);
            asyncAppender.setBufferSize(buffSize);
            this.asyncAppender = asyncAppender;
            return this;
        }

        public Appender build() {
            if (this.appender == null) {
                throw new RuntimeException("please specify appender first");
            }
            if (this.asyncAppender != null) {
                this.asyncAppender.addAppender(this.appender);
                return this.asyncAppender;
            }
            return this.appender;
        }
    }
}

