/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls.log4j2;

import com.volcengine.model.tls.LogItem;
import com.volcengine.model.tls.exception.LogException;
import com.volcengine.model.tls.producer.CallBack;
import com.volcengine.model.tls.producer.ProducerConfig;
import com.volcengine.service.tls.Producer;
import com.volcengine.service.tls.ProducerImpl;
import com.volcengine.service.tls.log4j2.LoghubAppenderCallback;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Throwables;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Plugin(name="Loghub", category="Core", elementType="appender", printObject=true)
public class LoghubAppender
extends AbstractAppender {
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String DEFAULT_TIME_ZONE = "UTC";
    protected String topicId;
    protected String endpoint;
    protected String region;
    protected String accessKeyId;
    protected String accessKeySecret;
    protected int totalSizeInBytes;
    protected int maxBlockMs;
    protected int maxThreadCount;
    protected int maxBatchSizeBytes;
    protected int maxBatchCount;
    protected int lingerMs;
    protected int retryCount;
    protected int maxReservedAttempts;
    private String userAgent = "log4j2";
    private Producer producer;
    private String source;
    private ProducerConfig producerConfig;
    private DateTimeFormatter formatter;
    private String mdcFields;

    protected LoghubAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String topicId, String endpoint, String region, String accessKeyId, String accessKeySecret, int totalSizeInBytes, int maxBlockMs, int maxThreadCount, int maxBatchSizeBytes, int maxBatchCount, int lingerMs, int retryCount, int maxReservedAttempts, String source, DateTimeFormatter formatter, String mdcFields) {
        super(name, filter, layout, ignoreExceptions);
        this.endpoint = endpoint;
        this.region = region;
        this.accessKeySecret = accessKeySecret;
        this.accessKeyId = accessKeyId;
        this.topicId = topicId;
        this.totalSizeInBytes = totalSizeInBytes;
        this.retryCount = retryCount;
        this.maxThreadCount = maxThreadCount;
        this.maxBlockMs = maxBlockMs;
        this.maxBatchCount = maxBatchCount;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.lingerMs = lingerMs;
        this.maxReservedAttempts = maxReservedAttempts;
        this.source = source;
        this.formatter = formatter;
        this.mdcFields = mdcFields;
    }

    public void start() {
        super.start();
        try {
            this.producerConfig = this.buildProducerConfig();
            this.setProducerConfig();
            this.producer = new ProducerImpl(this.producerConfig);
            this.producer.start();
            super.start();
        }
        catch (Exception e) {
            this.error("Failed to start Log4j2Appender.", e);
        }
    }

    private void setProducerConfig() throws LogException {
        if (this.totalSizeInBytes > 0) {
            this.producerConfig.setTotalSizeInBytes(this.totalSizeInBytes);
        }
        if (this.maxBlockMs > 0) {
            this.producerConfig.setMaxBlockMs((long)this.maxBlockMs);
        }
        if (this.maxThreadCount > 0) {
            this.producerConfig.setMaxThreadCount(this.maxThreadCount);
        }
        if (this.maxBatchSizeBytes > 0) {
            this.producerConfig.setMaxBatchSizeBytes(this.maxBatchSizeBytes);
        }
        if (this.maxBatchCount > 0) {
            this.producerConfig.setMaxBatchCount(this.maxBatchCount);
        }
        if (this.lingerMs > 0) {
            this.producerConfig.setLingerMs(this.lingerMs);
        }
        if (this.retryCount > 0) {
            this.producerConfig.setRetryCount(this.retryCount);
        }
        if (this.maxReservedAttempts > 0) {
            this.producerConfig.setMaxReservedAttempts(this.maxReservedAttempts);
        }
    }

    private ProducerConfig buildProducerConfig() {
        return new ProducerConfig(this.endpoint, this.region, this.accessKeyId, this.accessKeySecret);
    }

    public void stop() {
        super.stop();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (Exception e) {
                this.error("Failed to close LoghubAppender.", e);
            }
        }
    }

    public void append(LogEvent event) {
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem item = new LogItem();
        logItems.add(item);
        item.setTime(event.getTimeMillis());
        DateTime dateTime = new DateTime(event.getTimeMillis());
        item.addContent("time", dateTime.toString(this.formatter));
        item.addContent("level", event.getLevel().toString());
        item.addContent("thread", event.getThreadName());
        StackTraceElement source = event.getSource();
        if (source == null && !event.isIncludeLocation()) {
            event.setIncludeLocation(true);
            source = event.getSource();
            event.setIncludeLocation(false);
        }
        item.addContent("location", source == null ? "Unknown(Unknown Source)" : source.toString());
        String message = event.getMessage().getFormattedMessage();
        item.addContent("message", message);
        String throwable = this.getThrowableStr(event.getThrown());
        if (throwable != null) {
            item.addContent("throwable", throwable);
        }
        if (this.getLayout() != null) {
            item.addContent("log", new String(this.getLayout().toByteArray(event)));
        }
        Optional.ofNullable(this.mdcFields).ifPresent(f -> event.getContextMap().entrySet().stream().filter(v -> Arrays.stream(f.split(",")).anyMatch(i -> i.equals(v.getKey()))).forEach(map -> item.addContent((String)map.getKey(), map.getValue() == null ? "" : (String)map.getValue())));
        try {
            this.producer.sendLogsV2(null, this.topicId, this.source, null, logItems, (CallBack)new LoghubAppenderCallback(LOGGER, this.topicId, this.source, logItems));
        }
        catch (Exception e) {
            this.error("Failed to send log, topicId=" + this.topicId + ", source=" + source + ", logItem=" + logItems, e);
        }
    }

    private String getThrowableStr(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s : Throwables.toStringList((Throwable)throwable)) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @PluginFactory
    public static LoghubAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginConfiguration Configuration config, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="topicId") String topicId, @PluginAttribute(value="endpoint") String endpoint, @PluginAttribute(value="region") String region, @PluginAttribute(value="accessKeyId") String accessKeyId, @PluginAttribute(value="accessKeySecret") String accessKeySecret, @PluginAttribute(value="totalSizeInBytes") String totalSizeInBytes, @PluginAttribute(value="maxBlockMs") String maxBlockMs, @PluginAttribute(value="maxThreadCount") String maxThreadCount, @PluginAttribute(value="maxBatchSizeBytes") String maxBatchSizeBytes, @PluginAttribute(value="maxBatchCount") String maxBatchCount, @PluginAttribute(value="lingerMs") String lingerMs, @PluginAttribute(value="retryCount") String retryCount, @PluginAttribute(value="maxReservedAttempts") String maxReservedAttempts, @PluginAttribute(value="source") String source, @PluginAttribute(value="timeFormat") String timeFormat, @PluginAttribute(value="timeZone") String timeZone, @PluginAttribute(value="mdcFields") String mdcFields) {
        Boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        int maxBlockMsInt = LoghubAppender.parseStrToInt(maxBlockMs, 0);
        int maxReservedAttemptsInt = LoghubAppender.parseStrToInt(maxReservedAttempts, 3);
        int lingerMsInt = LoghubAppender.parseStrToInt(lingerMs, 3000);
        int batchCountThresholdInt = LoghubAppender.parseStrToInt(maxBatchCount, 4096);
        int batchSizeThresholdInBytesInt = LoghubAppender.parseStrToInt(maxBatchSizeBytes, 0x500000);
        int totalSizeInBytesInt = LoghubAppender.parseStrToInt(totalSizeInBytes, 0x6400000);
        int retriesInt = LoghubAppender.parseStrToInt(retryCount, 2);
        int maxThreadCountInt = LoghubAppender.parseStrToInt(maxThreadCount, 10);
        String pattern = LoghubAppender.isStrEmpty(timeFormat) ? DEFAULT_TIME_FORMAT : timeFormat;
        String timeZoneInfo = LoghubAppender.isStrEmpty(timeZone) ? DEFAULT_TIME_ZONE : timeZone;
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern).withZone(DateTimeZone.forID((String)timeZoneInfo));
        return new LoghubAppender(name, filter, layout, ignoreExceptions, topicId, endpoint, region, accessKeyId, accessKeySecret, totalSizeInBytesInt, maxBlockMsInt, maxThreadCountInt, batchSizeThresholdInBytesInt, batchCountThresholdInt, lingerMsInt, retriesInt, maxReservedAttemptsInt, source, formatter, mdcFields);
    }

    static boolean isStrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    static int parseStrToInt(String str, int defaultVal) {
        if (!LoghubAppender.isStrEmpty(str)) {
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    static void checkCondition(Boolean condition, String errorMsg) {
        if (!condition.booleanValue()) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public int getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public int getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMaxBlockMs(int maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public int getMaxBatchSizeBytes() {
        return this.maxBatchSizeBytes;
    }

    public void setMaxBatchSizeBytes(int maxBatchSizeBytes) {
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public void setMaxBatchCount(int maxBatchCount) {
        this.maxBatchCount = maxBatchCount;
    }

    public int getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(int lingerMs) {
        this.lingerMs = lingerMs;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getMaxReservedAttempts() {
        return this.maxReservedAttempts;
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        this.maxReservedAttempts = maxReservedAttempts;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public void setProducerConfig(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public String getMdcFields() {
        return this.mdcFields;
    }

    public void setMdcFields(String mdcFields) {
        this.mdcFields = mdcFields;
    }
}

