/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls.logback;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.volcengine.model.tls.LogItem;
import com.volcengine.model.tls.exception.LogException;
import com.volcengine.model.tls.producer.ProducerConfig;
import com.volcengine.service.tls.Producer;
import com.volcengine.service.tls.ProducerImpl;
import com.volcengine.service.tls.logback.LogbackAppenderCallback;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private String endpoint;
    private String region;
    private String accessKeyId;
    private String accessKeySecret;
    private String userAgent = "logback";
    private String projectID;
    private String topicID;
    private String source;
    private String filename;
    protected ProducerConfig producerConfig;
    protected Producer producer;
    private int totalSizeInBytes;
    private int maxThreadCount;
    private long maxBlockMs;
    private int maxBatchSizeBytes;
    private int maxBatchCount;
    private int lingerMs;
    private int retryCount;
    private int maxReservedAttempts;
    protected Encoder<E> encoder;
    protected String timeZone = "UTC";
    protected String timeFormat = "yyyy-MM-dd'T'HH:mmZ";
    protected DateTimeFormatter formatter;
    protected java.time.format.DateTimeFormatter defaultFormatter;
    private String mdcFields;
    protected int maxThrowable = 500;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public void setProjectID(String projectID) {
        this.projectID = projectID;
    }

    public String getTopicID() {
        return this.topicID;
    }

    public void setTopicID(String topicID) {
        this.topicID = topicID;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }

    public long getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public int getMaxBatchSizeBytes() {
        return this.maxBatchSizeBytes;
    }

    public void setMaxBatchSizeBytes(int maxBatchSizeBytes) {
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public void setMaxBatchCount(int maxBatchCount) {
        this.maxBatchCount = maxBatchCount;
    }

    public int getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(int lingerMs) {
        this.lingerMs = lingerMs;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getMaxReservedAttempts() {
        return this.maxReservedAttempts;
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        this.maxReservedAttempts = maxReservedAttempts;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public String getMdcFields() {
        return this.mdcFields;
    }

    public void setMdcFields(String mdcFields) {
        this.mdcFields = mdcFields;
    }

    public int getMaxThrowable() {
        return this.maxThrowable;
    }

    public void setMaxThrowable(int maxThrowable) {
        this.maxThrowable = maxThrowable;
    }

    public void start() {
        try {
            try {
                this.formatter = DateTimeFormat.forPattern((String)this.timeFormat).withZone(DateTimeZone.forID((String)this.timeZone));
            }
            catch (Exception e) {
                this.defaultFormatter = java.time.format.DateTimeFormatter.ofPattern(this.timeFormat).withZone(ZoneId.of(this.timeZone));
            }
            this.producerConfig = new ProducerConfig(this.endpoint, this.region, this.accessKeyId, this.accessKeySecret);
            this.setProducerConfig();
            this.producer = new ProducerImpl(this.producerConfig);
            this.producer.start();
            super.start();
        }
        catch (Exception e) {
            this.addError("Failed to start LogbackAppender.", e);
        }
    }

    private void setProducerConfig() throws LogException {
        if (this.totalSizeInBytes > 0) {
            this.producerConfig.setTotalSizeInBytes(this.totalSizeInBytes);
        }
        if (this.maxThreadCount > 0) {
            this.producerConfig.setMaxThreadCount(this.maxThreadCount);
        }
        if (this.maxBlockMs > 0L) {
            this.producerConfig.setMaxBlockMs(this.maxBlockMs);
        }
        if (this.maxBatchSizeBytes > 0) {
            this.producerConfig.setMaxBatchSizeBytes(this.maxBatchSizeBytes);
        }
        if (this.maxBatchCount > 0) {
            this.producerConfig.setMaxBatchCount(this.maxBatchCount);
        }
        if (this.lingerMs > 0) {
            this.producerConfig.setLingerMs(this.lingerMs);
        }
        if (this.retryCount > 0) {
            this.producerConfig.setRetryCount(this.retryCount);
        }
        if (this.maxReservedAttempts > 0) {
            this.producerConfig.setMaxReservedAttempts(this.maxReservedAttempts);
        }
    }

    public void stop() {
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            this.producer.close();
        }
        catch (Exception e) {
            this.addError("Failed to stop LogbackAppender.", e);
        }
    }

    public void append(E eventObject) {
        try {
            this.appendEvent(eventObject);
        }
        catch (Exception e) {
            this.addError("Failed to append event.", e);
        }
    }

    private void appendEvent(E eventObject) {
        IThrowableProxy throwableProxy;
        if (!(eventObject instanceof LoggingEvent)) {
            return;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        LogItem logItem = new LogItem();
        logItem.setTime(event.getTimeStamp() / 1000L);
        if (this.formatter != null) {
            DateTime dateTime = new DateTime(event.getTimeStamp());
            logItem.addContent("time", dateTime.toString(this.formatter));
        } else {
            Instant instant = Instant.ofEpochMilli(event.getTimeStamp());
            logItem.addContent("time", this.defaultFormatter.format(instant));
        }
        logItem.addContent("level", event.getLevel().toString());
        logItem.addContent("thread", event.getThreadName());
        logItem.addContent("message", event.getFormattedMessage());
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            logItem.addContent("location", caller[0].toString());
        }
        if ((throwableProxy = event.getThrowableProxy()) != null) {
            StringBuilder throwable = new StringBuilder(this.getExceptionInfo(throwableProxy));
            do {
                throwable.append(this.fullDump(throwableProxy.getStackTraceElementProxyArray()));
                throwableProxy = throwableProxy.getCause();
                if (throwableProxy == null) continue;
                throwable.append("\n\nCaused by:").append(this.getExceptionInfo(throwableProxy));
            } while (throwableProxy != null);
            String throwableSub = throwable.length() > this.maxThrowable ? throwable.substring(0, this.maxThrowable) : throwable.toString();
            logItem.addContent("throwable", throwableSub);
        }
        if (this.encoder != null) {
            logItem.addContent("log", new String(this.encoder.encode(eventObject)));
        }
        if (this.mdcFields != null && this.mdcFields.trim().equals("*")) {
            event.getMDCPropertyMap().forEach((key, value) -> logItem.addContent(key, value));
        } else {
            Optional.ofNullable(this.mdcFields).ifPresent(f -> event.getMDCPropertyMap().entrySet().stream().filter(v -> Arrays.stream(f.split(",")).anyMatch(i -> i.equals(v.getKey()))).forEach(map -> logItem.addContent((String)map.getKey(), map.getValue() == null ? "" : (String)map.getValue())));
        }
        try {
            this.producer.sendLogV2("", this.topicID, this.source, this.filename, logItem, new LogbackAppenderCallback(this, this.projectID, this.topicID, this.source, this.filename, logItem));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }

    private String fullDump(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            builder.append('\t').append(step.toString());
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }
}

