/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos;

import com.volcengine.tos.TOSClientConfiguration;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TOSV2Builder;
import com.volcengine.tos.TOSV2Client;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.StaticCredentials;
import com.volcengine.tos.transport.TransportConfig;

public class TOSV2ClientBuilder
implements TOSV2Builder {
    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey) {
        StaticCredentials cred = new StaticCredentials(accessKey, secretKey);
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(cred).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey, String securityToken) {
        StaticCredentials cred = new StaticCredentials(accessKey, secretKey).withSecurityToken(securityToken);
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(cred).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, Credentials credentials) {
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(credentials).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey, TransportConfig conf) {
        StaticCredentials cred = new StaticCredentials(accessKey, secretKey);
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(cred).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, Credentials credentials, TransportConfig conf) {
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(credentials).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey, String securityToken, TransportConfig conf) {
        StaticCredentials cred = new StaticCredentials(accessKey, secretKey).withSecurityToken(securityToken);
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(cred).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(TOSClientConfiguration conf) {
        return new TOSV2Client(conf);
    }
}

