/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.auth;

import com.volcengine.tos.auth.Credential;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.SignKeyInfo;
import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.auth.signKey;
import com.volcengine.tos.auth.signingHeader;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignV4
implements Signer {
    private static final Logger LOG = LoggerFactory.getLogger(SignV4.class);
    static final String emptySHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    static final String unsignedPayload = "UNSIGNED-PAYLOAD";
    static final String signPrefix = "TOS4-HMAC-SHA256";
    static final String authorization = "Authorization";
    static final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");
    static final DateTimeFormatter iso8601Layout = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    static final String v4Algorithm = "X-Tos-Algorithm";
    static final String v4Credential = "X-Tos-Credential";
    static final String v4Date = "X-Tos-Date";
    static final String v4Expires = "X-Tos-Expires";
    static final String v4SignedHeaders = "X-Tos-SignedHeaders";
    static final String v4Signature = "X-Tos-Signature";
    static final String v4SignatureLower = "x-tos-signature";
    static final String v4ContentSHA256 = "X-Tos-Content-Sha256";
    static final String v4SecurityToken = "X-Tos-Security-Token";
    static final String v4Prefix = "x-tos";
    private Credentials credentials;
    private final String region;
    private signingHeader signingHeader;
    private Predicate<String> signingQuery;
    private Supplier<Instant> now;
    private signKey signKey;
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public SignV4(Credentials credentials, String region) {
        this.credentials = credentials;
        this.region = region;
        this.signingHeader = SignV4::defaultSigningHeaderV4;
        this.signingQuery = SignV4::defaultSigningQueryV4;
        this.now = SignV4::defaultUTCNow;
        this.signKey = SignV4::signKey;
    }

    public Supplier<Instant> getNow() {
        return this.now;
    }

    public void setNow(Supplier<Instant> date) {
        this.now = date;
    }

    @Override
    public Map<String, String> signHeader(TosRequest req) {
        ParamsChecker.ensureNotNull(req.getHost(), "host");
        HashMap<String, String> signed = new HashMap<String, String>(4);
        OffsetDateTime now = this.now.get().atOffset(ZoneOffset.UTC);
        String date = now.format(iso8601Layout);
        String contentSha256 = req.getHeaders().get(v4ContentSHA256);
        Map<String, String> header = req.getHeaders();
        List<Map.Entry<String, String>> signedHeader = this.signedHeader(header, false);
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>(v4Date.toLowerCase(), date));
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("date", date));
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("host", req.getHost()));
        Credential cred = this.credentials.credential();
        if (StringUtils.isNotEmpty(cred.getSecurityToken())) {
            signedHeader.add(new AbstractMap.SimpleEntry<String, String>(v4SecurityToken.toLowerCase(), cred.getSecurityToken()));
            signed.put(v4SecurityToken, cred.getSecurityToken());
        }
        Collections.sort(signedHeader, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        List<Map.Entry<String, String>> signedQuery = this.signedQuery(req.getQuery(), null);
        String sign = this.doSign(req.getMethod(), req.getPath(), contentSha256, signedHeader, signedQuery, now, cred);
        String credential = String.format("%s/%s/%s/tos/request", cred.getAccessKeyId(), now.format(yyyyMMdd), this.region);
        String keys = signedHeader.stream().map(Map.Entry::getKey).sorted().collect(Collectors.joining(";"));
        String auth = String.format("TOS4-HMAC-SHA256 Credential=%s,SignedHeaders=%s,Signature=%s", credential, keys, sign);
        signed.put(authorization, auth);
        signed.put(v4Date, date);
        signed.put("Date", date);
        return signed;
    }

    @Override
    public Map<String, String> signQuery(TosRequest req, Duration ttl) {
        OffsetDateTime now = this.now.get().atOffset(ZoneOffset.UTC);
        String date = now.format(iso8601Layout);
        Map<String, String> query = req.getQuery();
        HashMap<String, String> extra = new HashMap<String, String>();
        Credential cred = this.credentials.credential();
        String credential = String.format("%s/%s/%s/tos/request", cred.getAccessKeyId(), now.format(yyyyMMdd), this.region);
        extra.put(v4Algorithm, signPrefix);
        extra.put(v4Credential, credential);
        extra.put(v4Date, date);
        extra.put(v4Expires, String.valueOf(ttl.toMillis() / 1000L));
        if (StringUtils.isNotEmpty(cred.getSecurityToken())) {
            extra.put(v4SecurityToken, cred.getSecurityToken());
        }
        List<Map.Entry<String, String>> signedHeader = this.signedHeader(req.getHeaders(), true);
        String host = req.getHost();
        if (StringUtils.isEmpty(host)) {
            throw new IllegalArgumentException("params.getHost() get null/empty");
        }
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("host", host));
        Collections.sort(signedHeader, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        String keys = signedHeader.stream().map(Map.Entry::getKey).sorted().collect(Collectors.joining(";"));
        extra.put(v4SignedHeaders, keys);
        List<Map.Entry<String, String>> signedQuery = this.signedQuery(query, extra);
        String sign = this.doSign(req.getMethod(), req.getPath(), unsignedPayload, signedHeader, signedQuery, now, cred);
        extra.put(v4Signature, sign);
        return extra;
    }

    public SignV4 withSignKey(signKey signKey2) {
        this.signKey = signKey2;
        return this;
    }

    public static Instant defaultUTCNow() {
        return Instant.now();
    }

    public static boolean defaultSigningHeaderV4(String key, boolean isSigningQuery) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        return "content-type".equals(key) && !isSigningQuery || key.startsWith(v4Prefix);
    }

    public static boolean defaultSigningQueryV4(String key) {
        return !v4SignatureLower.equals(key);
    }

    private List<Map.Entry<String, String>> signedHeader(Map<String, String> header, boolean isSignedQuery) {
        ArrayList<Map.Entry<String, String>> signed = new ArrayList<Map.Entry<String, String>>(10);
        if (header == null || header.isEmpty()) {
            return signed;
        }
        for (Map.Entry<String, String> entry : header.entrySet()) {
            String kk;
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotEmpty(key) || !this.signingHeader.isSigningHeader(kk = key.toLowerCase(), isSignedQuery)) continue;
            value = value == null ? "" : value;
            signed.add(new AbstractMap.SimpleEntry<String, String>(kk, value));
        }
        return signed;
    }

    private List<Map.Entry<String, String>> signedQuery(Map<String, String> query, Map<String, String> extra) {
        ArrayList<Map.Entry<String, String>> signed = new ArrayList<Map.Entry<String, String>>(10);
        if (query != null) {
            query.forEach((k, v) -> {
                if (this.signingQuery.test(k.toLowerCase())) {
                    signed.add(new AbstractMap.SimpleEntry<String, String>((String)k, (String)v));
                }
            });
        }
        if (extra != null) {
            extra.forEach((k, v) -> {
                if (this.signingQuery.test(k.toLowerCase())) {
                    signed.add(new AbstractMap.SimpleEntry<String, String>((String)k, (String)v));
                }
            });
        }
        return signed;
    }

    private String canonicalRequest(String method, String path, String contentSha256, List<Map.Entry<String, String>> header, List<Map.Entry<String, String>> query) {
        int split = 10;
        StringBuilder buf = new StringBuilder(512);
        buf.append(method);
        buf.append('\n');
        buf.append(SignV4.encodePath(path));
        buf.append('\n');
        buf.append(SignV4.encodeQuery(query));
        buf.append('\n');
        if (header == null) {
            header = Collections.emptyList();
        }
        ArrayList<String> keys = new ArrayList<String>(header.size());
        Collections.sort(header, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry<String, String> entry : header) {
            String key = entry.getKey();
            keys.add(key);
            buf.append(key);
            buf.append(':');
            buf.append(entry.getValue() == null ? "" : entry.getValue());
            buf.append('\n');
        }
        buf.append('\n');
        buf.append(StringUtils.join(keys, ";"));
        buf.append('\n');
        if (StringUtils.isNotEmpty(contentSha256)) {
            buf.append(contentSha256);
        } else {
            buf.append(emptySHA256);
        }
        return buf.toString();
    }

    static byte[] signKey(SignKeyInfo info) {
        byte[] date = SignV4.hmacSha256(info.getCredential().getAccessKeySecret().getBytes(StandardCharsets.UTF_8), info.getDate().getBytes(StandardCharsets.UTF_8));
        byte[] region = SignV4.hmacSha256(date, info.getRegion().getBytes(StandardCharsets.UTF_8));
        byte[] service = SignV4.hmacSha256(region, "tos".getBytes(StandardCharsets.UTF_8));
        return SignV4.hmacSha256(service, "request".getBytes(StandardCharsets.UTF_8));
    }

    private String doSign(String method, String path, String contentSha256, List<Map.Entry<String, String>> header, List<Map.Entry<String, String>> query, OffsetDateTime now, Credential cred) {
        int split = 10;
        String req = this.canonicalRequest(method, path, contentSha256, header, query);
        LOG.debug("canonical request:\n{}", (Object)req);
        StringBuilder buf = new StringBuilder(signPrefix.length() + 128);
        buf.append(signPrefix);
        buf.append('\n');
        buf.append(now.format(iso8601Layout));
        buf.append('\n');
        String date = now.format(yyyyMMdd);
        buf.append(date).append('/').append(this.region).append("/tos/request");
        buf.append('\n');
        byte[] sum = SignV4.sha256(req);
        buf.append(SignV4.toHex(sum));
        LOG.debug("string to sign:\n {}", (Object)buf.toString());
        byte[] signK = SignV4.signKey(new SignKeyInfo(date, this.region, cred));
        byte[] sign = SignV4.hmacSha256(signK, buf.toString().getBytes(StandardCharsets.UTF_8));
        return String.valueOf(SignV4.toHex(sign));
    }

    private static String encodePath(String path) {
        if (path == null || path.isEmpty()) {
            return "/";
        }
        return TosUtils.uriEncode(path, false);
    }

    private static String encodeQuery(List<Map.Entry<String, String>> query) {
        if (query == null || query.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        Collections.sort(query, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry<String, String> kv : query) {
            String keyEscaped = TosUtils.uriEncode(kv.getKey(), true);
            if (buf.length() > 0) {
                buf.append('&');
            }
            buf.append(keyEscaped);
            buf.append('=');
            buf.append(TosUtils.uriEncode(kv.getValue() == null ? "" : kv.getValue(), true));
        }
        return buf.toString();
    }

    static byte[] hmacSha256(byte[] key, byte[] value) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKey);
            return hmac.doFinal(value);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static byte[] sha256(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static char[] toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX[v >>> 4];
            hexChars[j * 2 + 1] = HEX[v & 0xF];
        }
        return hexChars;
    }
}

