/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.comm.io;

import com.volcengine.tos.comm.io.TosRepeatableFileInputStream;
import com.volcengine.tos.model.object.TosObjectInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class TosRepeatableBoundedFileInputStream
extends TosObjectInputStream {
    private TosRepeatableFileInputStream rfis;
    private long totalSize;
    private long readSize;
    private long mark = -1L;

    public TosRepeatableBoundedFileInputStream(FileInputStream in, long size) {
        super(in);
        this.rfis = new TosRepeatableFileInputStream(in);
        if (size < 0L) {
            throw new IllegalArgumentException("TosRepeatableBoundedFileInputStream input size is invalid, please make it not less than 0");
        }
        this.totalSize = size;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        if (this.totalSize >= 0L && this.readSize >= this.totalSize) {
            return -1;
        }
        int n = this.rfis.read();
        ++this.readSize;
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        if (this.totalSize >= 0L && this.readSize >= this.totalSize) {
            return -1;
        }
        int toRead = len;
        if (this.totalSize >= 0L) {
            toRead = Math.min(len, (int)(this.totalSize - this.readSize));
        }
        if ((n = this.rfis.read(b, off, toRead)) > -1) {
            this.readSize += (long)n;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.totalSize >= 0L && this.readSize >= this.totalSize) {
            return -1;
        }
        return this.rfis.available();
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = this.totalSize >= 0L ? Math.min(n, this.totalSize - this.readSize) : n;
        long skipped = this.rfis.skip(toSkip);
        this.readSize += skipped;
        return skipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.rfis.mark(readlimit);
        this.mark = this.readSize;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.rfis.reset();
        this.readSize = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.rfis.close();
    }
}

