/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;

public class RequestEventListener
extends EventListener {
    private long callStart = -1L;
    private long callEnd = -1L;
    private long dnsStart = -1L;
    private long dnsEnd = -1L;
    private long connectStart = -1L;
    private long connectEnd = -1L;
    private long secureConnectStart = -1L;
    private long secureConnectEnd = -1L;
    private long requestStart = -1L;
    private long requestEnd = -1L;
    private long responseStart = -1L;
    private long responseEnd = -1L;
    private String method;
    private String host;
    private String path;
    private String reqId;
    private Logger log;

    public RequestEventListener(Logger log) {
        this.log = log;
    }

    public void callStart(Call call) {
        this.callStart = System.currentTimeMillis();
        if (call != null) {
            this.method = call.request().method();
            this.host = call.request().url().host();
            this.path = call.request().url().encodedPath();
        }
    }

    public void dnsStart(Call call, String domainName) {
        this.dnsStart = System.currentTimeMillis();
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        this.dnsEnd = System.currentTimeMillis();
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.connectStart = System.currentTimeMillis();
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        this.connectEnd = System.currentTimeMillis();
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        this.connectEnd = System.currentTimeMillis();
    }

    public void secureConnectStart(Call call) {
        this.secureConnectStart = System.currentTimeMillis();
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        this.secureConnectEnd = System.currentTimeMillis();
    }

    public void requestHeadersStart(Call call) {
        this.requestStart = System.currentTimeMillis();
    }

    public void requestHeadersEnd(Call call, Request request) {
        this.requestEnd = System.currentTimeMillis();
    }

    public void requestBodyEnd(Call call, long byteCount) {
        this.requestEnd = System.currentTimeMillis();
    }

    public void responseHeadersStart(Call call) {
        this.responseStart = System.currentTimeMillis();
    }

    public void responseHeadersEnd(Call call, Response response) {
        this.responseEnd = System.currentTimeMillis();
        if (response != null) {
            this.reqId = response.header("X-Tos-Request-Id");
        }
    }

    public void responseBodyStart(Call call) {
        this.responseStart = System.currentTimeMillis();
    }

    public void responseBodyEnd(Call call, long byteCount) {
        this.responseEnd = System.currentTimeMillis();
    }

    public void callEnd(Call call) {
        this.callEnd = System.currentTimeMillis();
        this.log.debug("requestId: {}, method: {}, host: {}, request uri: {}, dns cost: {} ms, connect cost: {} ms, tls handshake cost: {} ms, send headers and body cost: {} ms, wait response cost: {} ms, request cost: {} ms\n", new Object[]{this.reqId, this.method, this.host, this.path, this.dnsEnd - this.dnsStart, this.connectEnd - this.connectStart, this.secureConnectEnd - this.secureConnectStart, this.requestEnd - this.requestStart, this.responseEnd - this.responseStart, this.callEnd - this.callStart});
    }

    public void callFailed(Call call, IOException ioe) {
        this.callEnd = System.currentTimeMillis();
        this.callEnd = System.currentTimeMillis();
        this.log.debug("requestId: {}, method: {}, host: {}, request uri: {}, dns cost: {} ms, connect cost: {} ms, tls handshake cost: {} ms, send headers and body cost: {} ms, wait response cost: {} ms, request cost: {} ms\n", new Object[]{this.reqId, this.method, this.host, this.path, this.dnsEnd - this.dnsStart, this.connectEnd - this.connectStart, this.secureConnectEnd - this.secureConnectStart, this.requestEnd - this.requestStart, this.responseEnd - this.responseStart, this.callEnd - this.callStart});
    }

    public static class RequestEventListenerFactory
    implements EventListener.Factory {
        private final Logger log;

        public RequestEventListenerFactory(Logger log) {
            this.log = log;
        }

        public EventListener create(Call call) {
            return new RequestEventListener(this.log);
        }
    }
}

