/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.UnexpectedStatusCodeException;
import com.volcengine.tos.internal.Action;
import com.volcengine.tos.internal.ServerExceptionJson;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.IOException;
import java.util.List;

class RequestHandler {
    private Transport transport;

    RequestHandler(Transport transport) {
        this.transport = transport;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doRequest(TosRequest request, int expectedCode, Action<TosResponse, T> action) throws TosException {
        try (TosResponse res = this.doRequest(request);){
            if (this.containExpectedCodes(res.getStatusCode(), expectedCode)) {
                TosResponse tosResponse = action.apply(res);
                return (T)tosResponse;
            }
            this.checkException(res);
            throw new UnexpectedStatusCodeException(res.getStatusCode(), expectedCode, res.getRequesID());
        }
        catch (IOException e) {
            throw new TosClientException("tos: close body failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doRequest(TosRequest request, List<Integer> expectedCodes, Action<TosResponse, T> action) throws TosException {
        try (TosResponse res = this.doRequest(request, expectedCodes);){
            TosResponse tosResponse = action.apply(res);
            return (T)tosResponse;
        }
        catch (IOException e) {
            throw new TosClientException("tos: close body failed", e);
        }
    }

    protected TosResponse doRequest(TosRequest request, List<Integer> expectedCodes) {
        TosResponse response = this.doRequest(request);
        for (int code : expectedCodes) {
            if (!this.containExpectedCodes(response.getStatusCode(), code)) continue;
            return response;
        }
        this.checkException(response);
        throw new UnexpectedStatusCodeException(response.getStatusCode(), expectedCodes, response.getRequesID());
    }

    private TosResponse doRequest(TosRequest request) throws TosException {
        TosResponse res;
        try {
            res = this.transport.roundTrip(request);
        }
        catch (IOException e) {
            throw new TosClientException("tos: request exception", e);
        }
        return res;
    }

    protected boolean containExpectedCodes(int statusCode, int expectedCode) {
        return statusCode == expectedCode;
    }

    protected void checkException(TosResponse res) {
        if (res.getStatusCode() < 300) {
            return;
        }
        String s = null;
        try {
            s = StringUtils.toString(res.getInputStream());
        }
        catch (IOException e) {
            throw new TosClientException("tos: read response body failed", e);
        }
        if (s.length() > 0) {
            ServerExceptionJson se = null;
            try {
                se = (ServerExceptionJson)TosUtils.JSON.readValue(s, (TypeReference)new TypeReference<ServerExceptionJson>(){});
            }
            catch (JsonProcessingException e) {
                if (res.getStatusCode() == 400) {
                    throw new TosClientException("tos: bad request" + s, null);
                }
                throw new TosClientException("tos: parse server exception failed" + s, null);
            }
            throw new TosServerException(res.getStatusCode(), se.getCode(), se.getMessage(), se.getRequestID(), se.getHostID());
        }
        if (res.getStatusCode() == 404) {
            throw new TosServerException(res.getStatusCode(), "NotFound", "", res.getRequesID(), "");
        }
        if (res.getStatusCode() == 403) {
            throw new TosServerException(res.getStatusCode(), "Forbidden", "", res.getRequesID(), "");
        }
    }
}

