/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestHandler;
import com.volcengine.tos.internal.TosBucketRequestHandler;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TypeConverter;
import com.volcengine.tos.model.bucket.CreateBucketV2Input;
import com.volcengine.tos.model.bucket.CreateBucketV2Output;
import com.volcengine.tos.model.bucket.DeleteBucketInput;
import com.volcengine.tos.model.bucket.DeleteBucketOutput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyInput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyOutput;
import com.volcengine.tos.model.bucket.GetBucketPolicyInput;
import com.volcengine.tos.model.bucket.GetBucketPolicyOutput;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.bucket.ListBucketsV2Input;
import com.volcengine.tos.model.bucket.ListBucketsV2Output;
import com.volcengine.tos.model.bucket.PutBucketPolicyInput;
import com.volcengine.tos.model.bucket.PutBucketPolicyOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TosBucketRequestHandlerImpl
implements TosBucketRequestHandler {
    private RequestHandler bucketHandler;
    private TosRequestFactory factory;

    public TosBucketRequestHandlerImpl(Transport transport, TosRequestFactory factory) {
        this.bucketHandler = new RequestHandler(transport);
        this.factory = factory;
    }

    @Override
    public CreateBucketV2Output createBucket(CreateBucketV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CreateBucketV2Input");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", input.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp()).withHeader("X-Tos-Storage-Class", input.getStorageClass() == null ? null : input.getStorageClass().toString());
        TosRequest req = this.factory.build(builder, "PUT", null).setRetryableOnClientException(false);
        return this.bucketHandler.doRequest(req, 200, res -> new CreateBucketV2Output(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("Location")));
    }

    @Override
    public HeadBucketV2Output headBucket(HeadBucketV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "HeadBucketInput");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null);
        TosRequest req = this.factory.build(builder, "HEAD", null);
        return this.bucketHandler.doRequest(req, 200, res -> new HeadBucketV2Output(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("X-Tos-Bucket-Region"), TypeConverter.convertStorageClassType(res.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class"))));
    }

    @Override
    public DeleteBucketOutput deleteBucket(DeleteBucketInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketInput");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null);
        TosRequest req = this.factory.build(builder, "DELETE", null).setRetryableOnClientException(false);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketOutput(res.RequestInfo()));
    }

    @Override
    public ListBucketsV2Output listBuckets(ListBucketsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListBucketsV2Input");
        RequestBuilder builder = this.factory.init("", "", null);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<ListBucketsV2Output>(){}).setRequestInfo(res.RequestInfo()));
    }

    @Override
    public PutBucketPolicyOutput putBucketPolicy(PutBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketPolicyInput");
        ParamsChecker.ensureNotNull(input.getPolicy(), "policy");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(input.getPolicy().getBytes(StandardCharsets.UTF_8)));
        return this.bucketHandler.doRequest(req, 204, res -> new PutBucketPolicyOutput().setRequestInfo(res.RequestInfo()));
    }

    @Override
    public GetBucketPolicyOutput getBucketPolicy(GetBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketPolicyInput");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> {
            GetBucketPolicyOutput ret = new GetBucketPolicyOutput().setRequestInfo(res.RequestInfo());
            try {
                ret.setPolicy(StringUtils.toString(res.getInputStream()));
            }
            catch (IOException e) {
                throw new TosClientException("tos: read bucket policy failed", e);
            }
            return ret;
        });
    }

    @Override
    public DeleteBucketPolicyOutput deleteBucketPolicy(DeleteBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketPolicyInput");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketPolicyOutput().setRequestInfo(res.RequestInfo()));
    }
}

