/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.io.TosRepeatableBoundedFileInputStream;
import com.volcengine.tos.comm.io.TosRepeatableFileInputStream;
import com.volcengine.tos.comm.io.TosRepeatableInputStream;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import okhttp3.HttpUrl;

public class TosRequest {
    private String scheme;
    private String method;
    private String host;
    private String path;
    private int port;
    private long contentLength;
    private boolean retryableOnClientException;
    private boolean retryableOnServerException;
    private boolean enableCrcCheck;
    private long crc64InitValue;
    private transient InputStream content;
    private RateLimiter rateLimiter;
    private DataTransferListener dataTransferListener;
    private Map<String, String> headers = Collections.emptyMap();
    private Map<String, String> query = Collections.emptyMap();
    private byte[] data = new byte[0];

    public TosRequest() {
    }

    public TosRequest(String scheme, String method, String host, String path) {
        this.scheme = scheme;
        this.method = method;
        this.host = host;
        this.path = path;
    }

    public TosRequest(String scheme, String method, String host, String path, InputStream inputStream, Map<String, String> query, Map<String, String> headers) {
        this.scheme = scheme;
        this.method = method;
        this.host = host;
        this.path = path;
        this.content = inputStream != null ? new TosRepeatableInputStream(inputStream, 8192) : null;
        if (inputStream instanceof TosRepeatableInputStream || inputStream instanceof TosRepeatableFileInputStream || inputStream instanceof TosRepeatableBoundedFileInputStream) {
            this.content = inputStream;
        }
        this.query = query;
        this.headers = headers;
        this.retryableOnClientException = true;
        this.retryableOnServerException = true;
    }

    public HttpUrl toURL() {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        if (this.query != null) {
            for (Map.Entry<String, String> entry : this.query.entrySet()) {
                builder.addEncodedQueryParameter(entry.getKey(), TosUtils.uriEncode(entry.getValue(), true));
            }
        }
        String escapePath = StringUtils.removeStart(this.path, "/");
        builder = builder.scheme(this.scheme).host(this.host).addPathSegment(escapePath);
        if (this.port != 0) {
            builder.port(this.port);
        }
        return builder.build();
    }

    public String getScheme() {
        return this.scheme;
    }

    public TosRequest setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public TosRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public TosRequest setHost(String host) {
        this.host = host;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public TosRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TosRequest setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public InputStream getContent() {
        return this.content;
    }

    public TosRequest setContent(InputStream content) {
        this.content = content;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TosRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public TosRequest setQuery(Map<String, String> query) {
        this.query = query;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public TosRequest setData(byte[] data) {
        this.data = data;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public TosRequest setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isRetryableOnClientException() {
        return this.retryableOnClientException;
    }

    public TosRequest setRetryableOnClientException(boolean retryableOnClientException) {
        this.retryableOnClientException = retryableOnClientException;
        return this;
    }

    public boolean isRetryableOnServerException() {
        return this.retryableOnServerException;
    }

    public TosRequest setRetryableOnServerException(boolean retryableOnServerException) {
        this.retryableOnServerException = retryableOnServerException;
        return this;
    }

    public boolean isEnableCrcCheck() {
        return this.enableCrcCheck;
    }

    public TosRequest setEnableCrcCheck(boolean enableCrcCheck) {
        this.enableCrcCheck = enableCrcCheck;
        return this;
    }

    public long getCrc64InitValue() {
        return this.crc64InitValue;
    }

    public TosRequest setCrc64InitValue(long crc64InitValue) {
        this.crc64InitValue = crc64InitValue;
        return this;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public TosRequest setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    public DataTransferListener getDataTransferListener() {
        return this.dataTransferListener;
    }

    public TosRequest setDataTransferListener(DataTransferListener dataTransferListener) {
        this.dataTransferListener = dataTransferListener;
        return this;
    }
}

