/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.comm.io.TosRepeatableInputStream;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.model.object.TosObjectInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

class WrappedTransportRequestBody
extends RequestBody
implements Closeable {
    private InputStream content;
    private final MediaType contentType;
    private long contentLength;

    WrappedTransportRequestBody(MediaType contentType, InputStream inputStream, long contentLength) {
        ParamsChecker.ensureNotNull(inputStream, "inputStream");
        this.contentType = contentType;
        this.contentLength = contentLength;
        if (this.contentLength < -1L) {
            this.contentLength = -1L;
        }
        this.content = inputStream;
        if (!(this.content instanceof TosObjectInputStream)) {
            this.content = new TosRepeatableInputStream(inputStream, 8192);
        }
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)this.content);
            sink.writeAll(source);
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }

    protected InputStream getContent() {
        return this.content;
    }
}

