/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.comm.event.DataTransferType;
import com.volcengine.tos.comm.event.DownloadEventType;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.model.ConcurrentDataTransferListenInputStream;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.TosTask;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.model.object.DownloadEvent;
import com.volcengine.tos.model.object.DownloadEventListener;
import com.volcengine.tos.model.object.DownloadFileCheckpoint;
import com.volcengine.tos.model.object.DownloadPartInfo;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CheckedInputStream;

class DownloadFileTask
extends TosTask
implements TaskOutput<DownloadPartInfo> {
    private DownloadFileCheckpoint checkpoint;
    private HeadObjectV2Input headObjectV2Input;
    private DownloadPartInfo partInfo;
    private boolean enableCheckpoint;
    private String checkpointFile;
    private boolean enableCrcCheck;
    private DownloadEventListener downloadEventListener;
    private TosObjectRequestHandler handler;
    private RateLimiter rateLimiter;
    private DataTransferListener dataTransferListener;
    private final AtomicLong consumedBytes;

    public DownloadFileTask(DownloadFileCheckpoint checkpoint, int taskIdx, AtomicLong consumedBytes) {
        this.checkpoint = checkpoint;
        this.partInfo = checkpoint.getDownloadPartInfos().get(taskIdx);
        this.consumedBytes = consumedBytes;
    }

    @Override
    public Callable<TaskOutput<?>> getCallableTask() {
        return () -> {
            DownloadEvent event = new DownloadEvent().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setVersionID(this.checkpoint.getVersionID()).setFilePath(this.checkpoint.getDownloadFileInfo().getFilePath()).setTempFilePath(this.checkpoint.getDownloadFileInfo().getTempFilePath()).setCheckpointFile(this.checkpointFile);
            DataTransferStatus status = new DataTransferStatus().setTotalBytes(this.checkpoint.getDownloadObjectInfo().getObjectSize());
            try (RandomAccessFile output = new RandomAccessFile(this.checkpoint.getDownloadFileInfo().getTempFilePath(), "rw");){
                output.seek(this.partInfo.getRangeStart());
                ObjectMetaRequestOptions options = this.headObjectV2Input.getOptions();
                if (options == null) {
                    options = new ObjectMetaRequestOptions();
                }
                options.setRange(this.partInfo.getRangeStart(), this.partInfo.getRangeEnd());
                GetObjectV2Input get = new GetObjectV2Input().setBucket(this.headObjectV2Input.getBucket()).setKey(this.headObjectV2Input.getKey()).setOptions(options).setVersionID(this.headObjectV2Input.getVersionID()).setRateLimiter(this.rateLimiter);
                GetObjectV2Output got = this.handler.getObject(get);
                long totalSize = this.checkpoint.getDownloadObjectInfo().getObjectSize();
                try (InputStream wrapped = got.getContent();){
                    wrapped = this.wrapInputStream(got.getContent(), totalSize);
                    byte[] buffer = new byte[8192];
                    int once = 0;
                    while ((once = wrapped.read(buffer)) > 0) {
                        output.write(buffer, 0, once);
                    }
                    this.partInfo.setCompleted(true);
                    if (this.enableCrcCheck) {
                        this.partInfo.setHashCrc64ecma(((CheckedInputStream)wrapped).getChecksum().getValue());
                    }
                    if (this.enableCheckpoint) {
                        this.checkpoint.writeToFile(this.checkpointFile);
                    }
                    event.setDownloadEventType(DownloadEventType.DownloadEventDownloadPartSucceed).setDownloadPartInfo(this.partInfo);
                    Util.postDownloadEvent(this.downloadEventListener, event);
                }
            }
            catch (IOException e) {
                TosClientException te = new TosClientException("tos: write data to local file failed", e);
                Util.postDownloadEvent(this.downloadEventListener, event.setTosException(te).setDownloadPartInfo(this.partInfo).setDownloadEventType(DownloadEventType.DownloadEventDownloadPartFailed));
                Util.postDataTransferStatus(this.dataTransferListener, status.setConsumedBytes(this.consumedBytes.get()).setType(DataTransferType.DATA_TRANSFER_FAILED));
                throw te;
            }
            catch (TosException e) {
                if (Util.needAbortTask(e.getStatusCode())) {
                    Util.postDownloadEvent(this.downloadEventListener, event.setTosException(e).setDownloadPartInfo(this.partInfo).setDownloadEventType(DownloadEventType.DownloadEventDownloadPartAborted));
                    Util.postDataTransferStatus(this.dataTransferListener, status.setConsumedBytes(this.consumedBytes.get()).setType(DataTransferType.DATA_TRANSFER_FAILED));
                    throw e;
                }
                Util.postDownloadEvent(this.downloadEventListener, event.setTosException(e).setDownloadPartInfo(this.partInfo).setDownloadEventType(DownloadEventType.DownloadEventDownloadPartFailed));
            }
            return this;
        };
    }

    @Override
    public DownloadPartInfo getOutput() {
        return this.partInfo;
    }

    private InputStream wrapInputStream(InputStream stream, long objectSize) {
        if (this.dataTransferListener != null) {
            stream = new ConcurrentDataTransferListenInputStream(stream, this.dataTransferListener, objectSize, this.consumedBytes);
        }
        if (this.enableCrcCheck) {
            stream = new CheckedInputStream(stream, new CRC64Checksum());
        }
        return stream;
    }

    public DownloadFileCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public DownloadFileTask setCheckpoint(DownloadFileCheckpoint checkpoint) {
        this.checkpoint = checkpoint;
        return this;
    }

    public HeadObjectV2Input getHeadObjectV2Input() {
        return this.headObjectV2Input;
    }

    public DownloadFileTask setHeadObjectV2Input(HeadObjectV2Input headObjectV2Input) {
        this.headObjectV2Input = headObjectV2Input;
        return this;
    }

    public DownloadPartInfo getPartInfo() {
        return this.partInfo;
    }

    public DownloadFileTask setPartInfo(DownloadPartInfo partInfo) {
        this.partInfo = partInfo;
        return this;
    }

    public boolean isEnableCheckpoint() {
        return this.enableCheckpoint;
    }

    public DownloadFileTask setEnableCheckpoint(boolean enableCheckpoint) {
        this.enableCheckpoint = enableCheckpoint;
        return this;
    }

    public String getCheckpointFile() {
        return this.checkpointFile;
    }

    public DownloadFileTask setCheckpointFile(String checkpointFile) {
        this.checkpointFile = checkpointFile;
        return this;
    }

    public boolean isEnableCrcCheck() {
        return this.enableCrcCheck;
    }

    public DownloadFileTask setEnableCrcCheck(boolean enableCrcCheck) {
        this.enableCrcCheck = enableCrcCheck;
        return this;
    }

    public DownloadEventListener getDownloadEventListener() {
        return this.downloadEventListener;
    }

    public DownloadFileTask setDownloadEventListener(DownloadEventListener downloadEventListener) {
        this.downloadEventListener = downloadEventListener;
        return this;
    }

    public TosObjectRequestHandler getHandler() {
        return this.handler;
    }

    public DownloadFileTask setHandler(TosObjectRequestHandler handler) {
        this.handler = handler;
        return this;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public DownloadFileTask setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    public DataTransferListener getDataTransferListener() {
        return this.dataTransferListener;
    }

    public DownloadFileTask setDataTransferListener(DataTransferListener dataTransferListener) {
        this.dataTransferListener = dataTransferListener;
        return this;
    }
}

