/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.comm.event.DataTransferType;
import com.volcengine.tos.comm.event.UploadEventType;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.model.ConcurrentDataTransferListenInputStream;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.TosTask;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.FileUtils;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.UploadEvent;
import com.volcengine.tos.model.object.UploadEventListener;
import com.volcengine.tos.model.object.UploadFileV2Checkpoint;
import com.volcengine.tos.model.object.UploadPartBasicInput;
import com.volcengine.tos.model.object.UploadPartInfo;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

class UploadFileTask
extends TosTask
implements TaskOutput<UploadPartV2Output> {
    private UploadFileV2Checkpoint checkpoint;
    private UploadPartInfo partInfo;
    private boolean enableCheckpoint;
    private String checkpointFile;
    private UploadEventListener uploadEventListener;
    private TosObjectRequestHandler handler;
    private UploadPartV2Output output;
    private ObjectMetaRequestOptions options;
    private RateLimiter rateLimiter;
    private DataTransferListener dataTransferListener;
    private final AtomicLong consumedBytes;

    public UploadFileTask(UploadFileV2Checkpoint checkpoint, int taskIdx, AtomicLong consumedBytes) {
        this.checkpoint = checkpoint;
        this.partInfo = checkpoint.getUploadPartInfos().get(taskIdx);
        this.consumedBytes = consumedBytes;
    }

    @Override
    public Callable<TaskOutput<?>> getCallableTask() {
        return () -> {
            InputStream in = FileUtils.getBoundedFileContent(null, null, this.checkpoint.getFilePath(), this.partInfo.getOffset(), this.partInfo.getPartSize());
            if (this.dataTransferListener != null) {
                in = new ConcurrentDataTransferListenInputStream(in, this.dataTransferListener, this.checkpoint.getFileSize(), this.consumedBytes);
            }
            UploadPartBasicInput basic = UploadPartBasicInput.builder().bucket(this.checkpoint.getBucket()).key(this.checkpoint.getKey()).uploadID(this.checkpoint.getUploadID()).partNumber(this.partInfo.getPartNumber()).rateLimiter(this.rateLimiter).options(this.options).build();
            UploadPartV2Input input = UploadPartV2Input.builder().uploadPartBasicInput(basic).content(in).contentLength(this.partInfo.getPartSize()).build();
            UploadEvent event = new UploadEvent().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setCheckpointFile(this.checkpointFile).setUploadID(this.checkpoint.getUploadID()).setFilePath(this.checkpoint.getFilePath());
            DataTransferStatus status = new DataTransferStatus().setTotalBytes(this.checkpoint.getFileSize());
            try {
                this.output = this.handler.uploadPart(input);
                this.partInfo.setCompleted(true);
                this.partInfo.setEtag(this.output.getEtag());
                this.partInfo.setHashCrc64ecma(CRC64Utils.unsignedLongStringToLong(this.output.getHashCrc64ecma()));
                if (this.enableCheckpoint) {
                    this.checkpoint.writeToFile(this.checkpointFile);
                }
                Util.postUploadEvent(this.uploadEventListener, event.setUploadPartInfo(this.partInfo).setUploadEventType(UploadEventType.UploadEventUploadPartSucceed));
            }
            catch (TosException e) {
                if (Util.needAbortTask(e.getStatusCode())) {
                    Util.postUploadEvent(this.uploadEventListener, event.setTosException(e).setUploadEventType(UploadEventType.UploadEventUploadPartAborted));
                    Util.postDataTransferStatus(this.dataTransferListener, status.setType(DataTransferType.DATA_TRANSFER_FAILED).setConsumedBytes(this.consumedBytes.get()));
                    throw e;
                }
                Util.postUploadEvent(this.uploadEventListener, event.setTosException(e).setUploadEventType(UploadEventType.UploadEventUploadPartFailed));
            }
            return this;
        };
    }

    @Override
    public UploadPartV2Output getOutput() {
        return this.output;
    }

    public UploadFileV2Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public UploadFileTask setCheckpoint(UploadFileV2Checkpoint checkpoint) {
        this.checkpoint = checkpoint;
        return this;
    }

    public UploadPartInfo getPartInfo() {
        return this.partInfo;
    }

    public UploadFileTask setPartInfo(UploadPartInfo partInfo) {
        this.partInfo = partInfo;
        return this;
    }

    public boolean isEnableCheckpoint() {
        return this.enableCheckpoint;
    }

    public UploadFileTask setEnableCheckpoint(boolean enableCheckpoint) {
        this.enableCheckpoint = enableCheckpoint;
        return this;
    }

    public String getCheckpointFile() {
        return this.checkpointFile;
    }

    public UploadFileTask setCheckpointFile(String checkpointFile) {
        this.checkpointFile = checkpointFile;
        return this;
    }

    public UploadEventListener getUploadEventListener() {
        return this.uploadEventListener;
    }

    public UploadFileTask setUploadEventListener(UploadEventListener uploadEventListener) {
        this.uploadEventListener = uploadEventListener;
        return this;
    }

    public TosObjectRequestHandler getHandler() {
        return this.handler;
    }

    public UploadFileTask setHandler(TosObjectRequestHandler handler) {
        this.handler = handler;
        return this;
    }

    public UploadFileTask setOutput(UploadPartV2Output output) {
        this.output = output;
        return this;
    }

    public ObjectMetaRequestOptions getOptions() {
        return this.options;
    }

    public UploadFileTask setOptions(ObjectMetaRequestOptions options) {
        this.options = options;
        return this;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public UploadFileTask setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        return this;
    }

    public DataTransferListener getDataTransferListener() {
        return this.dataTransferListener;
    }

    public UploadFileTask setDataTransferListener(DataTransferListener dataTransferListener) {
        this.dataTransferListener = dataTransferListener;
        return this;
    }
}

