/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.object.DownloadEvent;
import com.volcengine.tos.model.object.DownloadEventListener;
import com.volcengine.tos.model.object.UploadEvent;
import com.volcengine.tos.model.object.UploadEventListener;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

class Util {
    Util() {
    }

    static boolean needAbortTask(int statusCode) {
        return statusCode == 403 || statusCode == 404 || statusCode == 405;
    }

    static void postUploadEvent(UploadEventListener listener, UploadEvent event) {
        if (listener != null && event != null) {
            listener.eventChange(event);
        }
    }

    static void postDownloadEvent(DownloadEventListener listener, DownloadEvent event) {
        if (listener != null && event != null) {
            listener.eventChange(event);
        }
    }

    static void postDataTransferStatus(DataTransferListener listener, DataTransferStatus status) {
        if (listener != null && status != null) {
            listener.dataTransferStatusChange(status);
        }
    }

    static void validatePartSize(long partSize) {
        if (partSize < 0x500000L || partSize > 0x140000000L) {
            throw new IllegalArgumentException("invalid part size, the size must be [5242880, 5368709120]");
        }
    }

    static int determineTaskNum(int taskNum) {
        if (taskNum > 1000) {
            return 1000;
        }
        if (taskNum < 1) {
            return 1;
        }
        return taskNum;
    }

    static synchronized void deleteCheckpointFile(String checkpointFilePath) {
        if (StringUtils.isEmpty(checkpointFilePath)) {
            return;
        }
        File file = new File(checkpointFilePath);
        if (file.isFile() && file.exists()) {
            file.delete();
        }
    }

    static String checkpointPathMd5(String bucket, String key, String versionId) {
        StringBuilder sb = new StringBuilder(bucket).append(".").append(key);
        if (StringUtils.isNotEmpty(versionId)) {
            sb.append(".").append(versionId);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(sb.toString().getBytes());
            return new String(Base64.encodeBase64((byte[])bytes)).replace('+', '-').replace('/', '_');
        }
        catch (NoSuchAlgorithmException e) {
            throw new TosClientException("tos: unable to compute md5", e);
        }
    }
}

