/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.util.StringUtils;
import java.math.BigInteger;

public class CRC64Utils {
    private static final int GF2_DIM = 64;
    private static final long MAX_VALUE = -1L;

    private static long gf2MatrixTimes(long[] mat, long vec) {
        long sum = 0L;
        int i = 0;
        while (vec != 0L) {
            if ((vec & 1L) == 1L) {
                sum ^= mat[i];
            }
            vec >>>= 1;
            ++i;
        }
        return sum;
    }

    private static void gf2MatrixSquare(long[] square, long[] mat) {
        for (int i = 0; i < 64; ++i) {
            square[i] = CRC64Utils.gf2MatrixTimes(mat, mat[i]);
        }
    }

    public static CRC64Checksum combine(CRC64Checksum sum1, CRC64Checksum sum2, long len2) {
        if (len2 == 0L) {
            return new CRC64Checksum(sum1.getValue());
        }
        return new CRC64Checksum(CRC64Utils.combine(sum1.getValue(), sum2.getValue(), len2));
    }

    public static long combine(long crc1, long crc2, long len2) {
        if (len2 == 0L) {
            return crc1;
        }
        long row = 1L;
        long[] even = new long[64];
        long[] odd = new long[64];
        odd[0] = -3932672073523589310L;
        for (int i = 1; i < 64; ++i) {
            odd[i] = row;
            row <<= 1;
        }
        CRC64Utils.gf2MatrixSquare(even, odd);
        CRC64Utils.gf2MatrixSquare(odd, even);
        do {
            CRC64Utils.gf2MatrixSquare(even, odd);
            if ((len2 & 1L) == 1L) {
                crc1 = CRC64Utils.gf2MatrixTimes(even, crc1);
            }
            if ((len2 >>>= 1) == 0L) break;
            CRC64Utils.gf2MatrixSquare(odd, even);
            if ((len2 & 1L) != 1L) continue;
            crc1 = CRC64Utils.gf2MatrixTimes(odd, crc1);
        } while ((len2 >>>= 1) != 0L);
        return crc1 ^= crc2;
    }

    public static String longToUnsignedLongString(long x) {
        return CRC64Utils.longToUnsignedLongString(x, 10);
    }

    public static long unsignedLongStringToLong(String unsignedLong) {
        return CRC64Utils.parseUnsignedLong(unsignedLong, 10);
    }

    static String longToUnsignedLongString(long x, int radix) {
        if (x == 0L) {
            return "0";
        }
        if (x > 0L) {
            return Long.toString(x, radix);
        }
        char[] buf = new char[64];
        int i = buf.length;
        if ((radix & radix - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i] = Character.forDigit((int)x & mask, radix);
            } while ((x >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x >>> 1) / (long)(radix >>> 1) : CRC64Utils.divide(x, radix);
            long rem = x - quotient * (long)radix;
            buf[--i] = Character.forDigit((int)rem, radix);
            for (x = quotient; x > 0L; x /= (long)radix) {
                buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
            }
        }
        return new String(buf, i, buf.length - i);
    }

    static long parseUnsignedLong(String unsignedLongString, int radix) {
        if (StringUtils.isEmpty(unsignedLongString)) {
            return 0L;
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < unsignedLongString.length(); ++pos) {
            int digit = Character.digit(unsignedLongString.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(unsignedLongString);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + unsignedLongString);
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    private static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            return CRC64Utils.compare(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(CRC64Utils.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    private static int compare(long a, long b) {
        return Long.compare(CRC64Utils.flip(a), CRC64Utils.flip(b));
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long current, int digit, int radix) {
            if (current >= 0L) {
                if (current < maxValueDivs[radix]) {
                    return false;
                }
                if (current > maxValueDivs[radix]) {
                    return true;
                }
                return digit > maxValueMods[radix];
            }
            return true;
        }

        static long remainder(long dividend, long divisor) {
            long rem;
            if (divisor < 0L) {
                if (CRC64Utils.compare(dividend, divisor) < 0) {
                    return dividend;
                }
                return dividend - divisor;
            }
            if (dividend >= 0L) {
                return dividend % divisor;
            }
            long quotient = (dividend >>> 1) / divisor << 1;
            return rem - (CRC64Utils.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
        }

        static {
            BigInteger overflow = new BigInteger("10000000000000000", 16);
            for (int i = 2; i <= 36; ++i) {
                ParseOverflowDetection.maxValueDivs[i] = CRC64Utils.divide(-1L, i);
                ParseOverflowDetection.maxValueMods[i] = (int)ParseOverflowDetection.remainder(-1L, i);
                ParseOverflowDetection.maxSafeDigits[i] = overflow.toString(i).length() - 1;
            }
        }
    }
}

