/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.internal.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;

public class ParamsChecker {
    private static final String BUCKET_INVALID_PREFIX_SUFFIX = "-";
    private static final String BUCKET_NAME_PATTERN = "^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$";
    private static final List<String> INVALID_PREFIX_LIST = Arrays.asList("/", "\\");
    private static final List<String> INVALID_OBJECT_KEY_LIST = Arrays.asList(".", "..", "%2e", "%2e.", ".%2e", "%2e%2e");

    public static List<String> parseFromEndpoint(String endpoint) {
        ParamsChecker.ensureNotNull(endpoint, "endpoint is null");
        ArrayList<String> ret = new ArrayList<String>(2);
        String scheme = "https";
        String host = null;
        if (endpoint.startsWith("https") || endpoint.startsWith("http")) {
            HttpUrl url = HttpUrl.parse((String)endpoint);
            if (url != null) {
                scheme = url.scheme();
                host = url.host();
            }
        } else {
            host = endpoint;
        }
        if (host == null) {
            throw new IllegalArgumentException("invalid endpoint");
        }
        ret.add(scheme);
        ret.add(host);
        return ret;
    }

    public static void isValidBucketName(String name) {
        if (StringUtils.isEmpty(name) || name.length() < 3 || name.length() > 63) {
            throw new IllegalArgumentException("invalid bucket name, the length must be [3, 63]");
        }
        if (name.startsWith(BUCKET_INVALID_PREFIX_SUFFIX) || name.endsWith(BUCKET_INVALID_PREFIX_SUFFIX)) {
            throw new IllegalArgumentException("invalid bucket name, the bucket name can be neither starting with '-' nor ending with '-'");
        }
        if (!name.matches(BUCKET_NAME_PATTERN)) {
            throw new IllegalArgumentException("invalid bucket name, the character set is illegal");
        }
    }

    public static void isValidKey(String key) {
        char[] ck;
        if (StringUtils.isEmpty(key) || key.length() > 696) {
            throw new IllegalArgumentException("invalid object name, the length must be [1,696]");
        }
        for (String prefix : INVALID_PREFIX_LIST) {
            if (!key.startsWith(prefix)) continue;
            throw new IllegalArgumentException("invalid object name, the object name can not start with / or \\");
        }
        ParamsChecker.isDotOrDotDot(key);
        for (char c : ck = key.toCharArray()) {
            if (c >= ' ' && c != '\u007f') continue;
            throw new IllegalArgumentException("object key should not contain invisible unicode characters");
        }
        ParamsChecker.isUTF8String(key);
    }

    private static void isDotOrDotDot(String objectKey) {
        for (String key : INVALID_OBJECT_KEY_LIST) {
            if (!key.equalsIgnoreCase(objectKey)) continue;
            throw new IllegalArgumentException("object key should not be . or ..");
        }
    }

    private static void isUTF8String(String objectKey) {
        try {
            objectKey.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("object key should be utf-8 encode");
        }
    }

    public static void isValidBucketNameAndKey(String bucket, String key) {
        ParamsChecker.isValidBucketName(bucket);
        ParamsChecker.isValidKey(key);
    }

    public static void ensureNotNull(Object object, String paramName) {
        Objects.requireNonNull(object, "null " + paramName);
    }

    public static void isValidPartNumber(int partNum) {
        if (partNum < 1 || partNum > 10000) {
            throw new IllegalArgumentException("part number should be between [1, 10000]");
        }
    }
}

