/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.tos.TosClientException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class TosUtils {
    private static final String USER_AGENT;
    public static final ObjectMapper JSON;
    private static Map<String, List<String>> SUPPORTED_REGION;
    private static final int baseDelay = 1;
    private static final int maxDelay = 10;
    private static final double factor = 1.6;
    private static final double jitter = 0.2;
    private static final ThreadLocalRandom random;
    private static final boolean[] nonEscape;
    private static final byte[] escapeChar;

    public static String getUserAgent() {
        return USER_AGENT;
    }

    public static Map<String, List<String>> getSupportedRegion() {
        return TosUtils.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<String>> getInstance() throws TosClientException {
        if (SUPPORTED_REGION != null) {
            return SUPPORTED_REGION;
        }
        Class<TosUtils> clazz = TosUtils.class;
        synchronized (TosUtils.class) {
            SUPPORTED_REGION = new HashMap<String, List<String>>(3);
            SUPPORTED_REGION.put("cn-beijing", Arrays.asList("tos-cn-beijing.volces.com"));
            SUPPORTED_REGION.put("cn-guangzhou", Arrays.asList("tos-cn-guangzhou.volces.com"));
            SUPPORTED_REGION.put("cn-shanghai", Arrays.asList("tos-cn-shanghai.volces.com"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return SUPPORTED_REGION;
        }
    }

    public static String tryEncodeValue(String key, String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        String encodedValue = value;
        if (TosUtils.containChinese(value)) {
            try {
                encodedValue = URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
            }
            catch (UnsupportedEncodingException e) {
                throw new TosClientException("tos: unsupported http header value in key: " + key, e);
            }
        }
        return encodedValue;
    }

    public static String tryDecodeValue(String key, String value) {
        String decodedValue;
        if (key == null || value == null) {
            return null;
        }
        try {
            decodedValue = URLDecoder.decode(value, "UTF-8");
            if (!TosUtils.containChinese(decodedValue)) {
                return value;
            }
            if (value.contains("+") && decodedValue.contains(" ")) {
                decodedValue = decodedValue.replace(" ", "+");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new TosClientException("tos: unsupported http header value in key: " + key, e);
        }
        return decodedValue;
    }

    private static boolean containChinese(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (c > '\u001f' && c < '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String uriEncode(String in, boolean encodeSlash) {
        byte[] inBytes;
        int hexCount = 0;
        for (byte b : inBytes = in.getBytes(StandardCharsets.UTF_8)) {
            int uintByte = b & 0xFF;
            if (b == 47) {
                if (!encodeSlash) continue;
                ++hexCount;
                continue;
            }
            if (nonEscape[uintByte]) continue;
            ++hexCount;
        }
        byte[] encoded = new byte[inBytes.length + 2 * hexCount];
        int j = 0;
        for (int i = 0; i < inBytes.length; ++i) {
            int uintByte = inBytes[i] & 0xFF;
            if (uintByte == 47) {
                if (encodeSlash) {
                    encoded[j] = 37;
                    encoded[j + 1] = 50;
                    encoded[j + 2] = 70;
                    j += 3;
                    continue;
                }
                encoded[j] = inBytes[i];
                ++j;
                continue;
            }
            if (!nonEscape[uintByte]) {
                encoded[j] = 37;
                encoded[j + 1] = escapeChar[uintByte >> 4];
                encoded[j + 2] = escapeChar[uintByte & 0xF];
                j += 3;
                continue;
            }
            encoded[j] = inBytes[i];
            ++j;
        }
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static long backoff(int retries) {
        double backoff;
        if (retries == 0) {
            return 1000L;
        }
        double max = 10.0;
        for (backoff = 1.0; backoff < max && retries > 0; backoff *= 1.6, --retries) {
        }
        if (backoff > max) {
            backoff = max;
        }
        if ((backoff *= 1.0 + 0.2 * (random.nextDouble(1.0) * 2.0 - 1.0)) < 0.0) {
            return 0L;
        }
        return (long)(backoff * 1000.0);
    }

    static {
        int ch;
        USER_AGENT = String.format("%s/%s (%s/%s;%s)", "ve-tos-java-sdk", "v2.2.0", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("java.version", "0"));
        JSON = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SUPPORTED_REGION = null;
        random = ThreadLocalRandom.current();
        nonEscape = new boolean[256];
        escapeChar = "0123456789ABCDEF".getBytes(StandardCharsets.UTF_8);
        for (ch = 97; ch <= 122; ch = (int)((byte)(ch + 1))) {
            TosUtils.nonEscape[ch] = true;
        }
        for (ch = 65; ch <= 90; ch = (int)((byte)(ch + 1))) {
            TosUtils.nonEscape[ch] = true;
        }
        for (ch = 48; ch <= 57; ch = (int)((byte)(ch + 1))) {
            TosUtils.nonEscape[ch] = true;
        }
        TosUtils.nonEscape[45] = true;
        TosUtils.nonEscape[95] = true;
        TosUtils.nonEscape[46] = true;
        TosUtils.nonEscape[126] = true;
    }
}

