/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util.ratelimit;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.ratelimit.RateLimitRes;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.internal.util.ParamsChecker;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RateLimitedInputStream
extends FilterInputStream {
    private RateLimiter rateLimiter;

    public RateLimitedInputStream(InputStream in, RateLimiter rateLimiter) {
        super(in);
        this.rateLimiter = rateLimiter;
    }

    @Override
    public int read() throws IOException {
        this.acquire(1L);
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b != null) {
            this.acquire(b.length);
        }
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b != null) {
            this.acquire(Math.min(b.length, len));
        }
        return super.read(b, off, len);
    }

    private void acquire(long want) {
        ParamsChecker.ensureNotNull(this.rateLimiter, "RateLimiter is null");
        RateLimitRes res = this.rateLimiter.acquire(want);
        if (res != null) {
            while (!res.isOk()) {
                try {
                    long timeToSleepNanos = res.getTimeToWaitNanos();
                    long timeMills = (long)((double)timeToSleepNanos / 1000000.0);
                    long timeNanos = (long)((double)timeToSleepNanos % 1000000.0);
                    Thread.sleep(timeMills, (int)timeNanos);
                    res = this.rateLimiter.acquire(want);
                }
                catch (InterruptedException e) {
                    throw new TosClientException("tos: rateLimiter sleep interrupted", e);
                }
            }
        }
    }
}

