/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.RequestInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import okio.Source;

public class TosResponse
implements AutoCloseable,
Serializable {
    private int statusCode;
    private long contentLength;
    private Map<String, String> headers = Collections.emptyMap();
    @JsonIgnore
    private transient InputStream inputStream;
    private transient Source source;

    public RequestInfo RequestInfo() {
        return new RequestInfo(this.getRequesID(), this.getID2(), this.getStatusCode(), this.headers);
    }

    public String getRequesID() {
        return this.headers.get("X-Tos-Request-Id".toLowerCase());
    }

    public String getID2() {
        return this.headers.get("X-Tos-Id-2".toLowerCase());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public TosResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TosResponse setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getInputStreamContentLength() throws IOException {
        return this.inputStream.available() == 0 ? -1L : (long)this.inputStream.available();
    }

    public TosResponse setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeaderWithKeyIgnoreCase(String key) {
        if (StringUtils.isEmpty(key) || this.headers.size() == 0) {
            return null;
        }
        return this.headers.get(key.toLowerCase());
    }

    public TosResponse setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    protected Source getSource() {
        return this.source;
    }

    protected TosResponse setSource(Source source) {
        this.source = source;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public String toString() {
        return "TosResponse{statusCode=" + this.statusCode + ", contentLength=" + this.contentLength + ", headers=" + this.headers + '}';
    }
}

