/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.comm.io.Retryable;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.base64.Base64;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

class WrappedTransportRequestBody
extends RequestBody
implements Closeable {
    private InputStream content;
    private final MediaType contentType;
    private final boolean useTrailerHeader;
    private long contentLength;
    private long decodedContentLength;
    private volatile long totalBytesRead = 0L;

    WrappedTransportRequestBody(MediaType contentType, InputStream content, long contentLength) {
        ParamsChecker.ensureNotNull(content, "Content");
        this.content = content;
        this.contentType = contentType;
        this.contentLength = contentLength;
        if (this.contentLength < 0L) {
            this.contentLength = -1L;
        }
        this.decodedContentLength = this.contentLength;
        this.useTrailerHeader = false;
    }

    WrappedTransportRequestBody(MediaType contentType, TosRequest request) {
        ParamsChecker.ensureNotNull(request.getContent(), "Content");
        this.content = request.getContent();
        this.contentType = contentType;
        this.contentLength = request.getContentLength();
        if (this.contentLength < 0L) {
            this.contentLength = -1L;
        }
        this.useTrailerHeader = request.isUseTrailerHeader();
        this.decodedContentLength = this.contentLength;
        if (this.useTrailerHeader && request.getHeaders() != null && request.getHeaders().containsKey("x-tos-decoded-content-length")) {
            this.decodedContentLength = Long.parseLong(request.getHeaders().get("x-tos-decoded-content-length"));
        }
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.reset();
        if (this.contentLength < 0L) {
            if (this.useTrailerHeader) {
                this.writeAllWithChunkedWithTrailerHeader(sink);
                this.writeTosChunkedTrailer(sink);
                this.writeTrailerHeader(sink);
            } else {
                this.writeAllWithChunked(sink);
            }
        } else {
            long remaining = this.decodedContentLength;
            if (this.useTrailerHeader) {
                this.writeTosChunkedHeader(sink, remaining);
                this.writeAll(sink, remaining);
                this.writeTosChunkedTrailer(sink);
                this.writeTrailerHeader(sink);
            } else {
                this.writeAll(sink, remaining);
            }
        }
    }

    void writeTosChunkedHeader(BufferedSink sink, long chunkSize) throws IOException {
        sink.writeUtf8(Long.toHexString(chunkSize));
        sink.writeByte(13);
        sink.writeByte(10);
    }

    void writeTosChunkedTrailer(BufferedSink sink) throws IOException {
        if (this.totalBytesRead > 0L) {
            sink.writeByte(13);
            sink.writeByte(10);
        }
        this.writeTosChunkedHeader(sink, 0L);
    }

    void writeTrailerHeader(BufferedSink sink) throws IOException {
        sink.writeUtf8("x-tos-hash-crc64ecma");
        sink.writeUtf8(":");
        long crc64 = ((CheckedInputStream)this.content).getChecksum().getValue();
        sink.write(Base64.encodeBase64(TosUtils.longToByteArray(crc64)));
        sink.writeByte(13);
        sink.writeByte(10);
        sink.writeByte(13);
        sink.writeByte(10);
    }

    void reset() throws IOException {
        if (this.totalBytesRead > 0L && this.content != null) {
            if (this.content.markSupported()) {
                TosUtils.getLogger().debug("tos: okhttp writeTo call reset");
                this.content.reset();
                this.totalBytesRead = 0L;
            } else if (this.content instanceof Retryable) {
                TosUtils.getLogger().debug("tos: okhttp writeTo call reset");
                ((Retryable)((Object)this.content)).reset();
                this.totalBytesRead = 0L;
            }
        }
    }

    private void writeAll(BufferedSink sink, long remaining) throws IOException {
        int maxToRead;
        int bytesRead = 0;
        byte[] tmp = new byte[8192];
        while (remaining > 0L && (bytesRead = this.content.read(tmp, 0, maxToRead = (long)tmp.length < remaining ? tmp.length : (int)remaining)) != -1) {
            sink.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            remaining -= (long)bytesRead;
        }
    }

    private void writeAllWithChunked(BufferedSink sink) throws IOException {
        int bytesRead = 0;
        byte[] tmp = new byte[8192];
        bytesRead = this.content.read(tmp);
        while (bytesRead != -1) {
            sink.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            bytesRead = this.content.read(tmp);
        }
    }

    private void writeAllWithChunkedWithTrailerHeader(BufferedSink sink) throws IOException {
        int bytesRead = 0;
        byte[] tmp = new byte[65536];
        bytesRead = this.content.read(tmp);
        while (bytesRead != -1) {
            this.writeTosChunkedHeader(sink, bytesRead);
            sink.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            bytesRead = this.content.read(tmp);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }

    protected InputStream getContent() {
        return this.content;
    }

    protected long getTotalBytesRead() {
        return this.totalBytesRead;
    }
}

