/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.volcengine.tos.internal.util.StringUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GenericInput {
    @JsonIgnore
    protected Date requestDate;
    @JsonIgnore
    protected String requestHost;
    private Map<String, String> requestHeaders;
    private Map<String, String> requestQuery;
    private static final Set<String> DISALLOWED_HEADERS = new HashSet<String>(Arrays.asList("content-length", "host", "connection", "x-tos-date", "range", "transfer-encoding", "authorization", "date"));

    public GenericInput setRequestHeader(String key, String value) {
        if (DISALLOWED_HEADERS.contains(key.toLowerCase())) {
            return this;
        }
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap<String, String>();
        }
        if (!StringUtils.isNotEmpty(value) || !StringUtils.isNotEmpty(key)) {
            throw new IllegalArgumentException("Invalid header key or value");
        }
        this.requestHeaders.put(key.toLowerCase(), value);
        return this;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public GenericInput setRequestQuery(String key, String value) {
        if (this.requestQuery == null) {
            this.requestQuery = new HashMap<String, String>();
        }
        if (!StringUtils.isNotEmpty(value) || !StringUtils.isNotEmpty(key)) {
            throw new IllegalArgumentException("Invalid header key or value");
        }
        this.requestQuery.put(key, value);
        return this;
    }

    public Map<String, String> getRequestQuery() {
        return this.requestQuery;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public GenericInput setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
        return this;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public GenericInput setRequestHost(String requestHost) {
        this.requestHost = requestHost;
        return this;
    }
}

