/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.object.PreSignedPolicyURLGenerator;
import java.util.Map;
import okhttp3.HttpUrl;

public class DefaultPreSignedPolicyURLGenerator
implements PreSignedPolicyURLGenerator {
    private String signatureQuery;
    private String host;
    private String scheme;
    private String bucket;
    private boolean isCustomDomain;

    public String getSignatureQuery() {
        return this.signatureQuery;
    }

    public DefaultPreSignedPolicyURLGenerator setSignatureQuery(String signatureQuery) {
        this.signatureQuery = signatureQuery;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DefaultPreSignedPolicyURLGenerator setHost(String host) {
        this.host = host;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public DefaultPreSignedPolicyURLGenerator setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public DefaultPreSignedPolicyURLGenerator setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public boolean isCustomDomain() {
        return this.isCustomDomain;
    }

    public DefaultPreSignedPolicyURLGenerator setCustomDomain(boolean customDomain) {
        this.isCustomDomain = customDomain;
        return this;
    }

    @Override
    public String getSignedURLForList(Map<String, String> additionalQuery) {
        return this.generateUrl(null, additionalQuery);
    }

    @Override
    public String getSignedURLForGetOrHead(String key, Map<String, String> additionalQuery) {
        if (StringUtils.isEmpty(key)) {
            throw new TosClientException("empty key", null);
        }
        return this.generateUrl(key, additionalQuery);
    }

    private String generateUrl(String key, Map<String, String> additionalQuery) {
        HttpUrl.Builder url = new HttpUrl.Builder();
        String host = null;
        if (!this.isCustomDomain) {
            ParamsChecker.isValidBucketName(this.bucket);
            host = this.bucket + "." + this.host;
        } else {
            host = this.host;
        }
        String path = StringUtils.isNotEmpty(key) ? key : "";
        url = url.scheme(this.scheme).host(host).addPathSegment(path).encodedQuery(this.signatureQuery);
        if (additionalQuery != null) {
            for (Map.Entry<String, String> entry : additionalQuery.entrySet()) {
                url.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        return url.build().toString();
    }

    public String toString() {
        return "DefaultPreSignedPolicyURLGenerator{signatureQuery='" + this.signatureQuery + '\'' + ", host='" + this.host + '\'' + ", scheme='" + this.scheme + '\'' + ", bucket='" + this.bucket + '\'' + ", isCustomDomain=" + this.isCustomDomain + '}';
    }
}

