/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.auth.Credential;
import com.volcengine.tos.auth.SignKeyInfo;
import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.model.PostPolicyJson;
import com.volcengine.tos.internal.model.PreSignedPolicyJson;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.SigningUtils;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.base64.Base64;
import com.volcengine.tos.model.object.DefaultPreSignedPolicyURLGenerator;
import com.volcengine.tos.model.object.PolicySignatureCondition;
import com.volcengine.tos.model.object.PostSignatureCondition;
import com.volcengine.tos.model.object.PreSignedPolicyURLInput;
import com.volcengine.tos.model.object.PreSignedPolicyURLOutput;
import com.volcengine.tos.model.object.PreSignedPostSignatureInput;
import com.volcengine.tos.model.object.PreSignedPostSignatureOutput;
import com.volcengine.tos.model.object.PreSignedURLInput;
import com.volcengine.tos.model.object.PreSignedURLOutput;
import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

public class TosPreSignedRequestHandler {
    private TosRequestFactory factory;
    private Signer signer;

    public TosPreSignedRequestHandler(TosRequestFactory factory, Signer signer) {
        ParamsChecker.ensureNotNull(factory, "TosRequestFactory");
        this.factory = factory;
        this.signer = signer;
    }

    public TosRequestFactory getFactory() {
        return this.factory;
    }

    public TosPreSignedRequestHandler setFactory(TosRequestFactory factory) {
        this.factory = factory;
        return this;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public TosPreSignedRequestHandler setSigner(Signer signer) {
        this.signer = signer;
        return this;
    }

    public PreSignedURLOutput preSignedURL(PreSignedURLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PreSignedURLInput");
        boolean useCustomDomain = this.factory.isCustomDomain();
        if (input.isCustomDomain() != null) {
            useCustomDomain = input.isCustomDomain();
        }
        if (!useCustomDomain) {
            ParamsChecker.isValidBucketName(input.getBucket());
        }
        ParamsChecker.isValidHttpMethod(input.getHttpMethod());
        long ttl = TosUtils.validateAndGetTtl(input.getExpires());
        String objectKey = input.getKey();
        if (StringUtils.isEmpty(objectKey)) {
            objectKey = "";
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), objectKey, input.getHeader());
        builder.setUrlMode(useCustomDomain ? 2 : 0);
        if (StringUtils.isNotEmpty(input.getAlternativeEndpoint())) {
            String newHost = ParamsChecker.parseFromEndpoint(input.getAlternativeEndpoint()).get(1);
            builder.setHost(newHost);
        }
        if (input.getQuery() != null) {
            input.getQuery().forEach(builder::withQuery);
        }
        TosRequest request = this.factory.build(builder, input.getHttpMethod(), ttl);
        try {
            return new PreSignedURLOutput(request.toURL().toString(), request.getHeaders());
        }
        catch (URISyntaxException e) {
            throw new TosClientException("uri syntax exception", e);
        }
    }

    public PreSignedPostSignatureOutput preSignedPostSignature(PreSignedPostSignatureInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PreSignedPostSignatureInput");
        long ttl = TosUtils.validateAndGetTtl(input.getExpires());
        OffsetDateTime now = Instant.now().atOffset(ZoneOffset.UTC);
        String date8601 = now.format(SigningUtils.iso8601Layout);
        String dateDay = now.format(SigningUtils.yyyyMMdd);
        String region = null;
        String ak = null;
        String sk = null;
        String securityToken = null;
        if (this.signer != null) {
            Object cred;
            if (this.signer.getCredentialsProvider() != null) {
                cred = this.signer.getCredentialsProvider().getCredentials((int)ttl);
                ak = cred.getAk();
                sk = cred.getSk();
                securityToken = cred.getSecurityToken();
            } else if (this.signer.getCredential() != null) {
                cred = this.signer.getCredential().credential();
                ak = ((Credential)cred).getAccessKeyId();
                sk = ((Credential)cred).getAccessKeySecret();
                securityToken = ((Credential)cred).getSecurityToken();
            }
            region = this.signer.getRegion();
        }
        ArrayList<Object> conditions = new ArrayList<Object>();
        conditions.add(new PostSignatureCondition("X-Tos-Algorithm", "TOS4-HMAC-SHA256"));
        conditions.add(new PostSignatureCondition("X-Tos-Date", date8601));
        String credential = null;
        if (ak != null && sk != null && region != null) {
            credential = String.format("%s/%s/%s/tos/request", ak, dateDay, region);
            conditions.add(new PostSignatureCondition("X-Tos-Credential", credential));
            if (StringUtils.isNotEmpty(securityToken)) {
                conditions.add(new PostSignatureCondition("X-Tos-Security-Token", securityToken));
            }
        }
        if (StringUtils.isNotEmpty(input.getBucket())) {
            ParamsChecker.isValidBucketName(input.getBucket());
            conditions.add(new PostSignatureCondition("bucket", input.getBucket()));
        }
        if (StringUtils.isNotEmpty(input.getKey())) {
            ParamsChecker.isValidKey(input.getKey());
            conditions.add(new PostSignatureCondition("key", input.getKey()));
        }
        if (input.getConditions() != null) {
            conditions.addAll(input.getConditions());
        }
        if (input.getContentLengthRange() != null) {
            String key = String.valueOf(input.getContentLengthRange().getRangeStart());
            String value = String.valueOf(input.getContentLengthRange().getRangeEnd());
            conditions.add(new PostSignatureCondition(key, value, "content-length-range"));
        }
        if (input.getMultiValuesConditions() != null) {
            conditions.addAll(input.getMultiValuesConditions());
        }
        String expiration = now.plusSeconds(ttl).format(SigningUtils.serverTimeFormat);
        PostPolicyJson policyJson = new PostPolicyJson().setConditions(conditions).setExpiration(expiration);
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(policyJson);
        String originPolicy = StringUtils.toString(new ByteArrayInputStream(marshalResult.getData()), "policyJson");
        byte[] signK = null;
        if (ak != null && sk != null && region != null) {
            signK = SigningUtils.signKey(new SignKeyInfo().setSk(sk).setDate(dateDay).setRegion(region));
        }
        byte[] policyInByte = Base64.encodeBase64(marshalResult.getData());
        String policy = StringUtils.toString(new ByteArrayInputStream(policyInByte), "policyInByte");
        byte[] sign = SigningUtils.hmacSha256(signK, policyInByte);
        String signature = String.valueOf(SigningUtils.toHex(sign));
        return new PreSignedPostSignatureOutput().setOriginPolicy(originPolicy).setPolicy(policy).setAlgorithm("TOS4-HMAC-SHA256").setCredential(credential).setDate(date8601).setSignature(signature);
    }

    public PreSignedPolicyURLOutput preSignedPolicyURL(PreSignedPolicyURLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PreSingedPolicyURLInput");
        ParamsChecker.isValidBucketName(input.getBucket());
        if (input.getConditions() == null || input.getConditions().size() == 0) {
            throw new TosClientException("empty PolicySignatureConditions", null);
        }
        for (PolicySignatureCondition condition : input.getConditions()) {
            if (StringUtils.equals(condition.getKey(), "key")) continue;
            throw new TosClientException("invalid pre signed url conditions, condition key should be 'key'", null);
        }
        long ttl = TosUtils.validateAndGetTtl(input.getExpires());
        OffsetDateTime now = Instant.now().atOffset(ZoneOffset.UTC);
        String date8601 = now.format(SigningUtils.iso8601Layout);
        String dateDay = now.format(SigningUtils.yyyyMMdd);
        ArrayList<Map.Entry<String, String>> query = new ArrayList<Map.Entry<String, String>>();
        query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Algorithm", "TOS4-HMAC-SHA256"));
        query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Date", date8601));
        query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Expires", String.valueOf(ttl)));
        String region = null;
        String ak = null;
        String sk = null;
        String securityToken = null;
        if (this.signer != null) {
            Object cred;
            if (this.signer.getCredentialsProvider() != null) {
                cred = this.signer.getCredentialsProvider().getCredentials((int)ttl);
                ak = cred.getAk();
                sk = cred.getSk();
                securityToken = cred.getSecurityToken();
            } else if (this.signer.getCredential() != null) {
                cred = this.signer.getCredential().credential();
                ak = ((Credential)cred).getAccessKeyId();
                sk = ((Credential)cred).getAccessKeySecret();
                securityToken = ((Credential)cred).getSecurityToken();
            }
            region = this.signer.getRegion();
        }
        String credential = null;
        if (ak != null && sk != null && region != null) {
            credential = String.format("%s/%s/%s/tos/request", ak, dateDay, region);
            query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Credential", credential));
            if (StringUtils.isNotEmpty(securityToken)) {
                query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Security-Token", securityToken));
            }
        }
        ArrayList<PolicySignatureCondition> conditions = new ArrayList<PolicySignatureCondition>(input.getConditions());
        conditions.add(new PolicySignatureCondition().setKey("bucket").setValue(input.getBucket()));
        PreSignedPolicyJson policyJson = new PreSignedPolicyJson().setConditions(conditions);
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(policyJson);
        byte[] policyInByte = Base64.encodeBase64(marshalResult.getData());
        String policy = StringUtils.toString(new ByteArrayInputStream(policyInByte), "policyInByte");
        query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Policy", policy));
        int split = 10;
        String canonicalStr = SigningUtils.encodeQuery(query) + '\n' + "UNSIGNED-PAYLOAD";
        byte[] sha256Value = SigningUtils.sha256(canonicalStr);
        String hexValue = String.valueOf(SigningUtils.toHex(sha256Value));
        String buf = "TOS4-HMAC-SHA256\n" + date8601 + '\n' + dateDay + '/' + region + "/tos/request" + '\n' + hexValue;
        byte[] signK = null;
        if (ak != null && sk != null && region != null) {
            signK = SigningUtils.signKey(new SignKeyInfo().setSk(sk).setDate(dateDay).setRegion(region));
        }
        byte[] sign = SigningUtils.hmacSha256(signK, buf.getBytes());
        query.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Signature", String.valueOf(SigningUtils.toHex(sign))));
        String rawQuery = SigningUtils.toQuery(query);
        String scheme = this.factory.getScheme();
        String host = this.factory.getHost();
        if (StringUtils.isNotEmpty(input.getAlternativeEndpoint())) {
            host = ParamsChecker.parseFromEndpoint(input.getAlternativeEndpoint()).get(1);
        }
        DefaultPreSignedPolicyURLGenerator generator = new DefaultPreSignedPolicyURLGenerator().setScheme(scheme).setSignatureQuery(rawQuery).setCustomDomain(input.isCustomDomain()).setBucket(input.getBucket()).setHost(host);
        return new PreSignedPolicyURLOutput().setPreSignedPolicyURLGenerator(generator).setScheme(scheme).setHost(host).setSignatureQuery(rawQuery);
    }
}

