/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.comm.io.Retryable;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.base64.Base64;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CheckedInputStream;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;

class WrappedApacheTransportRequestBody
extends AbstractHttpEntity
implements Closeable {
    private final InputStream content;
    private final ContentType contentType;
    private final boolean useTrailerHeader;
    private long contentLength;
    private long decodedContentLength;
    private volatile long totalBytesRead = 0L;

    WrappedApacheTransportRequestBody(ContentType contentType, InputStream content, long contentLength) {
        super(contentType, null);
        ParamsChecker.ensureNotNull(content, "Content");
        this.content = content;
        this.contentType = contentType;
        this.contentLength = contentLength;
        if (this.contentLength < 0L) {
            this.contentLength = -1L;
        }
        this.decodedContentLength = this.contentLength;
        this.useTrailerHeader = false;
    }

    WrappedApacheTransportRequestBody(ContentType contentType, TosRequest request) {
        super(contentType, null);
        ParamsChecker.ensureNotNull(request.getContent(), "Content");
        this.content = request.getContent();
        this.contentType = contentType;
        this.contentLength = request.getContentLength();
        if (this.contentLength < 0L) {
            this.contentLength = -1L;
        }
        this.useTrailerHeader = request.isUseTrailerHeader();
        this.decodedContentLength = this.contentLength;
        if (this.useTrailerHeader && request.getHeaders() != null && request.getHeaders().containsKey("x-tos-decoded-content-length")) {
            this.decodedContentLength = Long.parseLong(request.getHeaders().get("x-tos-decoded-content-length"));
        }
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.content instanceof Retryable;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.content;
    }

    public void writeTo(OutputStream outStream) throws IOException {
        this.reset();
        if (this.contentLength < 0L) {
            if (this.useTrailerHeader) {
                this.writeAllWithChunkedWithTrailerHeader(outStream);
                this.writeTosChunkedTrailer(outStream);
                this.writeTrailerHeader(outStream);
            } else {
                this.writeAllWithChunked(outStream);
            }
        } else {
            long remaining = this.decodedContentLength;
            if (this.useTrailerHeader) {
                this.writeTosChunkedHeader(outStream, remaining);
                this.writeAll(outStream, remaining);
                this.writeTosChunkedTrailer(outStream);
                this.writeTrailerHeader(outStream);
            } else {
                this.writeAll(outStream, remaining);
            }
        }
        if (this.decodedContentLength >= 0L && this.decodedContentLength > this.totalBytesRead) {
            throw new IOException("tos: content length inconsistent, totalBytesRead: " + this.totalBytesRead + ", contentLength: " + this.decodedContentLength);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }

    void writeTosChunkedHeader(OutputStream outStream, long chunkSize) throws IOException {
        outStream.write(this.toUft8(Long.toHexString(chunkSize)));
        outStream.write(13);
        outStream.write(10);
    }

    void writeTosChunkedTrailer(OutputStream outStream) throws IOException {
        if (this.totalBytesRead > 0L) {
            outStream.write(13);
            outStream.write(10);
        }
        this.writeTosChunkedHeader(outStream, 0L);
    }

    void writeTrailerHeader(OutputStream outStream) throws IOException {
        outStream.write(this.toUft8("x-tos-hash-crc64ecma"));
        outStream.write(this.toUft8(":"));
        long crc64 = ((CheckedInputStream)this.content).getChecksum().getValue();
        outStream.write(Base64.encodeBase64(TosUtils.longToByteArray(crc64)));
        outStream.write(13);
        outStream.write(10);
        outStream.write(13);
        outStream.write(10);
    }

    void reset() throws IOException {
        if (this.totalBytesRead > 0L && this.content != null) {
            if (this.content.markSupported()) {
                TosUtils.getLogger().debug("tos: apache http writeTo call reset");
                this.content.reset();
                this.totalBytesRead = 0L;
            } else if (this.content instanceof Retryable) {
                TosUtils.getLogger().debug("tos: apache http writeTo call reset");
                ((Retryable)((Object)this.content)).reset();
                this.totalBytesRead = 0L;
            }
        }
    }

    byte[] toUft8(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private void writeAll(OutputStream outStream, long remaining) throws IOException {
        int maxToRead;
        int bytesRead;
        byte[] tmp = new byte[8192];
        while (remaining > 0L && (bytesRead = this.content.read(tmp, 0, maxToRead = (long)tmp.length < remaining ? tmp.length : (int)remaining)) != -1) {
            outStream.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            remaining -= (long)bytesRead;
        }
    }

    private void writeAllWithChunked(OutputStream outStream) throws IOException {
        byte[] tmp = new byte[8192];
        int bytesRead = this.content.read(tmp);
        while (bytesRead != -1) {
            outStream.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            bytesRead = this.content.read(tmp);
        }
    }

    private void writeAllWithChunkedWithTrailerHeader(OutputStream outStream) throws IOException {
        byte[] tmp = new byte[65536];
        int bytesRead = this.content.read(tmp);
        while (bytesRead != -1) {
            this.writeTosChunkedHeader(outStream, bytesRead);
            outStream.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            bytesRead = this.content.read(tmp);
        }
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public boolean isStreaming() {
        return true;
    }
}

