/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.volcengine.tos.TosException;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.taskman.AbortTaskHook;
import com.volcengine.tos.internal.taskman.InternalCancelHook;
import com.volcengine.tos.internal.taskman.TaskManager;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.CancelHook;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class UploadFileTaskCanceler
implements InternalCancelHook,
CancelHook,
AbortTaskHook {
    private TosObjectRequestHandler handler;
    private String bucket;
    private String key;
    private String uploadID;
    private String checkpointFilePath;
    private boolean enableCheckpoint;
    private TaskManager taskMan;
    private boolean aborted;
    private Lock lock;

    public UploadFileTaskCanceler() {
        this.lock = new ReentrantLock();
    }

    public UploadFileTaskCanceler(TosObjectRequestHandler handler, TaskManager taskMan, String bucket, String key, String uploadID, String checkpointFilePath, boolean enableCheckpoint) {
        this.handler = handler;
        this.taskMan = taskMan;
        this.bucket = bucket;
        this.key = key;
        this.uploadID = uploadID;
        this.checkpointFilePath = checkpointFilePath;
        this.enableCheckpoint = enableCheckpoint;
        this.lock = new ReentrantLock();
    }

    public TosObjectRequestHandler getHandler() {
        return this.handler;
    }

    public UploadFileTaskCanceler setHandler(TosObjectRequestHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public void internal() {
    }

    @Override
    public synchronized void abort() {
        try {
            if (this.taskMan != null) {
                this.taskMan.suspend();
            }
            this.handler.abortMultipartUpload(new AbortMultipartUploadInput().setBucket(this.bucket).setKey(this.key).setUploadID(this.uploadID));
        }
        catch (TosException e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            TosUtils.getLogger().debug("tos: abortMultipartUpload return 404 and will ignore it.");
        }
        finally {
            if (this.taskMan != null) {
                this.taskMan.shutdown();
            }
            if (this.enableCheckpoint) {
                Util.deleteCheckpointFile(this.checkpointFilePath);
            }
        }
    }

    @Override
    public void cancel(boolean isAbort) {
        if (this.handler == null || this.taskMan == null || StringUtils.isEmpty(this.bucket) || StringUtils.isEmpty(this.key) || StringUtils.isEmpty(this.uploadID)) {
            return;
        }
        if (this.lock.tryLock()) {
            try {
                if (this.aborted) {
                    return;
                }
                if (isAbort) {
                    this.abort();
                } else if (this.taskMan != null) {
                    this.taskMan.shutdown();
                }
                this.aborted = true;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public UploadFileTaskCanceler setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public UploadFileTaskCanceler setKey(String key) {
        this.key = key;
        return this;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public UploadFileTaskCanceler setUploadID(String uploadID) {
        this.uploadID = uploadID;
        return this;
    }

    public String getCheckpointFilePath() {
        return this.checkpointFilePath;
    }

    public UploadFileTaskCanceler setCheckpointFilePath(String checkpointFilePath) {
        this.checkpointFilePath = checkpointFilePath;
        return this;
    }

    public boolean isEnableCheckpoint() {
        return this.enableCheckpoint;
    }

    public UploadFileTaskCanceler setEnableCheckpoint(boolean enableCheckpoint) {
        this.enableCheckpoint = enableCheckpoint;
        return this;
    }

    public TaskManager getTaskMan() {
        return this.taskMan;
    }

    public UploadFileTaskCanceler setTaskMan(TaskManager taskMan) {
        this.taskMan = taskMan;
        return this;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }
}

