/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.internal.util.StringUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.net.URIBuilder;

public class ParamsChecker {
    private static final String BUCKET_INVALID_PREFIX_SUFFIX = "-";
    private static final String BUCKET_NAME_PATTERN = "^[a-z0-9][a-z0-9-]{1,61}[a-z0-9]$";
    private static final List<String> INVALID_OBJECT_KEY_LIST = Arrays.asList(".", "..", "%2e", "%2e.", ".%2e", "%2e%2e");
    private static final String IP_V6_PATTERN = "^([\\da-fA-F]{1,4}:){7}[\\da-fA-F]{1,4}|:((:[\\da\u2212fA\u2212F]1,4)1,6|:)|:((:[\\da\u2212fA\u2212F]1,4)1,6|:)|^[\\da-fA-F]{1,4}:((:[\\da-fA-F]{1,4}){1,5}|:)|([\\da\u2212fA\u2212F]1,4:)2((:[\\da\u2212fA\u2212F]1,4)1,4|:)|([\\da\u2212fA\u2212F]1,4:)2((:[\\da\u2212fA\u2212F]1,4)1,4|:)|^([\\da-fA-F]{1,4}:){3}((:[\\da-fA-F]{1,4}){1,3}|:)|([\\da\u2212fA\u2212F]1,4:)4((:[\\da\u2212fA\u2212F]1,4)1,2|:)|([\\da\u2212fA\u2212F]1,4:)4((:[\\da\u2212fA\u2212F]1,4)1,2|:)|^([\\da-fA-F]{1,4}:){5}:([\\da-fA-F]{1,4})?|([\\da\u2212fA\u2212F]1,4:)6:|([\\da\u2212fA\u2212F]1,4:)6:";

    public static List<String> parseFromEndpoint(String endpoint) {
        if (StringUtils.isEmpty(endpoint)) {
            throw new TosClientException("empty endpoint", null);
        }
        ParamsChecker.validateIfS3Endpoint(endpoint);
        ArrayList<String> ret = new ArrayList<String>(2);
        String scheme = "https";
        String host = null;
        if (endpoint.startsWith("https://")) {
            host = endpoint.substring("https://".length());
        } else if (endpoint.startsWith("http")) {
            scheme = "http";
            host = endpoint.substring("http://".length());
        } else {
            host = endpoint;
        }
        ret.add(scheme);
        ret.add(host);
        return ret;
    }

    private static void validateIfS3Endpoint(String endpoint) {
        ParamsChecker.ensureNotNull(endpoint, "endpoint");
        String[] hostSplit = endpoint.split("\\.");
        if (hostSplit.length == 3 && hostSplit[0].startsWith("tos-s3")) {
            throw new TosClientException("invalid endpoint, please use TOS endpoint rather than S3 endpoint.", null);
        }
    }

    public static boolean isLocalhostOrIpAddress(String host) {
        if (StringUtils.isEmpty(host)) {
            return false;
        }
        try {
            boolean validAddress;
            URIBuilder url = new URIBuilder("https://" + host);
            if (url == null || StringUtils.isEmpty(url.getHost())) {
                return false;
            }
            InetAddress addr = InetAddress.getByName(url.getHost());
            boolean bl = validAddress = StringUtils.equals(addr.getHostAddress(), url.getHost()) || StringUtils.equals(url.getHost(), "localhost");
            if (validAddress) {
                return true;
            }
            if (addr instanceof Inet6Address) {
                return addr.getHostAddress().matches(IP_V6_PATTERN) && url.getHost().matches(IP_V6_PATTERN);
            }
            return false;
        }
        catch (URISyntaxException | UnknownHostException e) {
            return false;
        }
    }

    public static int parsePort(String host) {
        if (StringUtils.isEmpty(host)) {
            return 0;
        }
        int port = 0;
        int idx = host.indexOf(":");
        if (idx == -1) {
            return port;
        }
        String portStr = host.contains(".") ? host.substring(idx + 1) : (host.contains("]:") ? host.split("]:")[1] : host.substring(idx + 1));
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return port;
    }

    public static void isValidBucketName(String name) {
        if (StringUtils.isEmpty(name) || name.length() < 3 || name.length() > 63) {
            throw new TosClientException("invalid bucket name, the length must be [3, 63]", null);
        }
        if (name.startsWith(BUCKET_INVALID_PREFIX_SUFFIX) || name.endsWith(BUCKET_INVALID_PREFIX_SUFFIX)) {
            throw new TosClientException("invalid bucket name, the bucket name can be neither starting with '-' nor ending with '-'", null);
        }
        if (!name.matches(BUCKET_NAME_PATTERN)) {
            throw new TosClientException("invalid bucket name, the character set is illegal", null);
        }
    }

    public static void isValidKey(String key) {
        if (StringUtils.isEmpty(key)) {
            throw new TosClientException("invalid object name, the length must be larger than 0", null);
        }
        ParamsChecker.isDotOrDotDot(key);
    }

    private static void isDotOrDotDot(String objectKey) {
        for (String key : INVALID_OBJECT_KEY_LIST) {
            if (!key.equalsIgnoreCase(objectKey)) continue;
            throw new TosClientException("object key should not be . or ..", null);
        }
    }

    public static void isValidBucketNameAndKey(String bucket, String key) {
        ParamsChecker.isValidBucketName(bucket);
        ParamsChecker.isValidKey(key);
    }

    public static void ensureNotNull(Object object, String paramName) {
        if (object == null) {
            throw new TosClientException("empty " + paramName, null);
        }
    }

    public static void isValidPartNumber(int partNum) {
        if (partNum < 1 || partNum > 10000) {
            throw new TosClientException("part number should be between [1, 10000]", null);
        }
    }

    public static void isValidHttpMethod(String method) {
        ParamsChecker.ensureNotNull(method, "HttpMethod");
        if (StringUtils.equals(method, "GET") || StringUtils.equals(method, "PUT") || StringUtils.equals(method, "POST") || StringUtils.equals(method, "HEAD") || StringUtils.equals(method, "DELETE")) {
            return;
        }
        throw new TosClientException("method input is invalid", null);
    }
}

