/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util.dnscache;

import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.dnscache.DnsCache;
import com.volcengine.tos.internal.util.dnscache.DnsCacheService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Deprecated
public class DefaultDnsCacheService
implements DnsCacheService {
    private static final ExecutorService executor = new ThreadPoolExecutor(1, 3, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    private static final String VOLCES_HOST_SUFFIX = "volces.com";
    private static final String HOST_SPLIT_SEP = "\\.";
    private static final String HOST_CONCAT = ".";
    private static final int HOST_SPLIT_LENGTH = 4;
    private final Map<String, DnsCache> ipListMap;
    private final int timeoutMinutes;

    public DefaultDnsCacheService(int timeoutMinutes) {
        if (timeoutMinutes <= 0) {
            throw new IllegalArgumentException("dns timeout must be larger than 0");
        }
        this.ipListMap = new ConcurrentHashMap<String, DnsCache>();
        this.timeoutMinutes = timeoutMinutes;
    }

    protected static ExecutorService getInstance() {
        return executor;
    }

    @Override
    public List<InetAddress> getIpList(String host) {
        long pastTime;
        if (StringUtils.isEmpty(host)) {
            return null;
        }
        String wrappedHost = this.wrappedHost(host);
        if (this.ipListMap.containsKey(wrappedHost) && (double)(pastTime = System.nanoTime() - this.ipListMap.get(wrappedHost).getLastUpdateTimeNanos()) < (double)(this.timeoutMinutes * 60) * 1.0E9) {
            return this.getIpListFromCache(wrappedHost);
        }
        this.ipListMap.put(wrappedHost, new DnsCache(wrappedHost, this.timeoutMinutes));
        return this.getIpListFromCache(wrappedHost);
    }

    private List<InetAddress> getIpListFromCache(String wrappedHost) {
        List<InetAddress> res = this.ipListMap.get(wrappedHost).getIpList();
        if (res != null && res.size() == 0) {
            this.ipListMap.remove(wrappedHost);
            return null;
        }
        return res;
    }

    @Override
    public void removeAddress(String host, String ip) {
        List<InetAddress> removed;
        if (StringUtils.isEmpty(host) || StringUtils.isEmpty(ip)) {
            return;
        }
        String wrappedHost = this.wrappedHost(host);
        if (this.ipListMap.containsKey(wrappedHost) && (removed = this.ipListMap.get(wrappedHost).removeIp(ip)) != null && removed.size() == 0) {
            this.ipListMap.remove(wrappedHost);
        }
    }

    private String wrappedHost(String host) {
        if (StringUtils.isEmpty(host)) {
            return host;
        }
        if (!host.endsWith(VOLCES_HOST_SUFFIX)) {
            return host;
        }
        String[] hostSplit = host.split(HOST_SPLIT_SEP);
        if (hostSplit.length != 4) {
            return host;
        }
        ArrayList<String> hostWithoutFirstElement = new ArrayList<String>(hostSplit.length - 1);
        for (int i = 1; i < hostSplit.length; ++i) {
            hostWithoutFirstElement.add(hostSplit[i]);
        }
        return StringUtils.join(hostWithoutFirstElement, HOST_CONCAT);
    }
}

