/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.credential.Credentials;
import com.volcengine.tos.credential.CredentialsProvider;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CredentialsProviderWrapper
implements CredentialsProvider,
Closeable {
    private static final int CREDENTIALS_EXPIRES = 36000;
    private final CredentialsProvider inner;
    private final Lock lock;
    private final Thread refreshThread;
    private volatile CredentialsWrapper longCredentials;

    public CredentialsProviderWrapper(CredentialsProvider credentialsProvider) {
        if (credentialsProvider == null) {
            throw new TosClientException("CredentialsProvider cannot be null", null);
        }
        this.inner = credentialsProvider;
        this.lock = new ReentrantLock();
        int finalRefreshInterval = 600;
        this.refreshThread = new Thread(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        Thread.sleep(600000L);
                        CredentialsProviderWrapper.this.lock.lock();
                        try {
                            CredentialsProviderWrapper.this.refreshCredentials();
                        }
                        finally {
                            CredentialsProviderWrapper.this.lock.unlock();
                        }
                    }
                    catch (TosClientException e) {
                        TosUtils.getLogger().warn("try to refreshCredentials failed", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    @Override
    public Credentials getCredentials(int expires) {
        CredentialsWrapper cw = this.longCredentials;
        if (cw != null && cw.isValid()) {
            return cw.credentials;
        }
        this.lock.lock();
        try {
            cw = this.longCredentials;
            if (cw != null && cw.isValid()) {
                Credentials credentials = cw.credentials;
                return credentials;
            }
            this.refreshCredentials();
            Credentials credentials = this.longCredentials.credentials;
            return credentials;
        }
        catch (TosClientException e) {
            cw = this.longCredentials;
            if (cw != null && cw.isValid()) {
                Credentials credentials = cw.credentials;
                return credentials;
            }
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void refreshCredentials() {
        try {
            CredentialsWrapper cw = new CredentialsWrapper();
            int expires = 36000;
            cw.credentials = this.inner.getCredentials(expires);
            cw.expiredDate = Date.from(Instant.now().plusSeconds(expires - 600));
            this.longCredentials = cw;
        }
        catch (Exception e) {
            CredentialsWrapper cw = this.longCredentials;
            if (cw != null) {
                cw.immortal = true;
            }
            if (e instanceof TosClientException) {
                throw (TosClientException)e;
            }
            throw new TosClientException("get credentials failed", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
        }
    }

    private static class CredentialsWrapper {
        Credentials credentials;
        Date expiredDate;
        volatile boolean immortal;

        private CredentialsWrapper() {
        }

        boolean isValid() {
            return this.immortal || this.expiredDate.after(new Date());
        }
    }
}

