/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.comm.common.AzRedundancyType;
import com.volcengine.tos.comm.common.BucketType;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestHandler;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.SigningUtils;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TypeConverter;
import com.volcengine.tos.model.GenericInput;
import com.volcengine.tos.model.bucket.CreateBucketV2Input;
import com.volcengine.tos.model.bucket.CreateBucketV2Output;
import com.volcengine.tos.model.bucket.DeleteBucketCORSInput;
import com.volcengine.tos.model.bucket.DeleteBucketCORSOutput;
import com.volcengine.tos.model.bucket.DeleteBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.DeleteBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.DeleteBucketEncryptionInput;
import com.volcengine.tos.model.bucket.DeleteBucketEncryptionOutput;
import com.volcengine.tos.model.bucket.DeleteBucketInput;
import com.volcengine.tos.model.bucket.DeleteBucketInventoryInput;
import com.volcengine.tos.model.bucket.DeleteBucketInventoryOutput;
import com.volcengine.tos.model.bucket.DeleteBucketLifecycleInput;
import com.volcengine.tos.model.bucket.DeleteBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.DeleteBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.DeleteBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.DeleteBucketOutput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyInput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyOutput;
import com.volcengine.tos.model.bucket.DeleteBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.DeleteBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.DeleteBucketRenameInput;
import com.volcengine.tos.model.bucket.DeleteBucketRenameOutput;
import com.volcengine.tos.model.bucket.DeleteBucketReplicationInput;
import com.volcengine.tos.model.bucket.DeleteBucketReplicationOutput;
import com.volcengine.tos.model.bucket.DeleteBucketTaggingInput;
import com.volcengine.tos.model.bucket.DeleteBucketTaggingOutput;
import com.volcengine.tos.model.bucket.DeleteBucketWebsiteInput;
import com.volcengine.tos.model.bucket.DeleteBucketWebsiteOutput;
import com.volcengine.tos.model.bucket.DoesBucketExistInput;
import com.volcengine.tos.model.bucket.GetBucketACLInput;
import com.volcengine.tos.model.bucket.GetBucketACLOutput;
import com.volcengine.tos.model.bucket.GetBucketAccessMonitorInput;
import com.volcengine.tos.model.bucket.GetBucketAccessMonitorOutput;
import com.volcengine.tos.model.bucket.GetBucketCORSInput;
import com.volcengine.tos.model.bucket.GetBucketCORSOutput;
import com.volcengine.tos.model.bucket.GetBucketEncryptionInput;
import com.volcengine.tos.model.bucket.GetBucketEncryptionOutput;
import com.volcengine.tos.model.bucket.GetBucketInfoInput;
import com.volcengine.tos.model.bucket.GetBucketInfoOutput;
import com.volcengine.tos.model.bucket.GetBucketInventoryInput;
import com.volcengine.tos.model.bucket.GetBucketInventoryOutput;
import com.volcengine.tos.model.bucket.GetBucketLifecycleInput;
import com.volcengine.tos.model.bucket.GetBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.GetBucketLocationInput;
import com.volcengine.tos.model.bucket.GetBucketLocationOutput;
import com.volcengine.tos.model.bucket.GetBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.GetBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.GetBucketNotificationInput;
import com.volcengine.tos.model.bucket.GetBucketNotificationOutput;
import com.volcengine.tos.model.bucket.GetBucketNotificationType2Input;
import com.volcengine.tos.model.bucket.GetBucketNotificationType2Output;
import com.volcengine.tos.model.bucket.GetBucketPolicyInput;
import com.volcengine.tos.model.bucket.GetBucketPolicyOutput;
import com.volcengine.tos.model.bucket.GetBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.GetBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.GetBucketRenameInput;
import com.volcengine.tos.model.bucket.GetBucketRenameOutput;
import com.volcengine.tos.model.bucket.GetBucketReplicationInput;
import com.volcengine.tos.model.bucket.GetBucketReplicationOutput;
import com.volcengine.tos.model.bucket.GetBucketTaggingInput;
import com.volcengine.tos.model.bucket.GetBucketTaggingOutput;
import com.volcengine.tos.model.bucket.GetBucketVersioningInput;
import com.volcengine.tos.model.bucket.GetBucketVersioningOutput;
import com.volcengine.tos.model.bucket.GetBucketWebsiteInput;
import com.volcengine.tos.model.bucket.GetBucketWebsiteOutput;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.bucket.ListBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.ListBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.ListBucketInventoryInput;
import com.volcengine.tos.model.bucket.ListBucketInventoryOutput;
import com.volcengine.tos.model.bucket.ListBucketsV2Input;
import com.volcengine.tos.model.bucket.ListBucketsV2Output;
import com.volcengine.tos.model.bucket.PutBucketACLInput;
import com.volcengine.tos.model.bucket.PutBucketACLOutput;
import com.volcengine.tos.model.bucket.PutBucketAccessMonitorInput;
import com.volcengine.tos.model.bucket.PutBucketAccessMonitorOutput;
import com.volcengine.tos.model.bucket.PutBucketCORSInput;
import com.volcengine.tos.model.bucket.PutBucketCORSOutput;
import com.volcengine.tos.model.bucket.PutBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.PutBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.PutBucketEncryptionInput;
import com.volcengine.tos.model.bucket.PutBucketEncryptionOutput;
import com.volcengine.tos.model.bucket.PutBucketInventoryInput;
import com.volcengine.tos.model.bucket.PutBucketInventoryOutput;
import com.volcengine.tos.model.bucket.PutBucketLifecycleInput;
import com.volcengine.tos.model.bucket.PutBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.PutBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.PutBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.PutBucketNotificationInput;
import com.volcengine.tos.model.bucket.PutBucketNotificationOutput;
import com.volcengine.tos.model.bucket.PutBucketNotificationType2Input;
import com.volcengine.tos.model.bucket.PutBucketNotificationType2Output;
import com.volcengine.tos.model.bucket.PutBucketPolicyInput;
import com.volcengine.tos.model.bucket.PutBucketPolicyOutput;
import com.volcengine.tos.model.bucket.PutBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.PutBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.PutBucketRenameInput;
import com.volcengine.tos.model.bucket.PutBucketRenameOutput;
import com.volcengine.tos.model.bucket.PutBucketReplicationInput;
import com.volcengine.tos.model.bucket.PutBucketReplicationOutput;
import com.volcengine.tos.model.bucket.PutBucketStorageClassInput;
import com.volcengine.tos.model.bucket.PutBucketStorageClassOutput;
import com.volcengine.tos.model.bucket.PutBucketTaggingInput;
import com.volcengine.tos.model.bucket.PutBucketTaggingOutput;
import com.volcengine.tos.model.bucket.PutBucketVersioningInput;
import com.volcengine.tos.model.bucket.PutBucketVersioningOutput;
import com.volcengine.tos.model.bucket.PutBucketWebsiteInput;
import com.volcengine.tos.model.bucket.PutBucketWebsiteOutput;
import com.volcengine.tos.model.object.DeleteQosPolicyInput;
import com.volcengine.tos.model.object.DeleteQosPolicyOutput;
import com.volcengine.tos.model.object.GetQosPolicyInput;
import com.volcengine.tos.model.object.GetQosPolicyOutput;
import com.volcengine.tos.model.object.PutQosPolicyInput;
import com.volcengine.tos.model.object.PutQosPolicyOutput;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;

public class TosBucketRequestHandler {
    private RequestHandler bucketHandler;
    private TosRequestFactory factory;

    public TosBucketRequestHandler(Transport transport, TosRequestFactory factory) {
        this.bucketHandler = new RequestHandler(transport);
        this.factory = factory;
    }

    private RequestBuilder handleGenericInput(RequestBuilder builder, GenericInput input) {
        if (StringUtils.isNotEmpty(input.getRequestHost())) {
            builder = builder.withHeader("Host", input.getRequestHost());
        }
        if (input.getRequestDate() != null) {
            builder = builder.withHeader("X-Tos-Date", SigningUtils.iso8601Layout.format(input.getRequestDate().toInstant().atOffset(ZoneOffset.UTC)));
        }
        if (input.getRequestHeaders() != null && !input.getRequestHeaders().isEmpty()) {
            Map<String, String> headers = builder.getHeaders();
            for (Map.Entry<String, String> entry : input.getRequestHeaders().entrySet()) {
                if (TosBucketRequestHandler.containsKeyIgnoreCase(headers, entry.getKey())) continue;
                builder = builder.withHeader(entry.getKey(), entry.getValue());
            }
        }
        if (input.getRequestQuery() != null && !input.getRequestQuery().isEmpty()) {
            for (Map.Entry<String, String> entry : input.getRequestQuery().entrySet()) {
                builder = builder.withQuery(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    public static boolean containsKeyIgnoreCase(Map<String, String> map, String key) {
        for (String existingKey : map.keySet()) {
            if (!existingKey.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public CreateBucketV2Output createBucket(CreateBucketV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CreateBucketV2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", input.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp()).withHeader("X-Tos-Storage-Class", input.getStorageClass() == null ? null : input.getStorageClass().toString()).withHeader("X-Tos-Az-Redundancy", input.getAzRedundancy() == null ? null : input.getAzRedundancy().toString()).withHeader("x-tos-project-name", input.getProjectName()).withHeader("x-tos-tagging", input.getTagging()).withHeader("x-tos-bucket-type", input.getBucketType() == null ? null : input.getBucketType().toString());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", null).setRetryableOnClientException(false);
        return this.bucketHandler.doRequest(req, 200, res -> new CreateBucketV2Output(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("Location")));
    }

    public HeadBucketV2Output headBucket(HeadBucketV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "HeadBucketInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null);
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "HEAD", null);
        return this.bucketHandler.doRequest(req, 200, res -> new HeadBucketV2Output(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("X-Tos-Bucket-Region"), TypeConverter.convertStorageClassType(res.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class"))).setProjectName(res.getHeaderWithKeyIgnoreCase("x-tos-project-name")).setBucketType(BucketType.parse(res.getHeaderWithKeyIgnoreCase("x-tos-bucket-type"))).setAzRedundancy(AzRedundancyType.parse(res.getHeaderWithKeyIgnoreCase("X-Tos-Az-Redundancy"))));
    }

    public DeleteBucketOutput deleteBucket(DeleteBucketInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null);
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null).setRetryableOnClientException(false);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketOutput(res.RequestInfo()));
    }

    public ListBucketsV2Output listBuckets(ListBucketsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListBucketsV2Input");
        RequestBuilder builder = this.factory.init("", "", null).withHeader("x-tos-project-name", input.getProjectName()).withHeader("x-tos-bucket-type", input.getBucketType() == null ? null : input.getBucketType().toString());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<ListBucketsV2Output>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketPolicyOutput putBucketPolicy(PutBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketPolicyInput");
        ParamsChecker.ensureNotNull(input.getPolicy(), "policy");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        builder = this.handleGenericInput(builder, input);
        byte[] policyStr = input.getPolicy().getBytes(StandardCharsets.UTF_8);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(policyStr)).setContentLength(policyStr.length);
        return this.bucketHandler.doRequest(req, 204, res -> new PutBucketPolicyOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketPolicyOutput getBucketPolicy(GetBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketPolicyInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> new GetBucketPolicyOutput().setRequestInfo(res.RequestInfo()).setPolicy(StringUtils.toString(res.getInputStream(), "bucket policy")));
    }

    public DeleteBucketPolicyOutput deleteBucketPolicy(DeleteBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketPolicyInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketPolicyOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketCORSOutput putBucketCORS(PutBucketCORSInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketCORSInput");
        ParamsChecker.ensureNotNull(input.getRules(), "CORSRules");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("cors", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketCORSOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketCORSOutput getBucketCORS(GetBucketCORSInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketCORSInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("cors", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketCORSOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketCORSOutput deleteBucketCORS(DeleteBucketCORSInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketCORSInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("cors", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketCORSOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketStorageClassOutput putBucketStorageClass(PutBucketStorageClassInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketStorageClassInput");
        ParamsChecker.ensureNotNull((Object)input.getStorageClass(), "StorageClass");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("storageClass", "").withHeader("X-Tos-Storage-Class", input.getStorageClass().toString());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", null);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketStorageClassOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketLocationOutput getBucketLocation(GetBucketLocationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketLocationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("location", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketLocationOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketLifecycleOutput putBucketLifecycle(PutBucketLifecycleInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketLifecycleInput");
        ParamsChecker.ensureNotNull(input.getRules(), "LifecycleRules");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("lifecycle", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        if (input.isAllowSameActionOverlap()) {
            builder = builder.withHeader("x-tos-allow-same-action-overlap", "true");
        }
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketLifecycleOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketLifecycleOutput getBucketLifecycle(GetBucketLifecycleInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketLifecycleInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("lifecycle", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketLifecycleOutput>(){}).setRequestInfo(res.RequestInfo()).setAllowSameActionOverlap(Boolean.valueOf(res.getHeaderWithKeyIgnoreCase("x-tos-allow-same-action-overlap"))));
    }

    public DeleteBucketLifecycleOutput deleteBucketLifecycle(DeleteBucketLifecycleInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketLifecycleInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("lifecycle", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketLifecycleOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketMirrorBackOutput putBucketMirrorBack(PutBucketMirrorBackInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketMirrorBackInput");
        ParamsChecker.ensureNotNull(input.getRules(), "MirrorBackRules");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("mirror", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketMirrorBackOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketMirrorBackOutput getBucketMirrorBack(GetBucketMirrorBackInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketMirrorBackInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("mirror", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketMirrorBackOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketMirrorBackOutput deleteBucketMirrorBack(DeleteBucketMirrorBackInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketMirrorBackInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("mirror", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketMirrorBackOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketReplicationOutput putBucketReplication(PutBucketReplicationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketReplicationInput");
        ParamsChecker.ensureNotNull(input.getRole(), "ReplicationRole");
        ParamsChecker.ensureNotNull(input.getRules(), "ReplicationRule");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("replication", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketReplicationOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketReplicationOutput getBucketReplication(GetBucketReplicationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketReplicationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("replication", "").withQuery("progress", "").withQuery("rule-id", input.getRuleID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketReplicationOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketReplicationOutput deleteBucketReplication(DeleteBucketReplicationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketReplicationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("replication", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketReplicationOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketVersioningOutput putBucketVersioning(PutBucketVersioningInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketVersioningInput");
        ParamsChecker.ensureNotNull((Object)input.getStatus(), "VersioningStatusType");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("versioning", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketVersioningOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketVersioningOutput getBucketVersioning(GetBucketVersioningInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketVersioningInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("versioning", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketVersioningOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketWebsiteOutput putBucketWebsite(PutBucketWebsiteInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketWebsiteInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("website", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketWebsiteOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketWebsiteOutput getBucketWebsite(GetBucketWebsiteInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketWebsiteInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("website", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketWebsiteOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketWebsiteOutput deleteBucketWebsite(DeleteBucketWebsiteInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketWebsiteInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("website", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketWebsiteOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketNotificationOutput putBucketNotification(PutBucketNotificationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketNotificationInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("notification", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketNotificationOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketNotificationOutput getBucketNotification(GetBucketNotificationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketNotificationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("notification", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketNotificationOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketNotificationType2Output putBucketNotificationType2(PutBucketNotificationType2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketNotificationType2Output");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("notification_v2", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketNotificationType2Output().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketNotificationType2Output getBucketNotificationType2(GetBucketNotificationType2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketNotificationType2Output");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("notification_v2", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketNotificationType2Output>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketCustomDomainOutput putBucketCustomDomain(PutBucketCustomDomainInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketCustomDomainInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("customdomain", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketCustomDomainOutput().setRequestInfo(res.RequestInfo()));
    }

    public ListBucketCustomDomainOutput listBucketCustomDomain(ListBucketCustomDomainInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListBucketCustomDomainInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("customdomain", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<ListBucketCustomDomainOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketCustomDomainOutput deleteBucketCustomDomain(DeleteBucketCustomDomainInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketCustomDomainInput");
        ParamsChecker.ensureNotNull(input.getDomain(), "Domain");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("customdomain", input.getDomain());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 200, res -> new DeleteBucketCustomDomainOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketRealTimeLogOutput putBucketRealTimeLog(PutBucketRealTimeLogInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketRealTimeLogInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("realtimeLog", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketRealTimeLogOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketRealTimeLogOutput getBucketRealTimeLog(GetBucketRealTimeLogInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketRealTimeLogInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("realtimeLog", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketRealTimeLogOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketRealTimeLogOutput deleteBucketRealTimeLog(DeleteBucketRealTimeLogInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketRealTimeLogInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("realtimeLog", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketRealTimeLogOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketACLOutput putBucketACL(PutBucketACLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketACLInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("acl", "").withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", input.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp());
        byte[] data = new byte[]{};
        if (input.getOwner() != null && StringUtils.isNotEmpty(input.getOwner().getId()) && input.getGrants() != null && input.getGrants().size() > 0) {
            TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
            data = marshalResult.getData();
            builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        }
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(data)).setContentLength(data.length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketACLOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketACLOutput getBucketACL(GetBucketACLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketACLInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("acl", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketACLOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketRenameOutput putBucketRename(PutBucketRenameInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketRenameInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("rename", "");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketRenameOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketRenameOutput getBucketRename(GetBucketRenameInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketRenameInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("rename", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketRenameOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketRenameOutput deleteBucketRename(DeleteBucketRenameInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketRenameInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("rename", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketRenameOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketEncryptionOutput putBucketEncryption(PutBucketEncryptionInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketEncryptionInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("encryption", "");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketEncryptionOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketEncryptionOutput getBucketEncryption(GetBucketEncryptionInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketEncryptionInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("encryption", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketEncryptionOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketEncryptionOutput deleteBucketEncryption(DeleteBucketEncryptionInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketEncryptionInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("encryption", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketEncryptionOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketTaggingOutput putBucketTagging(PutBucketTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("tagging", "");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketTaggingOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketTaggingOutput getBucketTagging(GetBucketTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("tagging", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketTaggingOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketTaggingOutput deleteBucketTagging(DeleteBucketTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("tagging", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketTaggingOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketInventoryOutput putBucketInventory(PutBucketInventoryInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketInventoryInput");
        this.ensureValidBucketName(input.getBucket());
        if (StringUtils.isEmpty(input.getId())) {
            throw new TosClientException("tos: inventory id is empty", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("inventory", "").withQuery("id", input.getId());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketInventoryOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketInventoryOutput getBucketInventory(GetBucketInventoryInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketInventoryInput");
        this.ensureValidBucketName(input.getBucket());
        if (StringUtils.isEmpty(input.getId())) {
            throw new TosClientException("tos: inventory id is empty", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("inventory", "").withQuery("id", input.getId());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketInventoryOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public ListBucketInventoryOutput listBucketInventory(ListBucketInventoryInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketInventoryInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("inventory", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<ListBucketInventoryOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketInventoryOutput deleteBucketInventory(DeleteBucketInventoryInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketInventoryInput");
        this.ensureValidBucketName(input.getBucket());
        if (StringUtils.isEmpty(input.getId())) {
            throw new TosClientException("tos: inventory id is empty", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("inventory", "").withQuery("id", input.getId());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketInventoryOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketInfoOutput getBucketInfo(GetBucketInfoInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketInfoInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("bucketInfo", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketInfoOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public boolean doesBucketExist(DoesBucketExistInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DoesBucketExistInput");
        this.ensureValidBucketName(input.getBucket());
        HeadBucketV2Input headBucketV2Input = new HeadBucketV2Input();
        headBucketV2Input.setBucket(input.getBucket());
        HeadBucketV2Output headBucketV2Output = null;
        try {
            headBucketV2Output = this.headBucket(headBucketV2Input);
            if (headBucketV2Output.getRequestInfo().getStatusCode() == 200) {
                return true;
            }
        }
        catch (TosServerException e) {
            if (Objects.equals(e.getEc(), "0006-00000001")) {
                return false;
            }
            throw e;
        }
        return false;
    }

    public PutBucketAccessMonitorOutput putBucketAccessMonitor(PutBucketAccessMonitorInput input) {
        ParamsChecker.ensureNotNull(input, "PutBucketAccessMonitorInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("accessmonitor", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketAccessMonitorOutput(res.RequestInfo()));
    }

    public GetBucketAccessMonitorOutput getBucketAccessMonitor(GetBucketAccessMonitorInput input) {
        ParamsChecker.ensureNotNull(input, "GetBucketAccessMonitorInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("accessmonitor", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketAccessMonitorOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public TosRequestFactory getFactory() {
        return this.factory;
    }

    public TosBucketRequestHandler setFactory(TosRequestFactory factory) {
        this.factory = factory;
        return this;
    }

    public TosBucketRequestHandler setTransport(Transport transport) {
        if (this.bucketHandler == null) {
            this.bucketHandler = new RequestHandler(transport);
        } else {
            this.bucketHandler.setTransport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        if (this.bucketHandler != null) {
            return this.bucketHandler.getTransport();
        }
        return null;
    }

    private void ensureValidBucketName(String bucket) {
        if (this.factory.isCustomDomain()) {
            return;
        }
        ParamsChecker.isValidBucketName(bucket);
    }

    public PutQosPolicyOutput putQosPolicy(PutQosPolicyInput input) {
        ParamsChecker.ensureNotNull(input, "PutQosPolicyInput");
        ParamsChecker.ensureNotNull(input.getPolicy(), "policy");
        RequestBuilder builder = this.factory.initControlReq(input.getAccountId(), "qospolicy", null);
        builder = this.handleGenericInput(builder, input);
        byte[] policyStr = input.getPolicy().getBytes(StandardCharsets.UTF_8);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(policyStr)).setContentLength(policyStr.length);
        return this.bucketHandler.doRequest(req, 204, res -> new PutQosPolicyOutput(res.RequestInfo()));
    }

    public DeleteQosPolicyOutput deleteQosPolicy(DeleteQosPolicyInput input) {
        ParamsChecker.ensureNotNull(input, "DeleteQosPolicyInput");
        RequestBuilder builder = this.factory.initControlReq(input.getAccountId(), "qospolicy", null);
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteQosPolicyOutput(res.RequestInfo()));
    }

    public GetQosPolicyOutput getQosPolicy(GetQosPolicyInput input) {
        ParamsChecker.ensureNotNull(input, "GetQosPolicyInput");
        RequestBuilder builder = this.factory.initControlReq(input.getAccountId(), "qospolicy", null);
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> new GetQosPolicyOutput().setRequestInfo(res.RequestInfo()).setPolicy(StringUtils.toString(res.getInputStream(), "qos policy")));
    }
}

