/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    private static final int SLOT_SIZE;
    private static final Random RANDOM;
    private static final Map<Integer, Slot> SLOT_MAP;
    private long timeoutAt;
    private final AtomicBoolean inQueue = new AtomicBoolean(false);
    private final AtomicReference<AsyncTimeout> next;
    private final int id = RANDOM.nextInt(SLOT_SIZE);
    private final Slot slot;

    public AsyncTimeout() {
        this(null);
    }

    public AsyncTimeout(Slot slot) {
        this.next = new AtomicReference();
        this.slot = slot == null ? SLOT_MAP.get(this.id) : slot;
    }

    public void enter() {
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        this.scheduleTimeout(timeoutNanos, hasDeadline);
    }

    public boolean exit() {
        return this.cancelScheduledTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimeout(long timeoutNanos, boolean hasDeadline) {
        if (!this.inQueue.compareAndSet(false, true)) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long now = System.nanoTime();
        if (timeoutNanos != 0L && hasDeadline) {
            this.timeoutAt = now + Math.min(timeoutNanos, this.deadlineNanoTime() - now);
        } else if (timeoutNanos != 0L) {
            this.timeoutAt = now + timeoutNanos;
        } else if (hasDeadline) {
            this.timeoutAt = this.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        AsyncTimeout head = this.slot.getHead();
        this.slot.acquireReadLock();
        this.slot.startWatch();
        boolean released = false;
        block7: while (true) {
            long remainingNanos = this.remainingNanos(now);
            AsyncTimeout prev = head;
            while (true) {
                AsyncTimeout next;
                if ((next = prev.next.get()) == null || remainingNanos < next.remainingNanos(now)) {
                    this.next.set(next);
                    if (!prev.next.compareAndSet(next, this)) {
                        now = System.nanoTime();
                        this.next.set(null);
                        continue block7;
                    }
                    if (prev == head) {
                        this.slot.releaseReadLock();
                        released = true;
                        this.slot.acquireWriteLock();
                        try {
                            this.slot.wakeUp();
                        }
                        finally {
                            this.slot.releaseWriteLock();
                        }
                    }
                    return;
                }
                prev = next;
            }
            break;
        }
        finally {
            if (!released) {
                this.slot.releaseReadLock();
            }
        }
    }

    private boolean cancelScheduledTimeout() {
        if (!this.inQueue.compareAndSet(true, false)) {
            return false;
        }
        AsyncTimeout head = this.slot.getHead();
        this.slot.acquireWriteLock();
        try {
            AsyncTimeout prev = head;
            while (true) {
                if (prev == null) {
                    boolean bl = true;
                    return bl;
                }
                AsyncTimeout next = prev.next.get();
                if (next == this) {
                    prev.next.set(next.next.get());
                    next.next.set(null);
                    boolean bl = false;
                    return bl;
                }
                prev = next;
            }
        }
        finally {
            this.slot.releaseWriteLock();
        }
    }

    private long remainingNanos(long now) {
        return this.timeoutAt - now;
    }

    protected void timeOut() {
    }

    public Sink sink(final Sink sink) {
        return new Sink(){

            public void write(Buffer source, long byteCount) throws IOException {
                long toWrite;
                AsyncTimeout.this.checkOffsetAndCount(source.size(), 0L, byteCount);
                for (long remaining = byteCount; remaining > 0L; remaining -= toWrite) {
                    toWrite = 0L;
                    Segment s = source.head;
                    while (toWrite < 65536L) {
                        int segmentSize = s.limit - s.pos;
                        if ((toWrite += (long)segmentSize) >= remaining) {
                            toWrite = remaining;
                            break;
                        }
                        s = s.next;
                    }
                    long finalToWrite = toWrite;
                    AsyncTimeout.this.withTimeout(() -> {
                        sink.write(source, finalToWrite);
                        return null;
                    });
                }
            }

            public void flush() throws IOException {
                AsyncTimeout.this.withTimeout(() -> {
                    sink.flush();
                    return null;
                });
            }

            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public void close() throws IOException {
                AsyncTimeout.this.withTimeout(() -> {
                    sink.close();
                    return null;
                });
            }

            public String toString() {
                return "AsyncTimeout.sink(" + sink + ")";
            }
        };
    }

    public Source source(final Source source) {
        return new Source(){

            public long read(Buffer sink, long byteCount) throws IOException {
                return (Long)AsyncTimeout.this.withTimeout(() -> source.read(sink, byteCount));
            }

            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public void close() throws IOException {
                AsyncTimeout.this.withTimeout(() -> {
                    source.close();
                    return null;
                });
            }

            public String toString() {
                return "AsyncTimeout.source(" + source + ")";
            }
        };
    }

    private <T> T withTimeout(Block<T> block) throws IOException {
        boolean throwOnTimeout = false;
        this.enter();
        try {
            T result = block.execute();
            throwOnTimeout = true;
            T t = result;
            return t;
        }
        catch (IOException e) {
            if (!this.exit()) {
                throw e;
            }
            throw this.newTimeoutException(e);
        }
        finally {
            boolean timedOut = this.exit();
            if (timedOut && throwOnTimeout) {
                throw this.newTimeoutException(null);
            }
        }
    }

    private IOException newTimeoutException(IOException cause) {
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    private void checkOffsetAndCount(long size, long offset, long byteCount) {
        if (offset < 0L || byteCount < 0L || offset > size || size - offset < byteCount) {
            throw new ArrayIndexOutOfBoundsException("size=$size offset=$offset byteCount=$byteCount");
        }
    }

    static {
        RANDOM = new Random(System.currentTimeMillis());
        int tempSlotSize = Runtime.getRuntime().availableProcessors();
        if (tempSlotSize < 16) {
            tempSlotSize = 16;
        }
        SLOT_SIZE = tempSlotSize;
        SLOT_MAP = new HashMap<Integer, Slot>(SLOT_SIZE);
        for (int i = 0; i < SLOT_SIZE; ++i) {
            SLOT_MAP.put(i, new Slot());
        }
    }

    private static class Watchdog
    implements Runnable {
        private final Slot slot;

        private Watchdog(Slot slot) {
            this.slot = slot;
        }

        @Override
        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        AsyncTimeout timedOut;
                        if ((timedOut = this.slot.awaitTimeout()) == this.slot.getHead()) {
                            this.slot.acquireWriteLock();
                            try {
                                if (this.slot.getHead().next.get() != null || !this.slot.watchStarted.compareAndSet(true, false)) continue;
                                break block5;
                            }
                            finally {
                                this.slot.releaseWriteLock();
                                continue;
                            }
                        }
                        if (timedOut == null) continue;
                        timedOut.timeOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    static class Slot {
        private final AtomicBoolean watchStarted = new AtomicBoolean(false);
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Condition cond = this.rwLock.writeLock().newCondition();
        private final AsyncTimeout head = new AsyncTimeout(this);
        private final boolean startWatchThread;

        Slot() {
            this(true);
        }

        Slot(boolean startWatchThread) {
            this.startWatchThread = startWatchThread;
        }

        private AsyncTimeout getHead() {
            return this.head;
        }

        private void acquireWriteLock() {
            this.rwLock.writeLock().lock();
        }

        private void releaseWriteLock() {
            this.rwLock.writeLock().unlock();
        }

        private void acquireReadLock() {
            this.rwLock.readLock().lock();
        }

        private void releaseReadLock() {
            this.rwLock.readLock().unlock();
        }

        private void await(long time, TimeUnit unit) throws InterruptedException {
            this.cond.await(time, unit);
        }

        private void wakeUp() {
            this.cond.signal();
        }

        private void startWatch() {
            if (!this.startWatchThread) {
                return;
            }
            if (this.watchStarted.compareAndSet(false, true)) {
                Thread t = new Thread((Runnable)new Watchdog(this), "Watchdog");
                t.setDaemon(true);
                t.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AsyncTimeout awaitTimeout() throws InterruptedException {
            AsyncTimeout head = this.getHead();
            this.acquireWriteLock();
            try {
                AsyncTimeout node = (AsyncTimeout)((Object)head.next.get());
                if (node == null) {
                    long startNanos = System.nanoTime();
                    this.await(IDLE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                    if (head.next.get() == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS) {
                        AsyncTimeout asyncTimeout = head;
                        return asyncTimeout;
                    }
                    AsyncTimeout asyncTimeout = null;
                    return asyncTimeout;
                }
                long waitNanos = node.remainingNanos(System.nanoTime());
                if (waitNanos > 0L) {
                    this.await(waitNanos, TimeUnit.NANOSECONDS);
                    AsyncTimeout asyncTimeout = null;
                    return asyncTimeout;
                }
                head.next.set(node.next.get());
                node.next.set(null);
                AsyncTimeout asyncTimeout = node;
                return asyncTimeout;
            }
            finally {
                this.releaseWriteLock();
            }
        }

        int checkAndPrintSlot() {
            AsyncTimeout head = this.getHead();
            AsyncTimeout last = null;
            int count = 0;
            while (head.next.get() != null) {
                long timeoutAt = ((AsyncTimeout)((Object)head.next.get())).timeoutAt;
                if (last != null && ((AsyncTimeout)((Object)last.next.get())).timeoutAt > timeoutAt) {
                    throw new RuntimeException("found invalid order");
                }
                last = head;
                head = (AsyncTimeout)((Object)head.next.get());
                ++count;
            }
            return count;
        }
    }

    private static interface Block<T> {
        public T execute() throws IOException;
    }
}

