/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.model.HttpRange;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class RequestBuilder {
    private Signer signer;
    private String scheme;
    private String host;
    private int port;
    private String bucket;
    private String object;
    private String controlApiPath;
    private int urlMode = 0;
    private long contentLength = -1L;
    private HttpRange range;
    private Map<String, String> headers = new HashMap<String, String>(1);
    private Map<String, String> query;
    private boolean autoRecognizeContentType = true;
    private String preHashCrc64ecma;
    private boolean disableEncodingMeta;
    private boolean skipTryResolveContentLength;

    public RequestBuilder() {
    }

    @Deprecated
    public RequestBuilder(Signer signer, String scheme, String host, String bucket, String object, int urlMode, Map<String, String> headers, Map<String, String> query) {
        Objects.requireNonNull(bucket, "bucket is null");
        Objects.requireNonNull(object, "object is null");
        this.signer = signer;
        this.scheme = scheme;
        this.host = host;
        this.bucket = bucket;
        this.object = object;
        this.urlMode = urlMode;
        this.headers = headers;
        this.query = query;
    }

    public RequestBuilder(String bucket, String object, String scheme, String host, Signer signer) {
        Objects.requireNonNull(scheme, "scheme is null");
        Objects.requireNonNull(host, "host is null");
        this.bucket = bucket;
        this.object = object;
        this.scheme = scheme;
        this.host = host;
        this.signer = signer;
    }

    public RequestBuilder(String controlApiPath, String scheme, String host, Signer signer) {
        Objects.requireNonNull(scheme, "scheme is null");
        Objects.requireNonNull(host, "host is null");
        this.scheme = scheme;
        this.host = host;
        this.signer = signer;
        this.controlApiPath = controlApiPath;
    }

    public RequestBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public RequestBuilder setControlApiPath(String controlApiPath) {
        this.controlApiPath = controlApiPath;
        return this;
    }

    public String getControlApiPath() {
        return this.controlApiPath;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public RequestBuilder setQuery(Map<String, String> query) {
        this.query = query;
        return this;
    }

    public HttpRange getRange() {
        return this.range;
    }

    void setRange(HttpRange range) {
        this.range = range;
    }

    public RequestBuilder withQuery(String key, String value) {
        if (StringUtils.isEmpty(key) || value == null) {
            return this;
        }
        if (this.query == null) {
            this.query = new HashMap<String, String>(1);
        }
        this.query.put(key, value);
        return this;
    }

    public RequestBuilder withHeader(String key, String value) {
        if (value != null && value.length() != 0) {
            this.headers.put(key, value);
        }
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isAutoRecognizeContentType() {
        return this.autoRecognizeContentType;
    }

    public void setAutoRecognizeContentType(boolean autoRecognizeContentType) {
        this.autoRecognizeContentType = autoRecognizeContentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public RequestBuilder withContentLength(long length) {
        this.contentLength = length;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RequestBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public int getUrlMode() {
        return this.urlMode;
    }

    public RequestBuilder setUrlMode(int urlMode) {
        this.urlMode = urlMode;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RequestBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public String getPreHashCrc64ecma() {
        return this.preHashCrc64ecma;
    }

    public RequestBuilder setPreHashCrc64ecma(String preHashCrc64ecma) {
        this.preHashCrc64ecma = preHashCrc64ecma;
        return this;
    }

    public RequestBuilder setDisableEncodingMeta(boolean disableEncodingMeta) {
        this.disableEncodingMeta = disableEncodingMeta;
        return this;
    }

    public RequestBuilder setSkipTryResolveContentLength(boolean skipTryResolveContentLength) {
        this.skipTryResolveContentLength = skipTryResolveContentLength;
        return this;
    }

    private TosRequest build(String method, InputStream stream) throws IOException {
        TosRequest request = this.genTosRequest(method, stream);
        if (this.skipTryResolveContentLength) {
            request.setContentLength(this.contentLength);
        } else if (request.getContent() != null) {
            this.tryResolveContentLength(request);
        }
        Map<String, String> headers = request.getHeaders();
        if (headers != null && headers.size() > 0) {
            this.tryEncodeHeaders(headers);
        }
        return request;
    }

    private void tryResolveContentLength(TosRequest request) {
        if (this.contentLength >= 0L) {
            request.setContentLength(this.contentLength);
        } else if (StringUtils.isNotEmpty(this.headers.get("Content-Length"))) {
            try {
                long cl = Long.parseLong(this.headers.get("Content-Length"));
                request.setContentLength(cl >= 0L ? cl : -1L);
            }
            catch (NumberFormatException e) {
                TosUtils.getLogger().debug("tos: try to get content length from header failed, ", (Throwable)e);
                request.setContentLength(-1L);
            }
        } else {
            request.setContentLength(-1L);
        }
        if (request.getContent() instanceof FileInputStream && request.getContentLength() <= 0L) {
            try {
                FileChannel channel = ((FileInputStream)request.getContent()).getChannel();
                request.setContentLength(channel.size());
            }
            catch (IOException e) {
                TosUtils.getLogger().debug("tos: try to get content length from file failed, ", (Throwable)e);
                request.setContentLength(-1L);
            }
        }
    }

    private void tryEncodeHeaders(Map<String, String> headers) {
        HashMap<String, String> encodedHeaders = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isNotEmpty(key) && key.startsWith("X-Tos-Meta-")) {
                if (this.disableEncodingMeta) {
                    encodedHeaders.put(key, value);
                } else {
                    encodedHeaders.put(TosUtils.encodeHeader(key), TosUtils.encodeHeader(value));
                }
                iterator.remove();
                continue;
            }
            if (!StringUtils.equals(key, "Content-Disposition")) continue;
            if (this.disableEncodingMeta) {
                encodedHeaders.put(key, value);
            } else {
                encodedHeaders.put(key, TosUtils.encodeChinese(value));
            }
            iterator.remove();
        }
        headers.putAll(encodedHeaders);
    }

    private TosRequest genTosRequest(String method, InputStream stream) {
        String[] hostAndPath = this.hostPath();
        TosRequest request = new TosRequest(this.scheme, method, hostAndPath[0], hostAndPath[1], stream, this.query, this.headers);
        if (this.port != 0) {
            request.setPort(this.port);
        }
        return request;
    }

    private String[] hostPath() {
        String[] hostAndPath = new String[]{"", ""};
        if (this.urlMode == 2) {
            hostAndPath[0] = this.host;
            hostAndPath[1] = "/" + this.object;
        } else if (this.urlMode == 1) {
            hostAndPath[0] = this.host;
            hostAndPath[1] = "/" + this.bucket + "/" + this.object;
        } else if (this.urlMode == 3) {
            hostAndPath[0] = this.host;
            hostAndPath[1] = "/" + this.controlApiPath;
        } else if (StringUtils.isEmpty(this.bucket)) {
            hostAndPath[0] = this.host;
            hostAndPath[1] = "/";
        } else {
            hostAndPath[0] = this.bucket + "." + this.host;
            hostAndPath[1] = "/" + this.object;
        }
        return hostAndPath;
    }

    public TosRequest buildRequest(String method, InputStream stream) throws TosClientException {
        TosRequest request;
        try {
            request = this.build(method, stream);
        }
        catch (IOException e) {
            throw new TosClientException("build tos request failed", e);
        }
        if (this.signer != null) {
            Map<String, String> signed = this.signer.signHeader(request);
            for (String key : signed.keySet()) {
                request.getHeaders().put(key, signed.get(key));
            }
        }
        return request;
    }

    public TosRequest buildPreSignedUrlRequest(String method, boolean isSignedAllHeaders, long ttl) throws TosClientException {
        TosRequest request = this.genTosRequest(method, null);
        request.setSignedAllHeaders(isSignedAllHeaders);
        if (this.signer != null) {
            Map<String, String> query = this.signer.signQuery(request, Duration.ofSeconds(ttl));
            if (request.getQuery() == null) {
                request.setQuery(new HashMap<String, String>());
            }
            for (String key : query.keySet()) {
                request.getQuery().put(key, query.get(key));
            }
        }
        return request;
    }

    public TosRequest buildRequestWithCopySource(String method, String srcBucket, String srcObject) throws TosClientException {
        TosRequest request;
        try {
            request = this.build(method, null);
        }
        catch (IOException e) {
            throw new TosClientException("build tos request failed", e);
        }
        String versionID = null;
        if (request.getQuery() != null) {
            versionID = request.getQuery().get("versionId");
            request.getQuery().remove("versionId");
        }
        String cpSrcHeader = "";
        try {
            cpSrcHeader = this.copySource(srcBucket, srcObject, versionID);
        }
        catch (UnsupportedEncodingException e) {
            throw new TosClientException("object key encode exception", e);
        }
        request.getHeaders().put("X-Tos-Copy-Source", cpSrcHeader);
        if (this.signer != null) {
            Map<String, String> signed = this.signer.signHeader(request);
            for (String key : signed.keySet()) {
                request.getHeaders().put(key, signed.get(key));
            }
        }
        return request;
    }

    private String copySource(String bucket, String object, String versionID) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty(versionID)) {
            return "/" + bucket + "/" + URLEncoder.encode(object, "UTF-8");
        }
        return "/" + bucket + "/" + URLEncoder.encode(object, "UTF-8") + "?versionId=" + versionID;
    }

    @Deprecated
    public String preSignedURL(String method, Duration ttl) throws TosClientException {
        TosRequest request;
        try {
            request = this.build(method, null);
        }
        catch (IOException e) {
            throw new TosClientException("build tos request failed", e);
        }
        if (this.signer != null) {
            Map<String, String> query = this.signer.signQuery(request, ttl);
            for (String key : query.keySet()) {
                request.getQuery().put(key, query.get(key));
            }
        }
        return request.toURL().toString();
    }
}

