/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.Utils;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.comm.event.DataTransferType;
import com.volcengine.tos.comm.event.DownloadEventType;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.taskman.AbortTaskHook;
import com.volcengine.tos.internal.taskman.DownloadFileTask;
import com.volcengine.tos.internal.taskman.DownloadFileTaskCanceler;
import com.volcengine.tos.internal.taskman.TaskManager;
import com.volcengine.tos.internal.taskman.TaskManagerImpl;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.FileUtils;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.model.object.DownloadEvent;
import com.volcengine.tos.model.object.DownloadFileCheckpoint;
import com.volcengine.tos.model.object.DownloadFileInfo;
import com.volcengine.tos.model.object.DownloadFileInput;
import com.volcengine.tos.model.object.DownloadFileOutput;
import com.volcengine.tos.model.object.DownloadObjectInfo;
import com.volcengine.tos.model.object.DownloadPartInfo;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DownloadFileTaskHandler {
    private DownloadFileInput input;
    private TosObjectRequestHandler handler;
    private DownloadFileCheckpoint checkpoint;
    private HeadObjectV2Output headObjectV2Output;
    private boolean enableCrcCheck;
    private TaskManager taskMan;
    private List<DownloadPartInfo> downloadPartInfos;
    private AbortTaskHook abortTaskHook;
    private final AtomicLong consumedBytes;

    public DownloadFileTaskHandler(DownloadFileInput input, TosObjectRequestHandler handler, boolean enableCrcCheck) {
        ParamsChecker.ensureNotNull(input, "DownloadFileInput");
        ParamsChecker.ensureNotNull(handler, "TosObjectRequestHandler");
        this.input = input;
        this.handler = handler;
        this.enableCrcCheck = enableCrcCheck;
        this.consumedBytes = new AtomicLong(0L);
    }

    public void initTask() {
        this.validateInput();
        this.headObjectV2Output = this.handler.headObject(new HeadObjectV2Input().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setVersionID(this.input.getVersionID()).setOptions(this.input.getOptions()));
        String newPath = FileUtils.parseFilePath(this.input.getFilePath(), this.input.getKey());
        if (StringUtils.isEmpty(newPath)) {
            return;
        }
        this.input.setFilePath(newPath);
        if (StringUtils.isEmpty(this.input.getTempFilePath())) {
            this.input.setTempFilePath(newPath + ".temp" + "." + TosUtils.genUuid());
        }
        if (this.input.isEnableCheckpoint()) {
            this.validateCheckpointPath();
        }
        this.setCheckpoint(this.headObjectV2Output);
        int partsNum = this.checkpoint.getDownloadPartInfos().size();
        this.abortTaskHook = new DownloadFileTaskCanceler(this.handler, this.taskMan, this.checkpoint.getBucket(), this.checkpoint.getKey(), this.input.getCheckpointFile(), this.input.isEnableCheckpoint(), this.checkpoint.getDownloadFileInfo().getTempFilePath());
        this.taskMan = new TaskManagerImpl(this.input.getTaskNum(), partsNum, null, this.abortTaskHook);
        if (this.input.getCancelHook() != null && this.input.getCancelHook() instanceof DownloadFileTaskCanceler) {
            ((DownloadFileTaskCanceler)this.input.getCancelHook()).setHandler(this.handler).setTaskMan(this.taskMan).setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setTempFilePath(this.checkpoint.getDownloadFileInfo().getTempFilePath()).setEnableCheckpoint(this.input.isEnableCheckpoint()).setCheckpointFilePath(this.input.getCheckpointFile());
        }
        this.downloadPartInfos = new ArrayList<DownloadPartInfo>(partsNum);
    }

    public void dispatch() {
        for (int i = 0; i < this.checkpoint.getDownloadPartInfos().size(); ++i) {
            if (!this.checkpoint.getDownloadPartInfos().get(i).isCompleted()) {
                this.taskMan.dispatch(new DownloadFileTask(this.checkpoint, i, this.consumedBytes).setEnableCheckpoint(this.input.isEnableCheckpoint()).setCheckpointFile(this.input.getCheckpointFile()).setEnableCrcCheck(this.enableCrcCheck).setDownloadEventListener(this.input.getDownloadEventListener()).setHandler(this.handler).setHeadObjectV2Input(new HeadObjectV2Input().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setOptions(this.cloneOptions(this.input.getOptions(), this.checkpoint.getDownloadObjectInfo().getEtag())).setVersionID(this.input.getVersionID())).setRateLimiter(this.input.getRateLimiter()).setDataTransferListener(this.input.getDataTransferListener()).setTrafficLimit(this.input.getTrafficLimit()));
                continue;
            }
            this.downloadPartInfos.add(this.checkpoint.getDownloadPartInfos().get(i));
        }
    }

    private ObjectMetaRequestOptions cloneOptions(ObjectMetaRequestOptions options, String etag) {
        HashMap<String, String> headers;
        if (options == null || options.getHeaders() == null) {
            headers = new HashMap<String, String>();
        } else {
            headers = new HashMap(options.getHeaders().size());
            for (Map.Entry<String, String> entry : options.getHeaders().entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        if (!headers.containsKey("If-Match")) {
            headers.put("If-Match", etag);
        }
        return new ObjectMetaRequestOptions().setHeaders(headers);
    }

    public DownloadFileOutput handle() {
        Util.postDataTransferStatus(this.input.getDataTransferListener(), new DataTransferStatus().setType(DataTransferType.DATA_TRANSFER_STARTED).setTotalBytes(this.checkpoint.getDownloadObjectInfo().getObjectSize()).setConsumedBytes(this.consumedBytes.get()));
        this.taskMan.handle();
        List<TaskOutput<?>> outputs = this.taskMan.get();
        for (TaskOutput<?> output : outputs) {
            DownloadPartInfo tmp = (DownloadPartInfo)output.getOutput();
            if (tmp == null) continue;
            this.downloadPartInfos.add(tmp);
        }
        DataTransferStatus status = new DataTransferStatus().setConsumedBytes(this.consumedBytes.get()).setTotalBytes(this.checkpoint.getDownloadObjectInfo().getObjectSize());
        if (!this.readyForComplete()) {
            String message = "tos: some download tasks failed. bucket is " + this.input.getBucket() + ", key is " + this.input.getKey();
            throw new TosClientException(message, null);
        }
        Util.postDataTransferStatus(this.input.getDataTransferListener(), status.setType(DataTransferType.DATA_TRANSFER_SUCCEED));
        return this.completeDownloadFileTask();
    }

    private DownloadFileOutput completeDownloadFileTask() {
        DownloadEvent event = new DownloadEvent().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setCheckpointFile(this.input.getCheckpointFile()).setFilePath(this.input.getFilePath());
        if (this.enableCrcCheck) {
            this.combineCrcAndCheck();
        }
        try {
            this.renameFile();
            Util.postDownloadEvent(this.input.getDownloadEventListener(), event.setDownloadEventType(DownloadEventType.DownloadEventRenameTempFileSucceed));
        }
        catch (TosException e) {
            Util.postDownloadEvent(this.input.getDownloadEventListener(), event.setTosException(e).setDownloadEventType(DownloadEventType.DownloadEventRenameTempFileFailed));
            throw e;
        }
        if (this.input.isEnableCheckpoint()) {
            Util.deleteCheckpointFile(this.input.getCheckpointFile());
        }
        return new DownloadFileOutput().setOutput(this.headObjectV2Output);
    }

    private void validateInput() {
        if (this.input.getPartSize() == 0L) {
            this.input.setPartSize(0x1400000L);
        }
        Util.validatePartSize(this.input.getPartSize());
        this.input.setTaskNum(Util.determineTaskNum(this.input.getTaskNum()));
    }

    private void validateCheckpointPath() {
        String checkpointFileSuffix = Util.checkpointPathMd5(this.input.getBucket(), this.input.getKey(), this.input.getVersionID()) + ".download";
        if (StringUtils.isEmpty(this.input.getCheckpointFile())) {
            this.input.setCheckpointFile(this.input.getFilePath() + checkpointFileSuffix);
        } else {
            File ufcf = new File(this.input.getCheckpointFile());
            if (ufcf.isDirectory()) {
                throw new TosClientException("The input checkpoint file is directory: " + this.input.getCheckpointFile(), null);
            }
        }
    }

    private void createTempFile() {
        DownloadEvent downloadEvent = new DownloadEvent().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setVersionID(this.input.getVersionID()).setFilePath(this.input.getFilePath());
        File file = new File(this.input.getTempFilePath());
        try {
            if (file.exists()) {
                TosUtils.getLogger().debug("tos: temp file already exists.");
            } else {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            Util.postDownloadEvent(this.input.getDownloadEventListener(), downloadEvent.setDownloadEventType(DownloadEventType.DownloadEventCreateTempFileSucceed));
        }
        catch (IOException e) {
            Util.postDownloadEvent(this.input.getDownloadEventListener(), downloadEvent.setDownloadEventType(DownloadEventType.DownloadEventCreateTempFileFailed));
            throw new TosClientException("tos: create temp file failed.", e);
        }
    }

    private void setCheckpoint(HeadObjectV2Output head) {
        DownloadFileCheckpoint checkpoint = null;
        if (this.input.isEnableCheckpoint()) {
            try {
                checkpoint = this.loadCheckpointFromFile(this.input.getCheckpointFile());
            }
            catch (IOException | ClassNotFoundException e) {
                TosUtils.getLogger().debug("loadCheckpointFromFile failed, {}", (Object)e.toString());
                Util.deleteCheckpointFile(this.input.getCheckpointFile());
            }
        }
        boolean valid = false;
        if (checkpoint != null) {
            String etag = null;
            if (head != null) {
                etag = head.getEtag();
            }
            if (!(valid = checkpoint.isValid(this.input.getBucket(), this.input.getKey(), this.input.getFilePath(), etag))) {
                Util.deleteCheckpointFile(this.input.getCheckpointFile());
            } else {
                long downloadedBytes = 0L;
                for (DownloadPartInfo partInfo : checkpoint.getDownloadPartInfos()) {
                    if (!partInfo.isCompleted()) continue;
                    downloadedBytes += partInfo.getRangeEnd() - partInfo.getRangeStart() + 1L;
                }
                this.consumedBytes.compareAndSet(this.consumedBytes.get(), downloadedBytes);
            }
        }
        if (checkpoint == null || !valid) {
            this.createTempFile();
            checkpoint = this.initCheckpoint(head);
            if (this.input.isEnableCheckpoint()) {
                try {
                    checkpoint.writeToFile(this.input.getCheckpointFile());
                }
                catch (IOException e) {
                    throw new TosClientException("tos: record to checkpoint file failed", e);
                }
            }
        }
        this.checkpoint = checkpoint;
    }

    private DownloadFileCheckpoint loadCheckpointFromFile(String checkpointFilePath) throws IOException, ClassNotFoundException {
        ParamsChecker.ensureNotNull(checkpointFilePath, "checkpointFilePath is null");
        File f = new File(checkpointFilePath);
        try (FileInputStream checkpointFile = new FileInputStream(f);){
            byte[] data = new byte[(int)f.length()];
            checkpointFile.read(data);
            DownloadFileCheckpoint downloadFileCheckpoint = (DownloadFileCheckpoint)TosUtils.getJsonMapper().readValue(data, (TypeReference)new TypeReference<DownloadFileCheckpoint>(){});
            return downloadFileCheckpoint;
        }
    }

    private DownloadFileCheckpoint initCheckpoint(HeadObjectV2Output head) throws TosException {
        ParamsChecker.ensureNotNull(head, "HeadObjectV2Output");
        long objectSize = "Symlink".equals(head.getObjectType()) ? head.getSymlinkTargetSize() : head.getContentLength();
        return new DownloadFileCheckpoint().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setVersionID(this.input.getVersionID()).setIfMatch(this.input.getOptions() == null ? null : this.input.getOptions().getIfMatch()).setIfModifiedSince(this.input.getOptions() == null ? null : this.input.getOptions().getIfModifiedSince()).setIfNoneMatch(this.input.getOptions() == null ? null : this.input.getOptions().getIfNoneMatch()).setIfUnModifiedSince(this.input.getOptions() == null ? null : this.input.getOptions().getIfUnmodifiedSince()).setSsecAlgorithm(this.input.getOptions() == null ? null : this.input.getOptions().getSsecAlgorithm()).setSsecKeyMD5(this.input.getOptions() == null ? null : this.input.getOptions().getSsecKeyMD5()).setDownloadFileInfo(new DownloadFileInfo().setFilePath(this.input.getFilePath()).setTempFilePath(this.input.getTempFilePath())).setDownloadObjectInfo(new DownloadObjectInfo().setObjectSize(objectSize).setEtag(head.getEtag()).setHashCrc64ecma(head.getHashCrc64ecma()).setLastModified(head.getLastModifiedInDate())).setPartSize(this.input.getPartSize()).setDownloadPartInfos(this.getPartsFromFile(this.input.getPartSize(), objectSize));
    }

    private List<DownloadPartInfo> getPartsFromFile(long partSize, long contentLength) {
        long partNum = contentLength / partSize;
        long lastPartSize = contentLength % partSize;
        if (lastPartSize != 0L) {
            ++partNum;
        }
        ArrayList<DownloadPartInfo> partInfoList = new ArrayList<DownloadPartInfo>((int)partNum);
        int i = 0;
        while ((long)i < partNum) {
            partInfoList.add(new DownloadPartInfo().setPartNumber(i + 1).setRangeStart((long)i * partSize).setRangeEnd((long)(i + 1) * partSize - 1L));
            ++i;
        }
        ((DownloadPartInfo)partInfoList.get((int)partNum - 1)).setRangeEnd((partNum - 1L) * partSize + lastPartSize - 1L);
        return partInfoList;
    }

    private boolean readyForComplete() {
        if (this.checkpoint == null || this.checkpoint.getBucket() == null || this.checkpoint.getKey() == null || this.checkpoint.getDownloadPartInfos() == null) {
            return false;
        }
        if (this.downloadPartInfos.size() != this.checkpoint.getDownloadPartInfos().size()) {
            return false;
        }
        for (DownloadPartInfo part : this.checkpoint.getDownloadPartInfos()) {
            if (part.isCompleted()) continue;
            return false;
        }
        return true;
    }

    private void combineCrcAndCheck() {
        boolean headResNotNull;
        boolean bl = headResNotNull = this.headObjectV2Output != null;
        if (!headResNotNull) {
            return;
        }
        if (this.headObjectV2Output.getHashCrc64ecma() == null) {
            return;
        }
        if (this.downloadPartInfos == null || this.downloadPartInfos.size() == 0) {
            return;
        }
        String serverCrc64 = this.headObjectV2Output.getHashCrc64ecma();
        long crc = this.computeClientCrc();
        if (StringUtils.isNotEmpty(serverCrc64) && !Utils.isSameHashCrc64Ecma(crc, serverCrc64)) {
            this.clearTmpFile();
            throw new TosClientException("tos: expect crc64 " + serverCrc64 + ", actual crc64 " + crc, null);
        }
    }

    private void clearTmpFile() {
        if (this.input.isEnableCheckpoint()) {
            new File(this.input.getCheckpointFile()).delete();
        }
        new File(this.input.getTempFilePath()).delete();
    }

    private long computeClientCrc() {
        this.downloadPartInfos.sort(new Comparator<DownloadPartInfo>(){

            @Override
            public int compare(DownloadPartInfo o1, DownloadPartInfo o2) {
                return o1.getPartNumber() - o2.getPartNumber();
            }
        });
        long crc = this.downloadPartInfos.get(0).getHashCrc64ecma();
        for (int i = 1; i < this.downloadPartInfos.size(); ++i) {
            long len = this.downloadPartInfos.get(i).getRangeEnd() - this.downloadPartInfos.get(i).getRangeStart() + 1L;
            crc = CRC64Utils.combine(crc, this.downloadPartInfos.get(i).getHashCrc64ecma(), len);
        }
        return crc;
    }

    private void renameFile() {
        File fileSrc = new File(this.input.getTempFilePath());
        File fileDst = new File(this.input.getFilePath());
        if (!fileSrc.exists()) {
            throw new TosClientException("tos: temp download file not found, " + this.input.getTempFilePath(), null);
        }
        if (!fileSrc.renameTo(fileDst)) {
            throw new TosClientException("tos: move temp file to dst file failed", null);
        }
    }
}

