/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.tos.ClientOptionsBuilder;
import com.volcengine.tos.Config;
import com.volcengine.tos.TOS;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.UnexpectedStatusCodeException;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.SignV4;
import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.comm.MimeType;
import com.volcengine.tos.comm.io.TosRepeatableBoundedFileInputStream;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestOptionsBuilder;
import com.volcengine.tos.internal.ServerExceptionJson;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.acl.GetObjectAclOutput;
import com.volcengine.tos.model.acl.ObjectAclGrant;
import com.volcengine.tos.model.acl.PutObjectAclInput;
import com.volcengine.tos.model.acl.PutObjectAclOutput;
import com.volcengine.tos.model.bucket.CreateBucketInput;
import com.volcengine.tos.model.bucket.CreateBucketOutput;
import com.volcengine.tos.model.bucket.DeleteBucketOutput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyOutput;
import com.volcengine.tos.model.bucket.GetBucketPolicyOutput;
import com.volcengine.tos.model.bucket.HeadBucketOutput;
import com.volcengine.tos.model.bucket.ListBucketsInput;
import com.volcengine.tos.model.bucket.ListBucketsOutput;
import com.volcengine.tos.model.bucket.PutBucketPolicyOutput;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadInput;
import com.volcengine.tos.model.object.CompleteMultipartUploadOutput;
import com.volcengine.tos.model.object.CopyObjectOutput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsInput;
import com.volcengine.tos.model.object.DeleteMultiObjectsOutput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.GetObjectOutput;
import com.volcengine.tos.model.object.HeadObjectOutput;
import com.volcengine.tos.model.object.ListMultipartUploadsInput;
import com.volcengine.tos.model.object.ListMultipartUploadsOutput;
import com.volcengine.tos.model.object.ListObjectVersionsInput;
import com.volcengine.tos.model.object.ListObjectVersionsOutput;
import com.volcengine.tos.model.object.ListObjectsInput;
import com.volcengine.tos.model.object.ListObjectsOutput;
import com.volcengine.tos.model.object.ListUploadedPartsInput;
import com.volcengine.tos.model.object.ListUploadedPartsOutput;
import com.volcengine.tos.model.object.MultipartUploadedPart;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.SetObjectMetaOutput;
import com.volcengine.tos.model.object.TosObjectInputStream;
import com.volcengine.tos.model.object.UploadFileCheckpoint;
import com.volcengine.tos.model.object.UploadFileInfo;
import com.volcengine.tos.model.object.UploadFileInput;
import com.volcengine.tos.model.object.UploadFileOutput;
import com.volcengine.tos.model.object.UploadFilePartInfo;
import com.volcengine.tos.model.object.UploadPartCopyInput;
import com.volcengine.tos.model.object.UploadPartCopyOutput;
import com.volcengine.tos.model.object.UploadPartInput;
import com.volcengine.tos.model.object.UploadPartOutput;
import com.volcengine.tos.model.object.multipartUpload;
import com.volcengine.tos.session.Session;
import com.volcengine.tos.session.SessionOptionsBuilder;
import com.volcengine.tos.session.SessionTransport;
import com.volcengine.tos.transport.DefaultTransport;
import com.volcengine.tos.transport.TransportConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TOSClient
implements TOS {
    static final int URL_MODE_DEFAULT = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TOSClient.class);
    private static final String VERSION = "v2.1.2";
    private static final String SDK_NAME = "ve-tos-java-sdk";
    private static final String USER_AGENT = String.format("%s/%s (%s/%s;%s)", "ve-tos-java-sdk", "v2.1.2", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("java.version", "0"));
    static final ObjectMapper JSON = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private String scheme;
    private String host;
    private int urlMode;
    private String userAgent;
    private Credentials credentials;
    private Signer signer;
    private Transport transport;
    private Config config;

    List<String> getSchemeAndHost(String endpoint) {
        return ParamsChecker.parseFromEndpoint(endpoint);
    }

    private void schemeHost(String endpoint) {
        List<String> schemeHost = this.getSchemeAndHost(endpoint);
        this.scheme = schemeHost.get(0);
        this.host = schemeHost.get(1);
        this.urlMode = 0;
    }

    public TOSClient(Session session) {
        Objects.requireNonNull(session.getEndpoint(), "the endpoint is null");
        Objects.requireNonNull(session.getRegion(), "the region is null");
        Objects.requireNonNull(session.getCredentials(), "the credentials is null");
        this.config = new Config().defaultConfig();
        this.config.setEndpoint(session.getEndpoint());
        this.schemeHost(session.getEndpoint());
        for (SessionOptionsBuilder option : session.getOptions()) {
            option.sessionOption(this);
        }
        TransportConfig tc = SessionTransport.getConfigInstance();
        if (tc != null) {
            this.config.setTransportConfig(tc);
            this.transport = SessionTransport.getInstance();
        } else {
            this.transport = SessionTransport.getInstance(this.config.getTransportConfig());
        }
        Credentials cred = session.getCredentials();
        if (cred != null && this.signer == null) {
            this.signer = new SignV4(cred, session.getRegion());
        }
        if (this.userAgent == null || "".equals(this.userAgent)) {
            this.userAgent = USER_AGENT;
        }
    }

    public TOSClient(String endpoint, ClientOptionsBuilder ... options) {
        Credentials cred;
        this.config = new Config().defaultConfig();
        this.config.setEndpoint(endpoint);
        for (ClientOptionsBuilder option : options) {
            option.clientOption(this);
        }
        this.schemeHost(endpoint);
        if (this.transport == null) {
            this.transport = new DefaultTransport(this.config.getTransportConfig());
        }
        if ((cred = this.credentials) != null && this.signer == null) {
            Objects.requireNonNull(this.config.getRegion(), "the region is null");
            this.signer = new SignV4(cred, this.config.getRegion());
        }
        if (this.userAgent == null || "".equals(this.userAgent)) {
            this.userAgent = USER_AGENT;
        }
    }

    protected RequestBuilder newBuilder(String bucket, String object, RequestOptionsBuilder ... builders) {
        RequestBuilder rb = new RequestBuilder(this.signer, this.scheme, this.host, bucket, object, this.urlMode, new HashMap<String, String>(), new HashMap<String, String>());
        rb.withHeader("User-Agent", this.userAgent);
        for (RequestOptionsBuilder builder : builders) {
            builder.withOption(rb);
        }
        return rb;
    }

    TosResponse roundTrip(TosRequest request, int expectedCode) throws TosException {
        TosResponse res;
        try {
            res = this.transport.roundTrip(request);
        }
        catch (IOException e) {
            throw new TosClientException("request exception", e);
        }
        if (res.getStatusCode() == expectedCode) {
            return res;
        }
        try {
            if (res.getStatusCode() >= 400) {
                String s = StringUtils.toString(res.getInputStream());
                if (s.length() > 0) {
                    try {
                        ServerExceptionJson se = (ServerExceptionJson)JSON.readValue(s, (TypeReference)new TypeReference<ServerExceptionJson>(){});
                        if (res.getStatusCode() == 400) {
                            throw new TosClientException("bad request, " + s, null);
                        }
                        throw new TosServerException(res.getStatusCode(), se.getCode(), se.getMessage(), se.getRequestID(), se.getHostID());
                    }
                    catch (JsonProcessingException e) {
                        throw new TosClientException("parse server exception failed", (Exception)((Object)e));
                    }
                }
                if (res.getStatusCode() == 404) {
                    throw new TosServerException(res.getStatusCode(), "NotFound", "", res.getRequesID(), "");
                }
                if (res.getStatusCode() == 403) {
                    throw new TosServerException(res.getStatusCode(), "Forbidden", "", res.getRequesID(), "");
                }
            }
        }
        catch (IOException e) {
            throw new TosClientException("check exception error", e);
        }
        throw new UnexpectedStatusCodeException(res.getStatusCode(), expectedCode, res.getRequesID());
    }

    @Override
    public CreateBucketOutput createBucket(CreateBucketInput input) throws TosException {
        Objects.requireNonNull(input, "CreateBucketInput is null");
        Objects.requireNonNull(input.getBucket(), "bucket name is null");
        TOSClient.isValidBucketName(input.getBucket());
        TosRequest req = this.newBuilder(input.getBucket(), "", new RequestOptionsBuilder[0]).withHeader("X-Tos-Acl", input.getAcl()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", input.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp()).withHeader("X-Tos-Storage-Class", input.getStorageClass()).buildRequest("PUT", null);
        TosResponse res = this.roundTrip(req, 200);
        return new CreateBucketOutput(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("Location"));
    }

    @Override
    public HeadBucketOutput headBucket(String bucket) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).buildRequest("HEAD", null);
        TosResponse res = this.roundTrip(req, 200);
        return new HeadBucketOutput(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("X-Tos-Bucket-Region"), res.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class"));
    }

    @Override
    public DeleteBucketOutput deleteBucket(String bucket) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).buildRequest("DELETE", null);
        TosResponse res = this.roundTrip(req, 204);
        return new DeleteBucketOutput(res.RequestInfo());
    }

    @Override
    public ListBucketsOutput listBuckets(ListBucketsInput input) throws TosException {
        TosRequest req = this.newBuilder("", "", new RequestOptionsBuilder[0]).buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<ListBucketsOutput>(){}).setRequestInfo(res.RequestInfo());
    }

    @Override
    public PutBucketPolicyOutput putBucketPolicy(String bucket, String policy) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).withQuery("policy", "").buildRequest("PUT", new ByteArrayInputStream(policy.getBytes(StandardCharsets.UTF_8)));
        TosResponse res = this.roundTrip(req, 204);
        return new PutBucketPolicyOutput().setRequestInfo(res.RequestInfo());
    }

    @Override
    public GetBucketPolicyOutput getBucketPolicy(String bucket) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).withQuery("policy", "").buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        GetBucketPolicyOutput ret = new GetBucketPolicyOutput().setRequestInfo(res.RequestInfo());
        try {
            ret.setPolicy(StringUtils.toString(res.getInputStream()));
        }
        catch (IOException e) {
            throw new TosClientException("read bucket policy failed", e);
        }
        return ret;
    }

    @Override
    public DeleteBucketPolicyOutput deleteBucketPolicy(String bucket) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).withQuery("policy", "").buildRequest("DELETE", null);
        TosResponse res = this.roundTrip(req, 204);
        return new DeleteBucketPolicyOutput().setRequestInfo(res.RequestInfo());
    }

    private int expectedCode(RequestBuilder rb) {
        Objects.requireNonNull(rb, "requestBuilder is null");
        return rb.getHeaders().get("Range") != null ? 206 : 200;
    }

    @Override
    public GetObjectOutput getObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        RequestBuilder rb = this.newBuilder(bucket, objectKey, builders);
        TosRequest req = rb.buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, this.expectedCode(rb));
        GetObjectOutput output = new GetObjectOutput().setRequestInfo(res.RequestInfo()).setContentRange(rb.getHeaders().get("Content-Range")).setContent(new TosObjectInputStream(res.getInputStream()));
        return output.setObjectMetaFromResponse(res);
    }

    @Override
    public HeadObjectOutput headObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        RequestBuilder rb = this.newBuilder(bucket, objectKey, builders);
        TosRequest req = rb.buildRequest("HEAD", null);
        TosResponse res = this.roundTrip(req, this.expectedCode(rb));
        return new HeadObjectOutput().setRequestInfo(res.RequestInfo()).setContentRange(rb.getHeaders().get("Content-Range")).setObjectMeta(res);
    }

    @Override
    public DeleteObjectOutput deleteObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        TosRequest req = this.newBuilder(bucket, objectKey, builders).buildRequest("DELETE", null);
        TosResponse res = this.roundTrip(req, 204);
        boolean deleteMarker = Boolean.parseBoolean(res.getHeaderWithKeyIgnoreCase("X-Tos-Delete-Marker"));
        return new DeleteObjectOutput().setRequestInfo(res.RequestInfo()).setDeleteMarker(deleteMarker).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id"));
    }

    @Override
    public DeleteMultiObjectsOutput deleteMultiObjects(String bucket, DeleteMultiObjectsInput input, RequestOptionsBuilder ... builders) throws TosException {
        Objects.requireNonNull(input, "DeleteMultiObjectsInput is null");
        TOSClient.isValidBucketName(bucket);
        TosMarshalResult inputRes = PayloadConverter.serializePayloadAndComputeMD5(input);
        TosRequest req = this.newBuilder(bucket, "", builders).withHeader("Content-MD5", inputRes.getContentMD5()).withQuery("delete", "").buildRequest("POST", null).setData(inputRes.getData());
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<DeleteMultiObjectsOutput>(){}).setRequestInfo(res.RequestInfo());
    }

    private void setContentType(RequestBuilder rb, String objectKey) throws TosClientException {
        String contentType = rb.getHeaders().get("Content-Type");
        if (StringUtils.isEmpty(contentType) && rb.isAutoRecognizeContentType()) {
            contentType = MimeType.getInstance().getMimetype(objectKey);
            rb.getHeaders().put("Content-Type", contentType);
        }
    }

    @Override
    public PutObjectOutput putObject(String bucket, String objectKey, InputStream inputStream, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        RequestBuilder rb = this.newBuilder(bucket, objectKey, builders);
        this.setContentType(rb, objectKey);
        TosRequest req = rb.buildRequest("PUT", inputStream);
        TosResponse res = this.roundTrip(req, 200);
        return new PutObjectOutput().setRequestInfo(res.RequestInfo()).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setCrc64(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma")).setSseCustomerAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key"));
    }

    @Override
    public UploadFileOutput uploadFile(String bucket, UploadFileInput input, RequestOptionsBuilder ... builders) throws TosException {
        this.validateInput(bucket, input);
        if (input.isEnableCheckpoint()) {
            this.validateCheckpointPath(bucket, input);
        }
        UploadFileInfo fileInfo = this.getUploadFileInfo(input.getUploadFilePath());
        return this.uploadPartConcurrent(input, this.getCheckpoint(bucket, input, fileInfo, builders), builders);
    }

    private void validateInput(String bucket, UploadFileInput input) {
        File file;
        Objects.requireNonNull(input, "UploadFileInput is null");
        Objects.requireNonNull(input.getUploadFilePath(), "UploadFilePath is null");
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(input.getObjectKey());
        if (input.getPartSize() < 0x500000L || input.getPartSize() > 0x140000000L) {
            throw new IllegalArgumentException("The input part size is invalid, please set it range from 5MB to 5GB");
        }
        if (input.getTaskNum() > 1000) {
            input.setTaskNum(1000);
        }
        if (input.getTaskNum() < 1) {
            input.setTaskNum(1);
        }
        if (!(file = new File(input.getUploadFilePath())).exists()) {
            throw new IllegalArgumentException("The file to upload is not found in the specific path: " + input.getUploadFilePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Does not support directory, please specific your file path");
        }
    }

    private void validateCheckpointPath(String bucket, UploadFileInput input) {
        String checkpointFileSuffix = bucket + "." + input.getObjectKey().replace("/", "_") + ".upload";
        if (StringUtils.isEmpty(input.getCheckpointFile())) {
            input.setCheckpointFile(input.getUploadFilePath() + "." + checkpointFileSuffix);
        } else {
            File ufcf = new File(input.getCheckpointFile());
            if (!ufcf.exists()) {
                throw new IllegalArgumentException("The checkpoint file is not found in the specific path: " + input.getUploadFilePath());
            }
            if (ufcf.isDirectory()) {
                input.setCheckpointFile(input.getCheckpointFile() + "/" + checkpointFileSuffix);
            }
        }
    }

    private UploadFileInfo getUploadFileInfo(String uploadFilePath) {
        File file = new File(uploadFilePath);
        return new UploadFileInfo().setFilePath(uploadFilePath).setFileSize(file.length()).setLastModified(file.lastModified());
    }

    private UploadFileCheckpoint getCheckpoint(String bucket, UploadFileInput input, UploadFileInfo fileInfo, RequestOptionsBuilder ... builders) throws TosException {
        UploadFileCheckpoint checkpoint = null;
        if (input.isEnableCheckpoint()) {
            try {
                checkpoint = this.loadCheckpointFromFile(input.getCheckpointFile());
            }
            catch (IOException | ClassNotFoundException e) {
                this.deleteCheckpointFile(input.getCheckpointFile());
            }
        }
        boolean valid = false;
        if (checkpoint != null && !(valid = checkpoint.isValid(fileInfo.getFileSize(), fileInfo.getLastModified(), bucket, input.getObjectKey(), input.getUploadFilePath()))) {
            this.deleteCheckpointFile(input.getCheckpointFile());
        }
        if (checkpoint == null || !valid) {
            checkpoint = this.initCheckpoint(bucket, input, fileInfo, builders);
            if (input.isEnableCheckpoint()) {
                try {
                    checkpoint.writeToFile(input.getCheckpointFile(), JSON);
                }
                catch (IOException e) {
                    throw new TosClientException("record to checkpoint file failed", e);
                }
            }
        }
        return checkpoint;
    }

    private boolean deleteCheckpointFile(String checkpointFilePath) {
        File file = new File(checkpointFilePath);
        if (file.isFile() && file.exists()) {
            return file.delete();
        }
        return false;
    }

    private UploadFileCheckpoint loadCheckpointFromFile(String checkpointFilePath) throws IOException, ClassNotFoundException {
        Objects.requireNonNull(checkpointFilePath, "checkpointFilePath is null");
        File f = new File(checkpointFilePath);
        try (FileInputStream checkpointFile = new FileInputStream(f);){
            byte[] data = new byte[(int)f.length()];
            checkpointFile.read(data);
            UploadFileCheckpoint uploadFileCheckpoint = (UploadFileCheckpoint)JSON.readValue(data, (TypeReference)new TypeReference<UploadFileCheckpoint>(){});
            return uploadFileCheckpoint;
        }
    }

    private UploadFileCheckpoint initCheckpoint(String bucket, UploadFileInput input, UploadFileInfo info, RequestOptionsBuilder ... builders) throws TosException {
        UploadFileCheckpoint checkpoint = new UploadFileCheckpoint().setBucket(bucket).setKey(input.getObjectKey()).setFileInfo(info).setPartInfoList(this.getPartsFromFile(info.getFileSize(), input.getPartSize()));
        CreateMultipartUploadOutput output = this.createMultipartUpload(bucket, input.getObjectKey(), builders);
        checkpoint.setUploadID(output.getUploadID());
        return checkpoint;
    }

    private List<UploadFilePartInfo> getPartsFromFile(long uploadFileSize, long partSize) {
        long partNum = uploadFileSize / partSize;
        long lastPartSize = uploadFileSize % partSize;
        if (lastPartSize != 0L) {
            ++partNum;
        }
        if (partNum > 10000L) {
            throw new IllegalArgumentException("The split file parts number is larger than 10000, please increase your part size");
        }
        ArrayList<UploadFilePartInfo> partInfoList = new ArrayList<UploadFilePartInfo>((int)partNum);
        int i = 0;
        while ((long)i < partNum) {
            if ((long)i < partNum - 1L) {
                partInfoList.add(new UploadFilePartInfo().setPartSize(partSize).setPartNum(i + 1).setOffset((long)i * partSize));
            } else {
                partInfoList.add(new UploadFilePartInfo().setPartSize(lastPartSize).setPartNum(i + 1).setOffset((long)i * partSize));
            }
            ++i;
        }
        return partInfoList;
    }

    private UploadFileOutput uploadPartConcurrent(UploadFileInput input, UploadFileCheckpoint checkpoint, RequestOptionsBuilder ... builders) throws TosException {
        ExecutorService executor = Executors.newFixedThreadPool(input.getTaskNum());
        ArrayList<Future<MultipartUploadedPart>> futures = new ArrayList<Future<MultipartUploadedPart>>(checkpoint.getPartInfoList().size());
        ArrayList<MultipartUploadedPart> uploadPartOutputs = new ArrayList<MultipartUploadedPart>(checkpoint.getPartInfoList().size());
        LOG.debug("Upload file split to {} parts.", (Object)checkpoint.getPartInfoList().size());
        for (int i = 0; i < checkpoint.getPartInfoList().size(); ++i) {
            UploadFilePartInfo uploadFilePartInfo = checkpoint.getPartInfoList().get(i);
            if (!uploadFilePartInfo.isCompleted()) {
                int finalI = i;
                Future<MultipartUploadedPart> future = executor.submit(() -> {
                    long start = System.nanoTime();
                    InputStream in = this.getContentFromFile(checkpoint.getFileInfo().getFilePath(), partInfo.getOffset(), partInfo.getPartSize());
                    UploadPartOutput output = this.uploadPart(checkpoint.getBucket(), new UploadPartInput().setKey(checkpoint.getKey()).setUploadID(checkpoint.getUploadID()).setPartNumber(partInfo.getPartNum()).setPartSize(partInfo.getPartSize()).setContent(in), builders);
                    partInfo.setPart(output);
                    partInfo.setCompleted(true);
                    if (input.isEnableCheckpoint()) {
                        checkpoint.writeToFile(input.getCheckpointFile(), JSON);
                    }
                    long end = System.nanoTime();
                    LOG.debug("Upload No.{} part cost {} milliseconds, part size is {}", new Object[]{finalI + 1, (end - start) / 1000000L, partInfo.getPartSize()});
                    return output;
                });
                futures.add(future);
                continue;
            }
            uploadPartOutputs.add(checkpoint.getPartInfoList().get(i).getPart());
        }
        for (Future future : futures) {
            try {
                uploadPartOutputs.add((MultipartUploadedPart)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                if (!input.isEnableCheckpoint()) {
                    this.abortMultipartUpload(checkpoint.getBucket(), new AbortMultipartUploadInput(checkpoint.getKey(), checkpoint.getUploadID()));
                }
                throw new TosClientException("Thread executor failed", e);
            }
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            if (!input.isEnableCheckpoint()) {
                this.abortMultipartUpload(checkpoint.getBucket(), new AbortMultipartUploadInput(checkpoint.getKey(), checkpoint.getUploadID()));
            }
            throw new TosClientException("await upload executor terminated failed", e);
        }
        CompleteMultipartUploadOutput output = this.completeMultipartUpload(checkpoint.getBucket(), new CompleteMultipartUploadInput().setUploadID(checkpoint.getUploadID()).setKey(checkpoint.getKey()).setMultiUploadedParts(uploadPartOutputs));
        if (input.isEnableCheckpoint()) {
            this.deleteCheckpointFile(input.getCheckpointFile());
        }
        return new UploadFileOutput().setUploadID(checkpoint.getUploadID()).setBucket(checkpoint.getBucket()).setObjectKey(checkpoint.getKey()).setCompleteMultipartUploadOutput(output);
    }

    private InputStream getContentFromFile(String filePath, long offset, long size) throws IOException, TosClientException {
        FileInputStream in = new FileInputStream(filePath);
        if (in.skip(offset) != offset) {
            throw new IllegalArgumentException("The offset is invalid");
        }
        return new TosRepeatableBoundedFileInputStream(in, size);
    }

    @Override
    public AppendObjectOutput appendObject(String bucket, String objectKey, InputStream content, long offset, RequestOptionsBuilder ... builders) throws TosException {
        int appendOffset;
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        RequestBuilder rb = this.newBuilder(bucket, objectKey, builders).withQuery("append", "").withQuery("offset", String.valueOf(offset));
        this.setContentType(rb, objectKey);
        TosRequest req = rb.buildRequest("POST", content);
        TosResponse res = this.roundTrip(req, 200);
        String nextOffset = res.getHeaderWithKeyIgnoreCase("X-Tos-Next-Append-Offset");
        try {
            appendOffset = Integer.parseInt(nextOffset);
        }
        catch (NumberFormatException nfe) {
            throw new TosClientException("server return unexpected Next-Append-Offset header: " + nextOffset, nfe);
        }
        return new AppendObjectOutput().setRequestInfo(res.RequestInfo()).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setNextAppendOffset(appendOffset).setCrc64(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    @Override
    public SetObjectMetaOutput setObjectMeta(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        TosRequest req = this.newBuilder(bucket, objectKey, builders).withQuery("metadata", "").buildRequest("POST", null);
        TosResponse res = this.roundTrip(req, 200);
        return new SetObjectMetaOutput().setRequestInfo(res.RequestInfo());
    }

    @Override
    public ListObjectsOutput listObjects(String bucket, ListObjectsInput input) throws TosException {
        Objects.requireNonNull(input, "ListObjectsInput is null");
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("marker", input.getMarker()).withQuery("max-keys", String.valueOf(input.getMaxKeys())).withQuery("reverse", String.valueOf(input.isReverse())).withQuery("encoding-type", input.getEncodingType()).buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<ListObjectsOutput>(){}).setRequestInfo(res.RequestInfo());
    }

    @Override
    public ListObjectVersionsOutput listObjectVersions(String bucket, ListObjectVersionsInput input) throws TosException {
        Objects.requireNonNull(input, "ListObjectVersionsInput is null");
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("max-keys", input.getMaxKeys() == 0 ? null : String.valueOf(input.getMaxKeys())).withQuery("encoding-type", input.getEncodingType()).withQuery("versions", "").buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<ListObjectVersionsOutput>(){}).setRequestInfo(res.RequestInfo());
    }

    @Override
    public CopyObjectOutput copyObject(String bucket, String srcObjectKey, String dstObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKeySet(dstObjectKey, srcObjectKey);
        return this.copyObject(bucket, dstObjectKey, bucket, srcObjectKey, builders);
    }

    @Override
    public CopyObjectOutput copyObjectTo(String bucket, String dstBucket, String dstObjectKey, String srcObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidNames(dstBucket, dstObjectKey, srcObjectKey);
        return this.copyObject(dstBucket, dstObjectKey, bucket, srcObjectKey, builders);
    }

    @Override
    public CopyObjectOutput copyObjectFrom(String bucket, String srcBucket, String srcObjectKey, String dstObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidNames(srcBucket, srcObjectKey, dstObjectKey);
        return this.copyObject(bucket, dstObjectKey, srcBucket, srcObjectKey, builders);
    }

    @Override
    public UploadPartCopyOutput uploadPartCopy(String bucket, UploadPartCopyInput input, RequestOptionsBuilder ... builders) throws TosException {
        Objects.requireNonNull(input, "UploadPartCopyInput is null");
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidNames(input.getSourceBucket(), input.getDestinationKey(), new String[0]);
        TosRequest req = this.newBuilder(bucket, input.getDestinationKey(), builders).withQuery("partNumber", String.valueOf(input.getPartNumber())).withQuery("uploadId", input.getUploadID()).withQuery("versionId", input.getSourceVersionID()).withHeader("X-Tos-Copy-Source-Range", TOSClient.copyRange(input.getStartOffset(), input.getPartSize())).buildRequestWithCopySource("PUT", input.getSourceBucket(), input.getSourceKey());
        TosResponse res = this.roundTrip(req, 200);
        InnerUploadPartCopyOutput out = this.marshalOutput(res.getInputStream(), new TypeReference<InnerUploadPartCopyOutput>(){});
        return new UploadPartCopyOutput().setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSourceVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).setPartNumber(input.getPartNumber()).setEtag(out.getEtag()).setLastModified(out.getLastModified()).setCrc64(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    private CopyObjectOutput copyObject(String dstBucket, String dstObject, String srcBucket, String srcObject, RequestOptionsBuilder ... builders) throws TosException {
        TosRequest req = this.newBuilder(dstBucket, dstObject, builders).buildRequestWithCopySource("PUT", srcBucket, srcObject);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<CopyObjectOutput>(){}).setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSourceVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).setCrc64(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    @Override
    public PutObjectAclOutput putObjectAcl(String bucket, PutObjectAclInput input) throws TosException {
        Objects.requireNonNull(input, "PutObjectAclInput is null");
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(input.getKey());
        byte[] content = null;
        try {
            content = input.getAclRules() != null ? JSON.writeValueAsBytes((Object)input.getAclRules()) : new byte[]{};
        }
        catch (JsonProcessingException jpe) {
            throw new TosClientException("tos: json parse exception", (Exception)((Object)jpe));
        }
        RequestBuilder builder = this.newBuilder(bucket, input.getKey(), new RequestOptionsBuilder[0]).withQuery("acl", "");
        ObjectAclGrant grant = input.getAclGrant();
        if (grant != null) {
            builder = builder.withHeader("X-Tos-Acl", grant.getAcl()).withHeader("X-Tos-Grant-Full-Control", grant.getGrantFullControl()).withHeader("X-Tos-Grant-Read", grant.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", grant.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", grant.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", grant.getGrantWriteAcp());
        }
        TosRequest req = builder.buildRequest("PUT", null).setData(content);
        TosResponse res = this.roundTrip(req, 200);
        return new PutObjectAclOutput().setRequestInfo(res.RequestInfo());
    }

    @Override
    public GetObjectAclOutput getObjectAcl(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        TosRequest req = this.newBuilder(bucket, objectKey, new RequestOptionsBuilder[0]).withQuery("acl", "").buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<GetObjectAclOutput>(){}).setRequestInfo(res.RequestInfo()).setVersionId(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id"));
    }

    @Override
    public CreateMultipartUploadOutput createMultipartUpload(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        RequestBuilder rb = this.newBuilder(bucket, objectKey, builders).withQuery("uploads", "");
        this.setContentType(rb, objectKey);
        TosRequest req = rb.buildRequest("POST", null);
        TosResponse res = this.roundTrip(req, 200);
        multipartUpload upload = this.marshalOutput(res.getInputStream(), new TypeReference<multipartUpload>(){});
        return new CreateMultipartUploadOutput().setRequestInfo(res.RequestInfo()).setBucket(upload.getBucket()).setKey(upload.getKey()).setUploadID(upload.getUploadID()).setSseCustomerAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key"));
    }

    @Override
    public UploadPartOutput uploadPart(String bucket, UploadPartInput input, RequestOptionsBuilder ... builders) throws TosException {
        Objects.requireNonNull(input, "UploadPartInput is null");
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(input.getKey());
        TosRequest req = this.newBuilder(bucket, input.getKey(), builders).withQuery("uploadId", input.getUploadID()).withQuery("partNumber", String.valueOf(input.getPartNumber())).withContentLength(input.getPartSize()).buildRequest("PUT", input.getContent());
        TosResponse res = this.roundTrip(req, 200);
        return new UploadPartOutput().setRequestInfo(res.RequestInfo()).setPartNumber(input.getPartNumber()).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setSseCustomerAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5"));
    }

    @Override
    public CompleteMultipartUploadOutput completeMultipartUpload(String bucket, CompleteMultipartUploadInput input) throws TosException {
        Objects.requireNonNull(input, "CompleteMultipartUploadInput is null");
        Objects.requireNonNull(input.getUploadID(), "upload id is null");
        TOSClient.isValidBucketName(bucket);
        byte[] data = input.getUploadedPartData(JSON);
        TosRequest req = this.newBuilder(bucket, input.getKey(), new RequestOptionsBuilder[0]).withQuery("uploadId", input.getUploadID()).buildRequest("POST", null).setData(data);
        TosResponse res = this.roundTrip(req, 200);
        CompleteMultipartUploadOutput output = PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<CompleteMultipartUploadOutput>(){});
        return output.setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setCrc64(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    @Override
    public AbortMultipartUploadOutput abortMultipartUpload(String bucket, AbortMultipartUploadInput input) throws TosException {
        Objects.requireNonNull(input, "AbortMultipartUploadInput is null");
        Objects.requireNonNull(input.getUploadID(), "upload id is null");
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(input.getKey());
        TosRequest req = this.newBuilder(bucket, input.getKey(), new RequestOptionsBuilder[0]).withQuery("uploadId", input.getUploadID()).buildRequest("DELETE", null);
        TosResponse res = this.roundTrip(req, 204);
        return new AbortMultipartUploadOutput().setRequestInfo(res.RequestInfo());
    }

    @Override
    public ListUploadedPartsOutput listUploadedParts(String bucket, ListUploadedPartsInput input, RequestOptionsBuilder ... builders) throws TosException {
        Objects.requireNonNull(input, "ListUploadedPartsInput is null");
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(input.getKey());
        if (input.getMaxParts() < 0 || input.getPartNumberMarker() < 0) {
            throw new IllegalArgumentException("tos: ListUploadedPartsInput maxParts or partNumberMarker is small than 0");
        }
        TosRequest req = this.newBuilder(bucket, input.getKey(), builders).withQuery("uploadId", input.getUploadID()).withQuery("max-parts", String.valueOf(input.getMaxParts())).withQuery("part-number-marker", String.valueOf(input.getPartNumberMarker())).buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<ListUploadedPartsOutput>(){}).setRequestInfo(res.RequestInfo());
    }

    @Override
    public ListMultipartUploadsOutput listMultipartUploads(String bucket, ListMultipartUploadsInput input) throws TosException {
        Objects.requireNonNull(input, "ListMultipartUploadsInput is null");
        TOSClient.isValidBucketName(bucket);
        TosRequest req = this.newBuilder(bucket, "", new RequestOptionsBuilder[0]).withQuery("uploads", "").withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("upload-id-marker", input.getUploadIDMarker()).withQuery("max-uploads", String.valueOf(input.getMaxUploads())).buildRequest("GET", null);
        TosResponse res = this.roundTrip(req, 200);
        return this.marshalOutput(res.getInputStream(), new TypeReference<ListMultipartUploadsOutput>(){}).setRequestInfo(res.RequestInfo());
    }

    @Override
    public String preSignedURL(String httpMethod, String bucket, String objectKey, Duration ttl, RequestOptionsBuilder ... builders) throws TosException {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(objectKey);
        return this.newBuilder(bucket, objectKey, builders).preSignedURL(httpMethod, ttl);
    }

    private <T> T marshalOutput(InputStream reader, TypeReference<T> valueTypeRef) throws TosException {
        try {
            return (T)JSON.readValue(reader, valueTypeRef);
        }
        catch (IOException e) {
            throw new TosClientException("Marshal Output Exception", e);
        }
    }

    static String copyRange(long startOffset, long partSize) {
        String cr = "";
        if (startOffset != 0L) {
            cr = partSize != 0L ? String.format("bytes=%d-%d", startOffset, startOffset + partSize - 1L) : String.format("bytes=%d-", startOffset);
        } else if (partSize != 0L) {
            cr = String.format("bytes=0-%d", partSize - 1L);
        }
        return cr;
    }

    static void isValidBucketName(String name) {
        char[] cn;
        if (StringUtils.isEmpty(name) || name.length() < 3 || name.length() > 63) {
            throw new IllegalArgumentException("tos: bucket name length must between [3, 64)");
        }
        for (char c : cn = name.toCharArray()) {
            if ('a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '-') continue;
            throw new IllegalArgumentException("tos: bucket name can consist only of lowercase letters, numbers, and '-' ");
        }
        if (cn[0] == '-' || cn[name.length() - 1] == '-') {
            throw new IllegalArgumentException("tos: bucket name must begin and end with a letter or number");
        }
    }

    static void isValidNames(String bucket, String key, String ... keys) {
        TOSClient.isValidBucketName(bucket);
        TOSClient.isValidKey(key);
        TOSClient.isValidKeySet(keys);
    }

    private static void isValidKey(String key) {
        if (StringUtils.isEmpty(key)) {
            throw new IllegalArgumentException("tos: object name is empty");
        }
    }

    private static void isValidKeySet(String ... keys) {
        for (String k : keys) {
            TOSClient.isValidKey(k);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public TOSClient setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public TOSClient setHost(String host) {
        this.host = host;
        return this;
    }

    public int getUrlMode() {
        return this.urlMode;
    }

    public TOSClient setUrlMode(int urlMode) {
        this.urlMode = urlMode;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public TOSClient setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public TOSClient setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public TOSClient setSigner(Signer signer) {
        this.signer = signer;
        return this;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public TOSClient setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public Config getConfig() {
        return this.config;
    }

    public TOSClient setConfig(Config config) {
        this.config = config;
        return this;
    }

    public String toString() {
        return "TOSClient{scheme='" + this.scheme + '\'' + ", host='" + this.host + '\'' + ", urlMode=" + this.urlMode + ", userAgent='" + this.userAgent + '\'' + ", credentials=" + this.credentials + ", signer=" + this.signer + ", transport=" + this.transport + ", config=" + this.config + '}';
    }

    @Deprecated
    private static class InnerUploadPartCopyOutput {
        @JsonProperty(value="ETag")
        String etag;
        @JsonProperty(value="LastModified")
        String lastModified;

        private InnerUploadPartCopyOutput() {
        }

        private String getEtag() {
            return this.etag;
        }

        private String getLastModified() {
            return this.lastModified;
        }
    }
}

