/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.comm.io;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.model.object.TosObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class TosRepeatableFileInputStream
extends TosObjectInputStream {
    private File f;
    private FileChannel fileChannel;
    private FileInputStream fileInputStream;
    private long markPos = 0L;

    public TosRepeatableFileInputStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file), file);
    }

    public TosRepeatableFileInputStream(FileInputStream in) {
        this(in, null);
    }

    public TosRepeatableFileInputStream(FileInputStream fis, File file) {
        super(fis);
        this.f = file;
        this.fileInputStream = fis;
        this.fileChannel = fis.getChannel();
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException e) {
            throw new TosClientException("Failed to get file position", e);
        }
    }

    @Override
    public int read() throws IOException {
        return this.fileInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.fileInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.fileInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fileInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.fileInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.fileInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException e) {
            throw new TosClientException("Failed to mark the file position", e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fileChannel.position(this.markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

