/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.WrappedTransportRequestBody;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.transport.TransportConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTransport
implements Transport {
    private static final MediaType DEFAULT_MEDIA_TYPE = null;
    private final OkHttpClient client;
    private static final Logger LOG = LoggerFactory.getLogger(RequestTransport.class);

    public RequestTransport(TransportConfig config) {
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxConnections(), (long)config.getIdleConnectionTimeMills(), TimeUnit.MILLISECONDS);
        Dispatcher dispatcher = new Dispatcher();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (!config.isEnableVerifySSL()) {
            builder = this.ignoreCertificate(builder);
        }
        if (StringUtils.isNotEmpty(config.getProxyHost()) && config.getProxyPort() > 0) {
            InetSocketAddress socketAddress = new InetSocketAddress(config.getProxyHost(), config.getProxyPort());
            builder.proxy(new Proxy(Proxy.Type.HTTP, socketAddress));
            if (StringUtils.isNotEmpty(config.getProxyUserName())) {
                Authenticator proxyAuthenticator = (route, response) -> {
                    String credential = Credentials.basic((String)config.getProxyUserName(), (String)config.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                };
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        this.client = builder.dispatcher(dispatcher).connectionPool(connectionPool).retryOnConnectionFailure(true).readTimeout((long)config.getReadTimeoutMills(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getWriteTimeoutMills(), TimeUnit.MILLISECONDS).connectTimeout((long)config.getConnectTimeoutMills(), TimeUnit.MILLISECONDS).followRedirects(false).followSslRedirects(false).build();
    }

    @Override
    public TosResponse roundTrip(TosRequest tosRequest) throws IOException {
        Request request = this.buildRequest(tosRequest);
        Response response = this.client.newCall(request).execute();
        InputStream inputStream = response.body() == null ? null : response.body().byteStream();
        return new TosResponse().setStatusCode(response.code()).setContentLength(this.getSize(response)).setHeaders(this.getHeaders(response)).setInputStream(inputStream);
    }

    private Request buildRequest(TosRequest request) throws IOException {
        HttpUrl url = request.toURL();
        Request.Builder builder = new Request.Builder().url(url);
        if (request.getHeaders() != null) {
            request.getHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        }
        switch (request.getMethod() == null ? "" : request.getMethod().toUpperCase()) {
            case "GET": {
                builder.get();
                break;
            }
            case "POST": {
                if (request.getContent() != null && request.getContentLength() <= 0L) {
                    byte[] data = new byte[request.getContent().available()];
                    int exact = request.getContent().read(data);
                    if (exact != data.length) {
                        throw new IOException("expected " + data.length + " bytes, but got " + exact + " bytes.");
                    }
                    builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])data));
                    break;
                }
                if (request.getContent() != null) {
                    builder.post((RequestBody)new WrappedTransportRequestBody(this.getMediaType(request), request.getContent(), request.getContentLength()));
                    break;
                }
                builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])request.getData()));
                break;
            }
            case "PUT": {
                if (request.getContent() != null) {
                    builder.put((RequestBody)new WrappedTransportRequestBody(this.getMediaType(request), request.getContent(), request.getContentLength()));
                    break;
                }
                builder.put(RequestBody.create((MediaType)this.getMediaType(request), (byte[])request.getData()));
                break;
            }
            case "HEAD": {
                builder.head();
                break;
            }
            case "DELETE": {
                builder.delete();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Method is not supported: " + request.getMethod());
            }
        }
        return builder.build();
    }

    private OkHttpClient.Builder ignoreCertificate(OkHttpClient.Builder builder) throws TosClientException {
        LOG.warn("ignore ssl certificate verification");
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier((hostname, session) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOG.warn("exception occurred while configuring ignoreSslCertificate");
            throw new TosClientException("set ignoreCertificate failed", e);
        }
        return builder;
    }

    private MediaType getMediaType(TosRequest request) {
        String type = "";
        if (request.getHeaders() != null) {
            type = request.getHeaders().get("Content-Type");
        }
        return StringUtils.isEmpty(type) ? DEFAULT_MEDIA_TYPE : MediaType.parse((String)type);
    }

    private long getSize(Response response) {
        String size = response.header("Content-Length");
        if (StringUtils.isEmpty(size)) {
            return 0L;
        }
        return Long.parseLong(size);
    }

    private Map<String, String> getHeaders(Response response) {
        HashMap<String, String> headers = new HashMap<String, String>(response.headers().size());
        for (String name : response.headers().names()) {
            headers.put(name.toLowerCase(), response.header(name));
        }
        return headers;
    }
}

