/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.MimeType;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestHandler;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.model.CreateMultipartUploadOutputJson;
import com.volcengine.tos.internal.model.UploadPartCopyOutputJson;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.AppendObjectInput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.GetObjectACLV2Input;
import com.volcengine.tos.model.object.GetObjectACLV2Output;
import com.volcengine.tos.model.object.GetObjectBasicOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectVersionsV2Input;
import com.volcengine.tos.model.object.ListObjectVersionsV2Output;
import com.volcengine.tos.model.object.ListObjectsV2Input;
import com.volcengine.tos.model.object.ListObjectsV2Output;
import com.volcengine.tos.model.object.ListPartsInput;
import com.volcengine.tos.model.object.ListPartsOutput;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PutObjectACLInput;
import com.volcengine.tos.model.object.PutObjectACLOutput;
import com.volcengine.tos.model.object.PutObjectBasicInput;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.SetObjectMetaInput;
import com.volcengine.tos.model.object.SetObjectMetaOutput;
import com.volcengine.tos.model.object.TosObjectInputStream;
import com.volcengine.tos.model.object.UploadPartBasicInput;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TosObjectRequestHandlerImpl
implements TosObjectRequestHandler {
    private RequestHandler objectHandler;
    private TosRequestFactory factory;
    private boolean clientAutoRecognizeContentType;

    public TosObjectRequestHandlerImpl(Transport transport, TosRequestFactory factory) {
        this.objectHandler = new RequestHandler(transport);
        this.factory = factory;
    }

    public TosObjectRequestHandlerImpl setClientAutoRecognizeContentType(boolean clientAutoRecognizeContentType) {
        this.clientAutoRecognizeContentType = clientAutoRecognizeContentType;
        return this;
    }

    @Override
    public GetObjectV2Output getObject(GetObjectV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "GetObjectV2Input");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("versionId", input.getVersionID());
        TosRequest req = this.factory.build(builder, "GET", null);
        TosResponse response = this.objectHandler.doRequest(req, TosObjectRequestHandlerImpl.getExpectedCodes(input.getAllSettedHeaders()));
        return this.buildGetObjectV2Output(response);
    }

    private static List<Integer> getExpectedCodes(Map<String, String> headers) {
        ArrayList<Integer> codes = new ArrayList<Integer>(1);
        if (headers == null) {
            codes.add(200);
            return codes;
        }
        codes.add(200);
        if (headers.get("Range") != null) {
            codes.add(206);
        }
        return codes;
    }

    private GetObjectV2Output buildGetObjectV2Output(TosResponse response) {
        GetObjectBasicOutput basicOutput = new GetObjectBasicOutput().setRequestInfo(response.RequestInfo()).parseFromTosResponse(response);
        return new GetObjectV2Output(basicOutput, new TosObjectInputStream(response.getInputStream()));
    }

    @Override
    public HeadObjectV2Output headObject(HeadObjectV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "HeadObjectV2Input");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders());
        TosRequest req = this.factory.build(builder, "HEAD", null);
        return this.objectHandler.doRequest(req, TosObjectRequestHandlerImpl.getExpectedCodes(input.getAllSettedHeaders()), response -> new HeadObjectV2Output(new GetObjectBasicOutput().setRequestInfo(response.RequestInfo()).parseFromTosResponse((TosResponse)response)));
    }

    @Override
    public DeleteObjectOutput deleteObject(DeleteObjectInput input) throws TosException {
        ParamsChecker.isValidInput(input, "DeleteObjectInput");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("versionId", input.getVersionID());
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.objectHandler.doRequest(req, 204, response -> new DeleteObjectOutput().setRequestInfo(response.RequestInfo()).setDeleteMarker(Boolean.parseBoolean(response.getHeaderWithKeyIgnoreCase("X-Tos-Delete-Marker"))).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    @Override
    public DeleteMultiObjectsV2Output deleteMultiObjects(DeleteMultiObjectsV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "DeleteMultiObjectsV2Input");
        ParamsChecker.isValidInput(input.getObjects(), "objects to be deleted are null");
        ParamsChecker.isValidBucketName(input.getBucket());
        for (ObjectTobeDeleted objectTobeDeleted : input.getObjects()) {
            ParamsChecker.isValidKey(objectTobeDeleted.getKey());
        }
        TosMarshalResult data = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withHeader("Content-MD5", data.getContentMD5()).withQuery("delete", "");
        TosRequest req = this.factory.build(builder, "POST", null).setData(data.getData());
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<DeleteMultiObjectsV2Output>(){}).requestInfo(response.RequestInfo()));
    }

    private PutObjectOutput putObject(PutObjectBasicInput input, InputStream content) {
        ParamsChecker.isValidInput(input, "PutObjectBasicInput");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders());
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "PUT", content);
        return this.objectHandler.doRequest(req, 200, this::buildPutObjectOutput);
    }

    private PutObjectOutput buildPutObjectOutput(TosResponse res) {
        return new PutObjectOutput().setRequestInfo(res.RequestInfo()).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setHashCrc64ecma(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma")).setSseCustomerAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key"));
    }

    @Override
    public PutObjectOutput putObject(PutObjectInput input) throws TosException {
        ParamsChecker.isValidInput(input, "PutObjectInput");
        return this.putObject(input.getPutObjectBasicInput(), input.getContent());
    }

    @Override
    public AppendObjectOutput appendObject(AppendObjectInput input) throws TosException {
        ParamsChecker.isValidInput(input, "AppendObjectInput");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        if (input.getContentLength() < 131072L) {
            throw new IllegalArgumentException("content length should not be less than 128KB, please set content length first");
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("append", "").withQuery("offset", String.valueOf(input.getOffset())).withContentLength(input.getContentLength());
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "POST", input.getContent());
        return this.objectHandler.doRequest(req, 200, this::buildAppendObjectOutput);
    }

    private AppendObjectOutput buildAppendObjectOutput(TosResponse response) {
        long appendOffset;
        String nextOffset = response.getHeaderWithKeyIgnoreCase("X-Tos-Next-Append-Offset");
        try {
            appendOffset = Long.parseLong(nextOffset);
        }
        catch (NumberFormatException nfe) {
            throw new TosClientException("server return unexpected Next-Append-Offset header: " + nextOffset, nfe);
        }
        return new AppendObjectOutput().setRequestInfo(response.RequestInfo()).setNextAppendOffset(appendOffset).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    @Override
    public SetObjectMetaOutput setObjectMeta(SetObjectMetaInput input) throws TosException {
        ParamsChecker.isValidInput(input, "SetObjectMetaInput");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("metadata", "");
        TosRequest req = this.factory.build(builder, "POST", null);
        return this.objectHandler.doRequest(req, 200, response -> new SetObjectMetaOutput().setRequestInfo(response.RequestInfo()));
    }

    @Override
    public ListObjectsV2Output listObjects(ListObjectsV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "ListObjectsV2Input");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("marker", input.getMarker()).withQuery("max-keys", String.valueOf(input.getMaxKeys())).withQuery("reverse", String.valueOf(input.isReverse())).withQuery("encoding-type", input.getEncodingType());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    @Override
    public ListObjectVersionsV2Output listObjectVersions(ListObjectVersionsV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "ListObjectVersionsV2Input");
        ParamsChecker.isValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("max-keys", input.getMaxKeys() == 0 ? null : String.valueOf(input.getMaxKeys())).withQuery("encoding-type", input.getEncodingType()).withQuery("versions", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectVersionsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    @Override
    public CopyObjectV2Output copyObject(CopyObjectV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "CopyObjectV2Input");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        ParamsChecker.isValidBucketNameAndKey(input.getSrcBucket(), input.getSrcKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders());
        TosRequest req = this.factory.buildWithCopy(builder, "PUT", input.getSrcBucket(), input.getSrcKey());
        return this.objectHandler.doRequest(req, 200, this::buildCopyObjectV2Output);
    }

    private CopyObjectV2Output buildCopyObjectV2Output(TosResponse response) {
        return PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<CopyObjectV2Output>(){}).setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSourceVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    @Override
    public UploadPartCopyV2Output uploadPartCopy(UploadPartCopyV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "UploadPartCopyV2Input");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        ParamsChecker.isValidBucketNameAndKey(input.getSourceBucket(), input.getSourceKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("partNumber", String.valueOf(input.getPartNumber())).withQuery("uploadId", input.getUploadID()).withQuery("versionId", input.getSourceVersionID());
        TosRequest req = this.factory.buildWithCopy(builder, "PUT", input.getSourceBucket(), input.getSourceKey());
        return this.objectHandler.doRequest(req, 200, response -> this.buildUploadPartCopyV2Output(input, (TosResponse)response));
    }

    private UploadPartCopyV2Output buildUploadPartCopyV2Output(UploadPartCopyV2Input input, TosResponse response) {
        UploadPartCopyOutputJson out = PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<UploadPartCopyOutputJson>(){});
        return new UploadPartCopyV2Output().requestInfo(response.RequestInfo()).copySourceVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).partNumber(input.getPartNumber()).etag(out.getEtag()).lastModified(out.getLastModified());
    }

    @Override
    public PutObjectACLOutput putObjectAcl(PutObjectACLInput input) throws TosException {
        ParamsChecker.isValidInput(input, "PutObjectACLInput");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        byte[] content = null;
        if (input.getObjectAclRules() != null) {
            TosMarshalResult res = PayloadConverter.serializePayload(input.getObjectAclRules());
            content = res.getData();
        } else {
            content = new byte[]{};
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("acl", "").withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp());
        TosRequest req = this.factory.build(builder, "PUT", null).setData(content);
        return this.objectHandler.doRequest(req, 200, response -> new PutObjectACLOutput().requestInfo(response.RequestInfo()));
    }

    @Override
    public GetObjectACLV2Output getObjectAcl(GetObjectACLV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "GetObjectACLV2Input");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("acl", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, this::buildGetObjectACLV2Output);
    }

    private GetObjectACLV2Output buildGetObjectACLV2Output(TosResponse response) {
        return PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<GetObjectACLV2Output>(){}).setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id"));
    }

    @Override
    public CreateMultipartUploadOutput createMultipartUpload(CreateMultipartUploadInput input) throws TosException {
        ParamsChecker.isValidInput(input, "CreateMultipartUploadInput");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("uploads", "");
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "POST", null);
        return this.objectHandler.doRequest(req, 200, this::buildCreateMultipartUploadOutput);
    }

    private CreateMultipartUploadOutput buildCreateMultipartUploadOutput(TosResponse response) {
        CreateMultipartUploadOutputJson upload = PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<CreateMultipartUploadOutputJson>(){});
        return new CreateMultipartUploadOutput().setRequestInfo(response.RequestInfo()).setBucket(upload.getBucket()).setKey(upload.getKey()).setUploadID(upload.getUploadID()).setSseCustomerAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key"));
    }

    private UploadPartV2Output buildUploadPartV2Output(TosResponse res, int partNumber) {
        return new UploadPartV2Output().setRequestInfo(res.RequestInfo()).setPartNumber(partNumber).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setSsecAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5"));
    }

    private UploadPartV2Output uploadPart(UploadPartBasicInput input, long contentLength, InputStream content) {
        ParamsChecker.isValidInput(input, "UploadPartBasicInput");
        ParamsChecker.isValidInput(input.getUploadID(), "uploadID");
        ParamsChecker.isValidPartNumber(input.getPartNumber());
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("uploadId", input.getUploadID()).withQuery("partNumber", String.valueOf(input.getPartNumber())).withContentLength(contentLength);
        TosRequest req = this.factory.build(builder, "PUT", content);
        return this.objectHandler.doRequest(req, 200, response -> this.buildUploadPartV2Output((TosResponse)response, input.getPartNumber()));
    }

    @Override
    public UploadPartV2Output uploadPart(UploadPartV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "UploadPartV2Input");
        return this.uploadPart(input.getUploadPartBasicInput(), input.getContentLength(), input.getContent());
    }

    @Override
    public CompleteMultipartUploadV2Output completeMultipartUpload(CompleteMultipartUploadV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "CompleteMultipartUploadV2Input");
        ParamsChecker.isValidInput(input.getUploadID(), "uploadID");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        TosMarshalResult data = PayloadConverter.serializePayload(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID());
        TosRequest req = this.factory.build(builder, "POST", null).setData(data.getData());
        return this.objectHandler.doRequest(req, 200, this::buildCompleteMultipartUploadOutput);
    }

    private CompleteMultipartUploadV2Output buildCompleteMultipartUploadOutput(TosResponse response) {
        CompleteMultipartUploadV2Output output = PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<CompleteMultipartUploadV2Output>(){});
        return output.setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    @Override
    public AbortMultipartUploadOutput abortMultipartUpload(AbortMultipartUploadInput input) throws TosException {
        ParamsChecker.isValidInput(input, "AbortMultipartUploadInput");
        ParamsChecker.isValidInput(input.getUploadID(), "uploadID");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID());
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.objectHandler.doRequest(req, 204, response -> new AbortMultipartUploadOutput().setRequestInfo(response.RequestInfo()));
    }

    @Override
    public ListPartsOutput listParts(ListPartsInput input) throws TosException {
        ParamsChecker.isValidInput(input, "ListPartsInput");
        ParamsChecker.isValidInput(input.getUploadID(), "uploadID");
        ParamsChecker.isValidBucketNameAndKey(input.getBucket(), input.getKey());
        if (input.getMaxParts() < 0 || input.getPartNumberMarker() < 0) {
            throw new IllegalArgumentException("ListPartsInput maxParts or partNumberMarker is small than 0");
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID()).withQuery("max-parts", String.valueOf(input.getMaxParts())).withQuery("part-number-marker", String.valueOf(input.getPartNumberMarker()));
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListPartsOutput>(){}).setRequestInfo(response.RequestInfo()));
    }

    @Override
    public ListMultipartUploadsV2Output listMultipartUploads(ListMultipartUploadsV2Input input) throws TosException {
        ParamsChecker.isValidInput(input, "ListMultipartUploadsV2Input");
        ParamsChecker.isValidBucketName(input.getBucket());
        if (input.getMaxUploads() < 0) {
            throw new IllegalArgumentException("ListMultipartUploadsV2Input maxUploads is small than 0");
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("uploads", "").withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("upload-id-marker", input.getUploadIDMarker()).withQuery("max-uploads", String.valueOf(input.getMaxUploads()));
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListMultipartUploadsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    private void addContentType(RequestBuilder rb, String objectKey) throws TosClientException {
        String contentType = rb.getHeaders().get("Content-Type");
        if (StringUtils.isEmpty(contentType) && this.clientAutoRecognizeContentType && rb.isAutoRecognizeContentType()) {
            contentType = MimeType.getInstance().getMimetype(objectKey);
            rb.withHeader("Content-Type", contentType);
        }
    }
}

