/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.comm.io.TosRepeatableBoundedFileInputStream;
import com.volcengine.tos.comm.io.TosRepeatableFileInputStream;
import com.volcengine.tos.comm.io.TosRepeatableInputStream;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import okhttp3.HttpUrl;

public class TosRequest {
    private String scheme;
    private String method;
    private String host;
    private String path;
    private long contentLength;
    private transient InputStream content;
    private Map<String, String> headers = Collections.emptyMap();
    private Map<String, String> query = Collections.emptyMap();
    private byte[] data = new byte[0];

    public TosRequest() {
    }

    public TosRequest(String scheme, String method, String host, String path) {
        this.scheme = scheme;
        this.method = method;
        this.host = host;
        this.path = path;
    }

    public TosRequest(String scheme, String method, String host, String path, InputStream inputStream, Map<String, String> query, Map<String, String> headers) {
        this.scheme = scheme;
        this.method = method;
        this.host = host;
        this.path = path;
        this.content = inputStream != null ? new TosRepeatableInputStream(inputStream, 8192) : null;
        if (inputStream instanceof TosRepeatableInputStream || inputStream instanceof TosRepeatableFileInputStream || inputStream instanceof TosRepeatableBoundedFileInputStream) {
            this.content = inputStream;
        }
        this.query = query;
        this.headers = headers;
    }

    public HttpUrl toURL() {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        if (this.query != null) {
            for (Map.Entry<String, String> entry : this.query.entrySet()) {
                builder.addEncodedQueryParameter(entry.getKey(), TosUtils.uriEncode(entry.getValue(), true));
            }
        }
        String escapePath = StringUtils.removeStart(this.path, "/");
        return builder.scheme(this.scheme).host(this.host).addPathSegment(escapePath).build();
    }

    public String getScheme() {
        return this.scheme;
    }

    public TosRequest setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public TosRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public TosRequest setHost(String host) {
        this.host = host;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public TosRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TosRequest setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public InputStream getContent() {
        return this.content;
    }

    public TosRequest setContent(InputStream content) {
        this.content = content;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TosRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public TosRequest setQuery(Map<String, String> query) {
        this.query = query;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public TosRequest setData(byte[] data) {
        this.data = data;
        return this;
    }
}

