/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.comm.common.ACLType;
import com.volcengine.tos.comm.common.MetadataDirectiveType;
import com.volcengine.tos.comm.common.StorageClassType;
import com.volcengine.tos.internal.util.StringUtils;

public class TypeConverter {
    public static ACLType convertACLType(String type) {
        if (type == null) {
            return null;
        }
        if (StringUtils.equals(type, "private")) {
            return ACLType.ACL_PRIVATE;
        }
        if (StringUtils.equals(type, "public-read")) {
            return ACLType.ACL_PUBLIC_READ;
        }
        if (StringUtils.equals(type, "public-read-write")) {
            return ACLType.ACL_PUBLIC_READ_WRITE;
        }
        if (StringUtils.equals(type, "authenticated-read")) {
            return ACLType.ACL_AUTHENTICATED_READ;
        }
        if (StringUtils.equals(type, "bucket-owner-read")) {
            return ACLType.ACL_BUCKET_OWNER_READ;
        }
        if (StringUtils.equals(type, "bucket-owner-full-control")) {
            return ACLType.ACL_BUCKET_OWNER_FULL_CONTROL;
        }
        if (StringUtils.equals(type, "log-delivery-write")) {
            return ACLType.ACL_LOG_DELIVERY_WRITE;
        }
        throw new IllegalArgumentException("invalid acl type: " + type);
    }

    public static StorageClassType convertStorageClassType(String storageClass) {
        if (storageClass == null) {
            return null;
        }
        if (StringUtils.equals(storageClass, "STANDARD")) {
            return StorageClassType.STORAGE_CLASS_STANDARD;
        }
        if (StringUtils.equals(storageClass, "IA")) {
            return StorageClassType.STORAGE_CLASS_IA;
        }
        if (StringUtils.equals(storageClass, "ARCHIVE_FR")) {
            return StorageClassType.STORAGE_CLASS_ARCHIVE_FR;
        }
        throw new IllegalArgumentException("invalid storage class: " + storageClass);
    }

    public static MetadataDirectiveType convertMetadataDirectiveType(String metadataDirectiveType) {
        if (metadataDirectiveType == null) {
            return null;
        }
        if (StringUtils.equals(metadataDirectiveType, "COPY")) {
            return MetadataDirectiveType.METADATA_DIRECTIVE_COPY;
        }
        if (StringUtils.equals(metadataDirectiveType, "REPLACE")) {
            return MetadataDirectiveType.METADATA_DIRECTIVE_REPLACE;
        }
        throw new IllegalArgumentException("invalid metadataDirectiveType: " + metadataDirectiveType);
    }
}

