/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.object.UploadFileInfo;
import com.volcengine.tos.model.object.UploadFilePartInfo;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class UploadFileCheckpoint
implements Serializable {
    private String bucket;
    private String key;
    private long partSize;
    private String uploadID;
    private String sseAlgorithm;
    private String sseKeyMd5;
    private UploadFileInfo fileInfo;
    private List<UploadFilePartInfo> uploadFilePartInfoList;

    public boolean isValid(long uploadFileSize, long uploadFileLastModifiedTime, String bucket, String objectKey, String uploadFilePath) {
        if (StringUtils.isEmpty(this.uploadID) || !StringUtils.equals(this.bucket, bucket) || !StringUtils.equals(this.key, objectKey) || !StringUtils.equals(this.fileInfo.getFilePath(), uploadFilePath)) {
            return false;
        }
        return this.fileInfo.getFileSize() == uploadFileSize && this.fileInfo.getLastModified() == uploadFileLastModifiedTime;
    }

    public synchronized void writeToFile(String checkpointFile, ObjectMapper om) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(checkpointFile);){
            fos.write(om.writeValueAsBytes((Object)this));
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public UploadFileCheckpoint setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public UploadFileCheckpoint setKey(String key) {
        this.key = key;
        return this;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public UploadFileCheckpoint setPartSize(long partSize) {
        this.partSize = partSize;
        return this;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public UploadFileCheckpoint setUploadID(String uploadID) {
        this.uploadID = uploadID;
        return this;
    }

    public String getSseAlgorithm() {
        return this.sseAlgorithm;
    }

    public UploadFileCheckpoint setSseAlgorithm(String sseAlgorithm) {
        this.sseAlgorithm = sseAlgorithm;
        return this;
    }

    public String getSseKeyMd5() {
        return this.sseKeyMd5;
    }

    public UploadFileCheckpoint setSseKeyMd5(String sseKeyMd5) {
        this.sseKeyMd5 = sseKeyMd5;
        return this;
    }

    public UploadFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public UploadFileCheckpoint setFileInfo(UploadFileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    public List<UploadFilePartInfo> getPartInfoList() {
        return this.uploadFilePartInfoList;
    }

    public UploadFileCheckpoint setPartInfoList(List<UploadFilePartInfo> uploadFilePartInfoList) {
        this.uploadFilePartInfoList = uploadFilePartInfoList;
        return this;
    }

    public String toString() {
        return "UploadFileCheckpoint{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", partSize=" + this.partSize + ", uploadID='" + this.uploadID + '\'' + ", sseAlgorithm='" + this.sseAlgorithm + '\'' + ", sseKeyMd5='" + this.sseKeyMd5 + '\'' + ", fileInfo=" + this.fileInfo + ", uploadFilePartInfoList=" + this.uploadFilePartInfoList + '}';
    }
}

