/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosException;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestHandler;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TypeConverter;
import com.volcengine.tos.model.bucket.CreateBucketV2Input;
import com.volcengine.tos.model.bucket.CreateBucketV2Output;
import com.volcengine.tos.model.bucket.DeleteBucketCORSInput;
import com.volcengine.tos.model.bucket.DeleteBucketCORSOutput;
import com.volcengine.tos.model.bucket.DeleteBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.DeleteBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.DeleteBucketInput;
import com.volcengine.tos.model.bucket.DeleteBucketLifecycleInput;
import com.volcengine.tos.model.bucket.DeleteBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.DeleteBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.DeleteBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.DeleteBucketOutput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyInput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyOutput;
import com.volcengine.tos.model.bucket.DeleteBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.DeleteBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.DeleteBucketRenameInput;
import com.volcengine.tos.model.bucket.DeleteBucketRenameOutput;
import com.volcengine.tos.model.bucket.DeleteBucketReplicationInput;
import com.volcengine.tos.model.bucket.DeleteBucketReplicationOutput;
import com.volcengine.tos.model.bucket.DeleteBucketWebsiteInput;
import com.volcengine.tos.model.bucket.DeleteBucketWebsiteOutput;
import com.volcengine.tos.model.bucket.GetBucketACLInput;
import com.volcengine.tos.model.bucket.GetBucketACLOutput;
import com.volcengine.tos.model.bucket.GetBucketCORSInput;
import com.volcengine.tos.model.bucket.GetBucketCORSOutput;
import com.volcengine.tos.model.bucket.GetBucketLifecycleInput;
import com.volcengine.tos.model.bucket.GetBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.GetBucketLocationInput;
import com.volcengine.tos.model.bucket.GetBucketLocationOutput;
import com.volcengine.tos.model.bucket.GetBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.GetBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.GetBucketNotificationInput;
import com.volcengine.tos.model.bucket.GetBucketNotificationOutput;
import com.volcengine.tos.model.bucket.GetBucketPolicyInput;
import com.volcengine.tos.model.bucket.GetBucketPolicyOutput;
import com.volcengine.tos.model.bucket.GetBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.GetBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.GetBucketRenameInput;
import com.volcengine.tos.model.bucket.GetBucketRenameOutput;
import com.volcengine.tos.model.bucket.GetBucketReplicationInput;
import com.volcengine.tos.model.bucket.GetBucketReplicationOutput;
import com.volcengine.tos.model.bucket.GetBucketVersioningInput;
import com.volcengine.tos.model.bucket.GetBucketVersioningOutput;
import com.volcengine.tos.model.bucket.GetBucketWebsiteInput;
import com.volcengine.tos.model.bucket.GetBucketWebsiteOutput;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.bucket.ListBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.ListBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.ListBucketsV2Input;
import com.volcengine.tos.model.bucket.ListBucketsV2Output;
import com.volcengine.tos.model.bucket.PutBucketACLInput;
import com.volcengine.tos.model.bucket.PutBucketACLOutput;
import com.volcengine.tos.model.bucket.PutBucketCORSInput;
import com.volcengine.tos.model.bucket.PutBucketCORSOutput;
import com.volcengine.tos.model.bucket.PutBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.PutBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.PutBucketLifecycleInput;
import com.volcengine.tos.model.bucket.PutBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.PutBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.PutBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.PutBucketNotificationInput;
import com.volcengine.tos.model.bucket.PutBucketNotificationOutput;
import com.volcengine.tos.model.bucket.PutBucketPolicyInput;
import com.volcengine.tos.model.bucket.PutBucketPolicyOutput;
import com.volcengine.tos.model.bucket.PutBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.PutBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.PutBucketRenameInput;
import com.volcengine.tos.model.bucket.PutBucketRenameOutput;
import com.volcengine.tos.model.bucket.PutBucketReplicationInput;
import com.volcengine.tos.model.bucket.PutBucketReplicationOutput;
import com.volcengine.tos.model.bucket.PutBucketStorageClassInput;
import com.volcengine.tos.model.bucket.PutBucketStorageClassOutput;
import com.volcengine.tos.model.bucket.PutBucketVersioningInput;
import com.volcengine.tos.model.bucket.PutBucketVersioningOutput;
import com.volcengine.tos.model.bucket.PutBucketWebsiteInput;
import com.volcengine.tos.model.bucket.PutBucketWebsiteOutput;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public class TosBucketRequestHandler {
    private RequestHandler bucketHandler;
    private TosRequestFactory factory;

    public TosBucketRequestHandler(Transport transport, TosRequestFactory factory) {
        this.bucketHandler = new RequestHandler(transport);
        this.factory = factory;
    }

    public CreateBucketV2Output createBucket(CreateBucketV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CreateBucketV2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", input.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp()).withHeader("X-Tos-Storage-Class", input.getStorageClass() == null ? null : input.getStorageClass().toString());
        TosRequest req = this.factory.build(builder, "PUT", null).setRetryableOnClientException(false);
        return this.bucketHandler.doRequest(req, 200, res -> new CreateBucketV2Output(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("Location")));
    }

    public HeadBucketV2Output headBucket(HeadBucketV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "HeadBucketInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null);
        TosRequest req = this.factory.build(builder, "HEAD", null);
        return this.bucketHandler.doRequest(req, 200, res -> new HeadBucketV2Output(res.RequestInfo(), res.getHeaderWithKeyIgnoreCase("X-Tos-Bucket-Region"), TypeConverter.convertStorageClassType(res.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class"))));
    }

    public DeleteBucketOutput deleteBucket(DeleteBucketInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null);
        TosRequest req = this.factory.build(builder, "DELETE", null).setRetryableOnClientException(false);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketOutput(res.RequestInfo()));
    }

    public ListBucketsV2Output listBuckets(ListBucketsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListBucketsV2Input");
        RequestBuilder builder = this.factory.init("", "", null);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<ListBucketsV2Output>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketPolicyOutput putBucketPolicy(PutBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketPolicyInput");
        ParamsChecker.ensureNotNull(input.getPolicy(), "policy");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(input.getPolicy().getBytes(StandardCharsets.UTF_8))).setContentLength(input.getPolicy().length());
        return this.bucketHandler.doRequest(req, 204, res -> new PutBucketPolicyOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketPolicyOutput getBucketPolicy(GetBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketPolicyInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> new GetBucketPolicyOutput().setRequestInfo(res.RequestInfo()).setPolicy(StringUtils.toString(res.getInputStream(), "bucket policy")));
    }

    public DeleteBucketPolicyOutput deleteBucketPolicy(DeleteBucketPolicyInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketPolicyInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("policy", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketPolicyOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketCORSOutput putBucketCORS(PutBucketCORSInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketCORSInput");
        ParamsChecker.ensureNotNull(input.getRules(), "CORSRules");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("cors", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketCORSOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketCORSOutput getBucketCORS(GetBucketCORSInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketCORSInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("cors", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketCORSOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketCORSOutput deleteBucketCORS(DeleteBucketCORSInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketCORSInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("cors", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketCORSOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketStorageClassOutput putBucketStorageClass(PutBucketStorageClassInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketStorageClassInput");
        ParamsChecker.ensureNotNull((Object)input.getStorageClass(), "StorageClass");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("storageClass", "").withHeader("X-Tos-Storage-Class", input.getStorageClass().toString());
        TosRequest req = this.factory.build(builder, "PUT", null);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketStorageClassOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketLocationOutput getBucketLocation(GetBucketLocationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketLocationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("location", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketLocationOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketLifecycleOutput putBucketLifecycle(PutBucketLifecycleInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketLifecycleInput");
        ParamsChecker.ensureNotNull(input.getRules(), "LifecycleRules");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("lifecycle", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketLifecycleOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketLifecycleOutput getBucketLifecycle(GetBucketLifecycleInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketLifecycleInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("lifecycle", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketLifecycleOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketLifecycleOutput deleteBucketLifecycle(DeleteBucketLifecycleInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketLifecycleInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("lifecycle", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketLifecycleOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketMirrorBackOutput putBucketMirrorBack(PutBucketMirrorBackInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketMirrorBackInput");
        ParamsChecker.ensureNotNull(input.getRules(), "MirrorBackRules");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("mirror", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketMirrorBackOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketMirrorBackOutput getBucketMirrorBack(GetBucketMirrorBackInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketMirrorBackInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("mirror", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketMirrorBackOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketMirrorBackOutput deleteBucketMirrorBack(DeleteBucketMirrorBackInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketMirrorBackInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("mirror", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketMirrorBackOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketReplicationOutput putBucketReplication(PutBucketReplicationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketReplicationInput");
        ParamsChecker.ensureNotNull(input.getRole(), "ReplicationRole");
        ParamsChecker.ensureNotNull(input.getRules(), "ReplicationRule");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("replication", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketReplicationOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketReplicationOutput getBucketReplication(GetBucketReplicationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketReplicationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("replication", "").withQuery("progress", "").withQuery("rule-id", input.getRuleID());
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketReplicationOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketReplicationOutput deleteBucketReplication(DeleteBucketReplicationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketReplicationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("replication", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketReplicationOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketVersioningOutput putBucketVersioning(PutBucketVersioningInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketVersioningInput");
        ParamsChecker.ensureNotNull((Object)input.getStatus(), "VersioningStatusType");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("versioning", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketVersioningOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketVersioningOutput getBucketVersioning(GetBucketVersioningInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketVersioningInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("versioning", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketVersioningOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketWebsiteOutput putBucketWebsite(PutBucketWebsiteInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketWebsiteInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("website", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketWebsiteOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketWebsiteOutput getBucketWebsite(GetBucketWebsiteInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketWebsiteInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("website", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketWebsiteOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketWebsiteOutput deleteBucketWebsite(DeleteBucketWebsiteInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketWebsiteInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("website", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketWebsiteOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketNotificationOutput putBucketNotification(PutBucketNotificationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketNotificationInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("notification", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketNotificationOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketNotificationOutput getBucketNotification(GetBucketNotificationInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketNotificationInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("notification", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketNotificationOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketCustomDomainOutput putBucketCustomDomain(PutBucketCustomDomainInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketCustomDomainInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("customdomain", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketCustomDomainOutput().setRequestInfo(res.RequestInfo()));
    }

    public ListBucketCustomDomainOutput listBucketCustomDomain(ListBucketCustomDomainInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListBucketCustomDomainInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("customdomain", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<ListBucketCustomDomainOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketCustomDomainOutput deleteBucketCustomDomain(DeleteBucketCustomDomainInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketCustomDomainInput");
        ParamsChecker.ensureNotNull(input.getDomain(), "Domain");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("customdomain", input.getDomain());
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 200, res -> new DeleteBucketCustomDomainOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketRealTimeLogOutput putBucketRealTimeLog(PutBucketRealTimeLogInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketRealTimeLogInput");
        this.ensureValidBucketName(input.getBucket());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("realtimeLog", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketRealTimeLogOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketRealTimeLogOutput getBucketRealTimeLog(GetBucketRealTimeLogInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketRealTimeLogInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("realtimeLog", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketRealTimeLogOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketRealTimeLogOutput deleteBucketRealTimeLog(DeleteBucketRealTimeLogInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketRealTimeLogInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("realtimeLog", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketRealTimeLogOutput().setRequestInfo(res.RequestInfo()));
    }

    public PutBucketACLOutput putBucketACL(PutBucketACLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketACLInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("acl", "").withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write", input.getGrantWrite()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp());
        byte[] data = new byte[]{};
        if (input.getOwner() != null && StringUtils.isNotEmpty(input.getOwner().getId()) && input.getGrants() != null && input.getGrants().size() > 0) {
            TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
            data = marshalResult.getData();
            builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        }
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(data)).setContentLength(data.length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketACLOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketACLOutput getBucketACL(GetBucketACLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketACLInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("acl", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketACLOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public PutBucketRenameOutput putBucketRename(PutBucketRenameInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutBucketRenameInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("rename", "");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        builder.withHeader("Content-MD5", marshalResult.getContentMD5());
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.bucketHandler.doRequest(req, 200, res -> new PutBucketRenameOutput().setRequestInfo(res.RequestInfo()));
    }

    public GetBucketRenameOutput getBucketRename(GetBucketRenameInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetBucketRenameInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("rename", "");
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.bucketHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetBucketRenameOutput>(){}).setRequestInfo(res.RequestInfo()));
    }

    public DeleteBucketRenameOutput deleteBucketRename(DeleteBucketRenameInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteBucketRenameInput");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("rename", "");
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.bucketHandler.doRequest(req, 204, res -> new DeleteBucketRenameOutput().setRequestInfo(res.RequestInfo()));
    }

    public TosRequestFactory getFactory() {
        return this.factory;
    }

    public TosBucketRequestHandler setFactory(TosRequestFactory factory) {
        this.factory = factory;
        return this;
    }

    public TosBucketRequestHandler setTransport(Transport transport) {
        if (this.bucketHandler == null) {
            this.bucketHandler = new RequestHandler(transport);
        } else {
            this.bucketHandler.setTransport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        if (this.bucketHandler != null) {
            return this.bucketHandler.getTransport();
        }
        return null;
    }

    private void ensureValidBucketName(String bucket) {
        if (this.factory.isCustomDomain()) {
            return;
        }
        ParamsChecker.isValidBucketName(bucket);
    }
}

