/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.comm.common.ACLType;
import com.volcengine.tos.comm.common.CannedType;
import com.volcengine.tos.comm.common.GranteeType;
import com.volcengine.tos.comm.common.MetadataDirectiveType;
import com.volcengine.tos.comm.common.PermissionType;
import com.volcengine.tos.comm.common.StorageClassType;
import com.volcengine.tos.internal.util.StringUtils;

public class TypeConverter {
    public static ACLType convertACLType(String type) {
        if (type == null) {
            return null;
        }
        if (StringUtils.equals(type, "private")) {
            return ACLType.ACL_PRIVATE;
        }
        if (StringUtils.equals(type, "public-read")) {
            return ACLType.ACL_PUBLIC_READ;
        }
        if (StringUtils.equals(type, "public-read-write")) {
            return ACLType.ACL_PUBLIC_READ_WRITE;
        }
        if (StringUtils.equals(type, "authenticated-read")) {
            return ACLType.ACL_AUTHENTICATED_READ;
        }
        if (StringUtils.equals(type, "bucket-owner-read")) {
            return ACLType.ACL_BUCKET_OWNER_READ;
        }
        if (StringUtils.equals(type, "bucket-owner-full-control")) {
            return ACLType.ACL_BUCKET_OWNER_FULL_CONTROL;
        }
        if (StringUtils.equals(type, "log-delivery-write")) {
            return ACLType.ACL_LOG_DELIVERY_WRITE;
        }
        if (StringUtils.equals(type, "bucket-owner-entrusted")) {
            return ACLType.ACL_BUCKET_OWNER_ENTRUSTED;
        }
        return ACLType.ACL_UNKNOWN;
    }

    public static StorageClassType convertStorageClassType(String storageClass) {
        if (storageClass == null) {
            return null;
        }
        if (StringUtils.equals(storageClass, "STANDARD")) {
            return StorageClassType.STORAGE_CLASS_STANDARD;
        }
        if (StringUtils.equals(storageClass, "IA")) {
            return StorageClassType.STORAGE_CLASS_IA;
        }
        if (StringUtils.equals(storageClass, "ARCHIVE_FR")) {
            return StorageClassType.STORAGE_CLASS_ARCHIVE_FR;
        }
        if (StringUtils.equals(storageClass, "INTELLIGENT_TIERING")) {
            return StorageClassType.STORAGE_CLASS_INTELLIGENT_TIERING;
        }
        if (StringUtils.equals(storageClass, "COLD_ARCHIVE")) {
            return StorageClassType.STORAGE_CLASS_COLD_ARCHIVE;
        }
        return StorageClassType.STORAGE_CLASS_UNKNOWN;
    }

    public static MetadataDirectiveType convertMetadataDirectiveType(String metadataDirectiveType) {
        if (metadataDirectiveType == null) {
            return null;
        }
        if (StringUtils.equals(metadataDirectiveType, "COPY")) {
            return MetadataDirectiveType.METADATA_DIRECTIVE_COPY;
        }
        if (StringUtils.equals(metadataDirectiveType, "REPLACE")) {
            return MetadataDirectiveType.METADATA_DIRECTIVE_REPLACE;
        }
        return MetadataDirectiveType.METADATA_DIRECTIVE_UNKNOWN;
    }

    public static PermissionType convertPermissionType(String permissionType) {
        if (permissionType == null) {
            return null;
        }
        if (StringUtils.equals(permissionType, "FULL_CONTROL")) {
            return PermissionType.PERMISSION_FULL_CONTROL;
        }
        if (StringUtils.equals(permissionType, "READ")) {
            return PermissionType.PERMISSION_READ;
        }
        if (StringUtils.equals(permissionType, "READ_ACP")) {
            return PermissionType.PERMISSION_READ_ACP;
        }
        if (StringUtils.equals(permissionType, "WRITE")) {
            return PermissionType.PERMISSION_WRITE;
        }
        if (StringUtils.equals(permissionType, "WRITE_ACP")) {
            return PermissionType.PERMISSION_WRITE_ACP;
        }
        return PermissionType.PERMISSION_UNKNOWN;
    }

    public static CannedType convertCannedType(String cannedType) {
        if (cannedType == null) {
            return null;
        }
        if (StringUtils.equals(cannedType, "AllUsers")) {
            return CannedType.CANNED_ALL_USERS;
        }
        if (StringUtils.equals(cannedType, "AuthenticatedUsers")) {
            return CannedType.CANNED_AUTHENTICATED_USERS;
        }
        if (StringUtils.equals(cannedType, "LogDelivery")) {
            return CannedType.CANNED_LOG_DELIVERY;
        }
        return CannedType.CANNED_UNKNOWN;
    }

    public static GranteeType convertGranteeType(String granteeType) {
        if (granteeType == null) {
            return null;
        }
        if (StringUtils.equals(granteeType, "Group")) {
            return GranteeType.GRANTEE_GROUP;
        }
        if (StringUtils.equals(granteeType, "CanonicalUser")) {
            return GranteeType.GRANTEE_USER;
        }
        return GranteeType.GRANTEE_UNKNOWN;
    }
}

