/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.model;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.event.DataTransferStatus;
import com.volcengine.tos.comm.event.DataTransferType;
import com.volcengine.tos.internal.model.DataTransferListenInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleDataTransferListenInputStream
extends DataTransferListenInputStream {
    private final DataTransferListener listener;
    private long totalBytes;
    private long consumedBytes;
    private int unNotifiedBytes;
    private boolean readStarted;
    private boolean doneEOF;
    private long markedConsumedBytes;
    private int markedUnNotifiedBytes;

    public SimpleDataTransferListenInputStream(InputStream is, DataTransferListener listener, long total) {
        super(is);
        if (is == null || listener == null) {
            throw new TosClientException("invalid input", null);
        }
        this.listener = listener;
        this.totalBytes = total;
    }

    @Override
    public int read() throws IOException {
        if (!this.readStarted) {
            this.onFirstRead();
            this.readStarted = true;
        }
        try {
            int n = super.read();
            if (n == -1) {
                this.eof();
            } else {
                this.bytesRead(1);
            }
            return n;
        }
        catch (IOException e) {
            this.onFailed();
            throw e;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markedConsumedBytes = this.consumedBytes;
        this.markedUnNotifiedBytes = this.unNotifiedBytes;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.unNotifiedBytes = this.markedUnNotifiedBytes;
        this.consumedBytes = this.markedConsumedBytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.readStarted) {
            this.onFirstRead();
            this.readStarted = true;
        }
        try {
            int n = super.read(b, off, len);
            if (n == -1) {
                this.eof();
            } else {
                this.bytesRead(n);
            }
            return n;
        }
        catch (IOException e) {
            this.onFailed();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.eof();
        super.close();
    }

    private void onFirstRead() {
        DataTransferStatus status = new DataTransferStatus().setType(DataTransferType.DATA_TRANSFER_STARTED).setTotalBytes(this.totalBytes).setConsumedBytes(this.consumedBytes);
        this.listener.dataTransferStatusChange(status);
    }

    private void onEOF() {
        if (this.unNotifiedBytes > 0) {
            this.consumedBytes += (long)this.unNotifiedBytes;
            this.onBytesRead(this.unNotifiedBytes);
            this.unNotifiedBytes = 0;
        }
        DataTransferStatus status = new DataTransferStatus().setTotalBytes(this.totalBytes).setConsumedBytes(this.consumedBytes);
        status = this.consumedBytes < this.totalBytes ? status.setType(DataTransferType.DATA_TRANSFER_FAILED) : status.setType(DataTransferType.DATA_TRANSFER_SUCCEED);
        this.listener.dataTransferStatusChange(status);
    }

    private void onFailed() {
        DataTransferStatus status = new DataTransferStatus().setType(DataTransferType.DATA_TRANSFER_FAILED).setTotalBytes(this.totalBytes).setConsumedBytes(this.consumedBytes);
        this.listener.dataTransferStatusChange(status);
    }

    private void onBytesRead(int bytesRead) {
        DataTransferStatus status = new DataTransferStatus().setType(DataTransferType.DATA_TRANSFER_RW).setTotalBytes(this.totalBytes).setConsumedBytes(this.consumedBytes).setRwOnceBytes(bytesRead);
        this.listener.dataTransferStatusChange(status);
    }

    private void bytesRead(int bytesRead) {
        this.unNotifiedBytes += bytesRead;
        if (this.unNotifiedBytes >= 524288) {
            this.consumedBytes += (long)this.unNotifiedBytes;
            this.onBytesRead(this.unNotifiedBytes);
            this.unNotifiedBytes = 0;
        }
    }

    private void eof() {
        if (this.doneEOF) {
            return;
        }
        this.onEOF();
        this.unNotifiedBytes = 0;
        this.doneEOF = true;
    }
}

