/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.auth;

import com.volcengine.tos.auth.Credential;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.FederationToken;
import com.volcengine.tos.auth.FederationTokenProvider;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;

public class FederationCredentials
implements Credentials {
    private FederationToken cachedToken;
    private AtomicInteger refreshing = new AtomicInteger(0);
    private Duration preFetch;
    private FederationTokenProvider tokenProvider;

    public FederationCredentials(FederationTokenProvider tokenProvider) {
        this.cachedToken = tokenProvider.federationToken();
        this.tokenProvider = tokenProvider;
        this.preFetch = Duration.ofMinutes(5L);
    }

    public FederationCredentials withPreFetch(Duration preFetch) {
        this.preFetch = preFetch;
        return this;
    }

    public FederationToken token() {
        return this.cachedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential credential() {
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(this.token().getExpiration())) {
            FederationCredentials federationCredentials = this;
            synchronized (federationCredentials) {
                this.cachedToken = this.tokenProvider.federationToken();
            }
        }
        if (Duration.between(now, this.token().getExpiration()).toNanos() < this.preFetch.toNanos() && this.refreshing.get() == 0 && this.refreshing.compareAndSet(0, 1)) {
            try {
                this.cachedToken = this.tokenProvider.federationToken();
            }
            finally {
                this.refreshing.set(0);
            }
        }
        return this.token().getCredential();
    }
}

