/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.event.CopyEventType;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.TosTask;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.model.object.CopyEvent;
import com.volcengine.tos.model.object.CopyEventListener;
import com.volcengine.tos.model.object.CopyPartInfo;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.ResumableCopyObjectCheckpoint;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;

public class ResumableCopyObjectTask
extends TosTask
implements TaskOutput<UploadPartCopyV2Output> {
    private ResumableCopyObjectCheckpoint checkpoint;
    private String copySourceSSECKey;
    private CopyPartInfo partInfo;
    private boolean enableCheckpoint;
    private String checkpointFile;
    private CopyEventListener copyEventListener;
    private TosObjectRequestHandler handler;
    private UploadPartCopyV2Output output;
    private ObjectMetaRequestOptions options;
    private long trafficLimit;

    public ResumableCopyObjectTask(ResumableCopyObjectCheckpoint checkpoint, int taskIdx) {
        ParamsChecker.ensureNotNull(checkpoint, "ResumableCopyObjectCheckpoint");
        ParamsChecker.ensureNotNull(checkpoint.getCopySourceObjectInfo(), "CopySourceObjectInfo");
        ParamsChecker.ensureNotNull(checkpoint.getCopyPartInfoList(), "CopyPartInfo list");
        this.checkpoint = checkpoint;
        this.partInfo = checkpoint.getCopyPartInfoList().get(taskIdx);
    }

    @Override
    public Callable<TaskOutput<?>> getCallableTask() {
        return () -> {
            if (this.partInfo.getPartNumber() == 1 && this.partInfo.getCopySourceRangeStart() == 0L && this.partInfo.getCopySourceRangeEnd() == 0L) {
                UploadPartV2Input input = UploadPartV2Input.builder().content(new ByteArrayInputStream("".getBytes())).contentLength(0L).bucket(this.checkpoint.getBucket()).key(this.checkpoint.getKey()).partNumber(1).uploadID(this.checkpoint.getUploadID()).options(this.options).build();
                this.uploadNullPart(input);
                return this;
            }
            if (this.trafficLimit != 0L) {
                if (this.options == null) {
                    this.options = new ObjectMetaRequestOptions();
                }
                this.options.setTrafficLimit(this.trafficLimit);
            }
            UploadPartCopyV2Input input = UploadPartCopyV2Input.builder().bucket(this.checkpoint.getBucket()).key(this.checkpoint.getKey()).sourceBucket(this.checkpoint.getSrcBucket()).sourceKey(this.checkpoint.getSrcKey()).sourceVersionID(this.checkpoint.getSrcVersionID()).uploadID(this.checkpoint.getUploadID()).partNumber(this.partInfo.getPartNumber()).copySourceRange(this.partInfo.getCopySourceRangeStart(), this.partInfo.getCopySourceRangeEnd()).copySourceIfMatch(this.checkpoint.getCopySourceIfMatch()).copySourceIfModifiedSinceDate(this.checkpoint.getCopySourceIfModifiedSince()).copySourceIfNoneMatch(this.checkpoint.getCopySourceIfNoneMatch()).copySourceIfUnmodifiedSinceDate(this.checkpoint.getCopySourceIfUnModifiedSince()).copySourceSSECAlgorithm(this.checkpoint.getCopySourceSSECAlgorithm()).copySourceSSECKeyMD5(this.checkpoint.getCopySourceSSECKeyMD5()).copySourceSSECKey(this.copySourceSSECKey).options(this.options).build();
            CopyEvent event = new CopyEvent().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setSrcBucket(this.checkpoint.getSrcBucket()).setSrcKey(this.checkpoint.getSrcKey()).setSrcVersionID(this.checkpoint.getSrcVersionID()).setCheckpointFile(this.checkpointFile).setUploadID(this.checkpoint.getUploadID());
            try {
                this.output = this.handler.uploadPartCopy(input);
                this.partInfo.setCompleted(true);
                this.partInfo.setEtag(this.output.getEtag());
                if (this.enableCheckpoint) {
                    this.checkpoint.writeToFile(this.checkpointFile);
                }
                Util.postCopyEvent(this.copyEventListener, event.setCopyPartInfo(this.partInfo).setType(CopyEventType.CopyEventUploadPartCopySucceed));
            }
            catch (TosException e) {
                if (Util.needAbortTask(e.getStatusCode())) {
                    Util.postCopyEvent(this.copyEventListener, event.setException(e).setType(CopyEventType.CopyEventUploadPartCopyAborted));
                    throw e;
                }
                Util.postCopyEvent(this.copyEventListener, event.setException(e).setType(CopyEventType.CopyEventUploadPartCopyFailed));
            }
            return this;
        };
    }

    private void uploadNullPart(UploadPartV2Input input) throws IOException {
        CopyEvent event = new CopyEvent().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setSrcBucket(this.checkpoint.getSrcBucket()).setSrcKey(this.checkpoint.getSrcKey()).setSrcVersionID(this.checkpoint.getSrcVersionID()).setCheckpointFile(this.checkpointFile).setUploadID(this.checkpoint.getUploadID());
        try {
            UploadPartV2Output output = this.handler.uploadPart(input);
            this.output = new UploadPartCopyV2Output().etag(output.getEtag()).partNumber(1).requestInfo(output.getRequestInfo());
            this.partInfo.setCompleted(true);
            this.partInfo.setEtag(this.output.getEtag());
            if (this.enableCheckpoint) {
                this.checkpoint.writeToFile(this.checkpointFile);
            }
            Util.postCopyEvent(this.copyEventListener, event.setCopyPartInfo(this.partInfo).setType(CopyEventType.CopyEventUploadPartCopySucceed));
        }
        catch (TosException e) {
            if (Util.needAbortTask(e.getStatusCode())) {
                Util.postCopyEvent(this.copyEventListener, event.setException(e).setType(CopyEventType.CopyEventUploadPartCopyAborted));
                throw e;
            }
            Util.postCopyEvent(this.copyEventListener, event.setException(e).setType(CopyEventType.CopyEventUploadPartCopyFailed));
        }
    }

    @Override
    public UploadPartCopyV2Output getOutput() {
        return this.output;
    }

    public ResumableCopyObjectCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public ResumableCopyObjectTask setCheckpoint(ResumableCopyObjectCheckpoint checkpoint) {
        this.checkpoint = checkpoint;
        return this;
    }

    public boolean isEnableCheckpoint() {
        return this.enableCheckpoint;
    }

    public ResumableCopyObjectTask setEnableCheckpoint(boolean enableCheckpoint) {
        this.enableCheckpoint = enableCheckpoint;
        return this;
    }

    public String getCheckpointFile() {
        return this.checkpointFile;
    }

    public ResumableCopyObjectTask setCheckpointFile(String checkpointFile) {
        this.checkpointFile = checkpointFile;
        return this;
    }

    public CopyEventListener getCopyEventListener() {
        return this.copyEventListener;
    }

    public ResumableCopyObjectTask setCopyEventListener(CopyEventListener copyEventListener) {
        this.copyEventListener = copyEventListener;
        return this;
    }

    public TosObjectRequestHandler getHandler() {
        return this.handler;
    }

    public ResumableCopyObjectTask setHandler(TosObjectRequestHandler handler) {
        this.handler = handler;
        return this;
    }

    public ResumableCopyObjectTask setOutput(UploadPartCopyV2Output output) {
        this.output = output;
        return this;
    }

    public ObjectMetaRequestOptions getOptions() {
        return this.options;
    }

    public ResumableCopyObjectTask setOptions(ObjectMetaRequestOptions options) {
        this.options = options;
        return this;
    }

    public String getCopySourceSSECKey() {
        return this.copySourceSSECKey;
    }

    public ResumableCopyObjectTask setCopySourceSSECKey(String copySourceSSECKey) {
        this.copySourceSSECKey = copySourceSSECKey;
        return this;
    }

    public long getTrafficLimit() {
        return this.trafficLimit;
    }

    public ResumableCopyObjectTask setTrafficLimit(long trafficLimit) {
        this.trafficLimit = trafficLimit;
        return this;
    }
}

