/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.common.ACLType;
import com.volcengine.tos.comm.common.StorageClassType;
import com.volcengine.tos.internal.Consts;
import com.volcengine.tos.internal.model.HttpRange;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TypeConverter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetaRequestOptions {
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private Date expires;
    private String ifMatch;
    private Date ifModifiedSince;
    private String ifNoneMatch;
    private Date ifUnmodifiedSince;
    private long contentLength;
    private String contentMD5;
    private long rangeStart;
    private long rangeEnd;
    private Map<String, String> customMetadata;
    private ACLType aclType;
    private String grantFullControl;
    private String grantRead;
    private String grantReadAcp;
    private String grantWrite;
    private String grantWriteAcp;
    private String ssecAlgorithm;
    private String ssecKey;
    private String ssecKeyMD5;
    private String serverSideEncryption;
    private String websiteRedirectLocation;
    private StorageClassType storageClass;
    private long trafficLimit;
    private Map<String, String> headers = new HashMap<String, String>();

    public Map<String, String> headers() {
        if (this.customMetadata != null) {
            for (Map.Entry<String, String> entry : this.customMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!StringUtils.isNotEmpty(value)) continue;
                this.headers.put("X-Tos-Meta-" + key, value);
            }
        }
        return this.headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ObjectMetaRequestOptions setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String toString() {
        return "ObjectMetaRequestOptions{cacheControl='" + this.cacheControl + '\'' + ", contentDisposition='" + this.contentDisposition + '\'' + ", contentEncoding='" + this.contentEncoding + '\'' + ", contentLanguage='" + this.contentLanguage + '\'' + ", contentType='" + this.contentType + '\'' + ", expires=" + this.expires + ", ifMatch='" + this.ifMatch + '\'' + ", ifModifiedSince=" + this.ifModifiedSince + ", ifNoneMatch='" + this.ifNoneMatch + '\'' + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", contentLength=" + this.contentLength + ", contentMD5='" + this.contentMD5 + '\'' + ", rangeStart=" + this.rangeStart + ", rangeEnd=" + this.rangeEnd + ", customMetadata=" + this.customMetadata + ", aclType=" + (Object)((Object)this.aclType) + ", grantFullControl='" + this.grantFullControl + '\'' + ", grantRead='" + this.grantRead + '\'' + ", grantReadAcp='" + this.grantReadAcp + '\'' + ", grantWrite='" + this.grantWrite + '\'' + ", grantWriteAcp='" + this.grantWriteAcp + '\'' + ", ssecAlgorithm='" + this.ssecAlgorithm + '\'' + ", ssecKey='" + this.ssecKey + '\'' + ", ssecKeyMD5='" + this.ssecKeyMD5 + '\'' + ", serverSideEncryption='" + this.serverSideEncryption + '\'' + ", websiteRedirectLocation='" + this.websiteRedirectLocation + '\'' + ", storageClass=" + (Object)((Object)this.storageClass) + ", trafficLimit=" + this.trafficLimit + '}';
    }

    public static ObjectMetaRequestOptionsBuilder builder() {
        return new ObjectMetaRequestOptionsBuilder();
    }

    public String getCacheControl() {
        return this.headers.get("Cache-Control");
    }

    public String getContentDisposition() {
        return this.headers.get("Content-Disposition");
    }

    public String getContentEncoding() {
        return this.headers.get("Content-Encoding");
    }

    public String getContentLanguage() {
        return this.headers.get("Content-Language");
    }

    public String getContentType() {
        return this.headers.get("Content-Type");
    }

    public Date getExpires() {
        return DateConverter.rfc1123StringToDate(this.headers.get("Expires"));
    }

    public String getIfMatch() {
        return this.headers.get("If-Match");
    }

    public Date getIfModifiedSince() {
        return DateConverter.rfc1123StringToDate(this.headers.get("If-Modified-Since"));
    }

    public String getIfNoneMatch() {
        return this.headers.get("If-None-Match");
    }

    public Date getIfUnmodifiedSince() {
        return DateConverter.rfc1123StringToDate(this.headers.get("If-Unmodified-Since"));
    }

    public long getContentLength() {
        String clStr = this.headers.get("Content-Length");
        if (StringUtils.isEmpty(clStr)) {
            return 0L;
        }
        return Long.parseLong(clStr);
    }

    public String getRange() {
        return this.headers.get("Range");
    }

    public String getContentMD5() {
        return this.headers.get("Content-MD5");
    }

    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public ACLType getAclType() {
        return TypeConverter.convertACLType(this.headers.get("X-Tos-Acl"));
    }

    public String getGrantFullControl() {
        return this.headers.get("X-Tos-Grant-Full-Control");
    }

    public String getGrantRead() {
        return this.headers.get("X-Tos-Grant-Read");
    }

    public String getGrantReadAcp() {
        return this.headers.get("X-Tos-Grant-Read-Acp");
    }

    public String getGrantWrite() {
        return this.headers.get("X-Tos-Grant-Write");
    }

    public String getGrantWriteAcp() {
        return this.headers.get("X-Tos-Grant-Write-Acp");
    }

    public String getSsecAlgorithm() {
        return this.headers.get("X-Tos-Server-Side-Encryption-Customer-Algorithm");
    }

    public String getSsecKey() {
        return this.headers.get("X-Tos-Server-Side-Encryption-Customer-Key");
    }

    public String getSsecKeyMD5() {
        return this.headers.get("X-Tos-Server-Side-Encryption-Customer-Key-MD5");
    }

    public String getServerSideEncryption() {
        return this.headers.get("x-tos-server-side-encryption");
    }

    public String getWebsiteRedirectLocation() {
        return this.headers.get("X-Tos-Website-Redirect-Location");
    }

    public StorageClassType getStorageClass() {
        return TypeConverter.convertStorageClassType(this.headers.get("X-Tos-Storage-Class"));
    }

    public long getTrafficLimit() {
        String tlStr = this.headers.get("x-tos-traffic-limit");
        if (StringUtils.isEmpty(tlStr)) {
            return 0L;
        }
        return Long.parseLong(tlStr);
    }

    public ObjectMetaRequestOptions setCacheControl(String cacheControl) {
        this.withHeader("Cache-Control", cacheControl);
        return this;
    }

    public ObjectMetaRequestOptions setContentDisposition(String contentDisposition) {
        this.withHeader("Content-Disposition", contentDisposition);
        return this;
    }

    public ObjectMetaRequestOptions setContentEncoding(String contentEncoding) {
        this.withHeader("Content-Encoding", contentEncoding);
        return this;
    }

    public ObjectMetaRequestOptions setContentLanguage(String contentLanguage) {
        this.withHeader("Content-Language", contentLanguage);
        return this;
    }

    public ObjectMetaRequestOptions setContentType(String contentType) {
        this.withHeader("Content-Type", contentType);
        return this;
    }

    public ObjectMetaRequestOptions setExpires(Date expires) {
        if (expires == null) {
            return this;
        }
        this.withHeader("Expires", DateConverter.dateToRFC1123String(expires));
        return this;
    }

    public ObjectMetaRequestOptions setIfMatch(String ifMatch) {
        this.withHeader("If-Match", ifMatch);
        return this;
    }

    public ObjectMetaRequestOptions setIfModifiedSince(Date ifModifiedSince) {
        if (ifModifiedSince == null) {
            return this;
        }
        this.withHeader("If-Modified-Since", DateConverter.dateToRFC1123String(ifModifiedSince));
        return this;
    }

    public ObjectMetaRequestOptions setIfNoneMatch(String ifNoneMatch) {
        this.withHeader("If-None-Match", ifNoneMatch);
        return this;
    }

    public ObjectMetaRequestOptions setIfUnmodifiedSince(Date ifUnmodifiedSince) {
        if (ifUnmodifiedSince == null) {
            return this;
        }
        this.withHeader("If-Unmodified-Since", DateConverter.dateToRFC1123String(ifUnmodifiedSince));
        return this;
    }

    public ObjectMetaRequestOptions setContentLength(long contentLength) {
        this.withHeader("Content-Length", String.valueOf(contentLength));
        return this;
    }

    public ObjectMetaRequestOptions setContentMD5(String contentMD5) {
        this.withHeader("Content-MD5", contentMD5);
        return this;
    }

    public ObjectMetaRequestOptions setRange(long rangeStart, long rangeEnd) {
        this.withHeader("Range", new HttpRange().setStart(rangeStart).setEnd(rangeEnd).toString());
        return this;
    }

    public ObjectMetaRequestOptions setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    public ObjectMetaRequestOptions setAclType(ACLType aclType) {
        this.withHeader("X-Tos-Acl", aclType == null ? null : aclType.toString());
        return this;
    }

    public ObjectMetaRequestOptions setGrantFullControl(String grantFullControl) {
        this.withHeader("X-Tos-Grant-Full-Control", grantFullControl);
        return this;
    }

    public ObjectMetaRequestOptions setGrantRead(String grantRead) {
        this.withHeader("X-Tos-Grant-Read", grantRead);
        return this;
    }

    public ObjectMetaRequestOptions setGrantReadAcp(String grantReadAcp) {
        this.withHeader("X-Tos-Grant-Read-Acp", grantReadAcp);
        return this;
    }

    public ObjectMetaRequestOptions setGrantWrite(String grantWrite) {
        this.withHeader("X-Tos-Grant-Write", grantWrite);
        return this;
    }

    public ObjectMetaRequestOptions setGrantWriteAcp(String grantWriteAcp) {
        this.withHeader("X-Tos-Grant-Write-Acp", grantWriteAcp);
        return this;
    }

    public ObjectMetaRequestOptions setSsecAlgorithm(String ssecAlgorithm) {
        if (!StringUtils.isNotEmpty(ssecAlgorithm) || !Consts.CUSTOM_SERVER_SIDE_ENCRYPTION_ALGORITHM_LIST.contains(ssecAlgorithm)) {
            throw new TosClientException("invalid encryption-decryption algorithm", null);
        }
        this.withHeader("X-Tos-Server-Side-Encryption-Customer-Algorithm", ssecAlgorithm);
        return this;
    }

    public ObjectMetaRequestOptions setSsecKey(String ssecKey) {
        this.withHeader("X-Tos-Server-Side-Encryption-Customer-Key", ssecKey);
        return this;
    }

    public ObjectMetaRequestOptions setSsecKeyMD5(String ssecKeyMD5) {
        this.withHeader("X-Tos-Server-Side-Encryption-Customer-Key-MD5", ssecKeyMD5);
        return this;
    }

    public ObjectMetaRequestOptions setServerSideEncryption(String serverSideEncryption) {
        if (!StringUtils.isNotEmpty(serverSideEncryption) || !Consts.CUSTOM_SERVER_SIDE_ENCRYPTION_ALGORITHM_LIST.contains(serverSideEncryption)) {
            throw new TosClientException("invalid serverSideEncryption input, only support AES256", null);
        }
        this.withHeader("x-tos-server-side-encryption", serverSideEncryption);
        return this;
    }

    public ObjectMetaRequestOptions setWebsiteRedirectLocation(String websiteRedirectLocation) {
        this.withHeader("X-Tos-Website-Redirect-Location", websiteRedirectLocation);
        return this;
    }

    public ObjectMetaRequestOptions setStorageClass(StorageClassType storageClass) {
        this.withHeader("X-Tos-Storage-Class", storageClass == null ? null : storageClass.toString());
        return this;
    }

    public ObjectMetaRequestOptions setTrafficLimit(long trafficLimit) {
        this.withHeader("x-tos-traffic-limit", String.valueOf(trafficLimit));
        return this;
    }

    private void withHeader(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return;
        }
        this.headers.put(key, value);
    }

    public static final class ObjectMetaRequestOptionsBuilder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String> customMetaData;
        private Date expires;
        private Date ifModifiedSince;
        private Date ifUnmodifiedSince;

        private ObjectMetaRequestOptionsBuilder() {
        }

        private void withHeader(String key, String value) {
            if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
                return;
            }
            this.headers.put(key, value);
        }

        public ObjectMetaRequestOptionsBuilder cacheControl(String cacheControl) {
            this.withHeader("Cache-Control", cacheControl);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder contentDisposition(String contentDisposition) {
            this.withHeader("Content-Disposition", contentDisposition);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder contentEncoding(String contentEncoding) {
            this.withHeader("Content-Encoding", contentEncoding);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder contentLanguage(String contentLanguage) {
            this.withHeader("Content-Language", contentLanguage);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder contentType(String contentType) {
            this.withHeader("Content-Type", contentType);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder expires(Date expires) {
            this.expires = expires;
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ifMatch(String ifMatch) {
            this.withHeader("If-Match", ifMatch);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ifModifiedSince(Date ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ifNoneMatch(String ifNoneMatch) {
            this.withHeader("If-None-Match", ifNoneMatch);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ifUnmodifiedSince(Date ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public ObjectMetaRequestOptionsBuilder contentLength(long contentLength) {
            this.withHeader("Content-Length", String.valueOf(contentLength));
            return this;
        }

        public ObjectMetaRequestOptionsBuilder contentMD5(String contentMD5) {
            this.withHeader("Content-MD5", contentMD5);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder range(long rangeStart, long rangeEnd) {
            this.withHeader("Range", new HttpRange().setStart(rangeStart).setEnd(rangeEnd).toString());
            return this;
        }

        public ObjectMetaRequestOptionsBuilder customMetadata(Map<String, String> customMetadata) {
            this.customMetaData = customMetadata;
            return this;
        }

        public ObjectMetaRequestOptionsBuilder aclType(ACLType aclType) {
            this.withHeader("X-Tos-Acl", aclType == null ? null : aclType.toString());
            return this;
        }

        public ObjectMetaRequestOptionsBuilder grantFullControl(String grantFullControl) {
            this.withHeader("X-Tos-Grant-Full-Control", grantFullControl);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder grantRead(String grantRead) {
            this.withHeader("X-Tos-Grant-Read", grantRead);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder grantReadAcp(String grantReadAcp) {
            this.withHeader("X-Tos-Grant-Read-Acp", grantReadAcp);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder grantWrite(String grantWrite) {
            this.withHeader("X-Tos-Grant-Write", grantWrite);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder grantWriteAcp(String grantWriteAcp) {
            this.withHeader("X-Tos-Grant-Write-Acp", grantWriteAcp);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ssecAlgorithm(String ssecAlgorithm) {
            if (!StringUtils.isNotEmpty(ssecAlgorithm) || !Consts.CUSTOM_SERVER_SIDE_ENCRYPTION_ALGORITHM_LIST.contains(ssecAlgorithm)) {
                throw new TosClientException("invalid encryption-decryption algorithm", null);
            }
            this.withHeader("X-Tos-Server-Side-Encryption-Customer-Algorithm", ssecAlgorithm);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ssecKey(String ssecKey) {
            this.withHeader("X-Tos-Server-Side-Encryption-Customer-Key", ssecKey);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder ssecKeyMD5(String ssecKeyMD5) {
            this.withHeader("X-Tos-Server-Side-Encryption-Customer-Key-MD5", ssecKeyMD5);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder serverSideEncryption(String serverSideEncryption) {
            if (!StringUtils.isNotEmpty(serverSideEncryption) || !Consts.CUSTOM_SERVER_SIDE_ENCRYPTION_ALGORITHM_LIST.contains(serverSideEncryption)) {
                throw new TosClientException("invalid serverSideEncryption input, only support AES256", null);
            }
            this.withHeader("x-tos-server-side-encryption", serverSideEncryption);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder websiteRedirectLocation(String websiteRedirectLocation) {
            this.withHeader("X-Tos-Website-Redirect-Location", websiteRedirectLocation);
            return this;
        }

        public ObjectMetaRequestOptionsBuilder storageClass(StorageClassType storageClass) {
            this.withHeader("X-Tos-Storage-Class", storageClass == null ? null : storageClass.toString());
            return this;
        }

        public ObjectMetaRequestOptionsBuilder trafficLimit(long trafficLimit) {
            this.withHeader("x-tos-traffic-limit", String.valueOf(trafficLimit));
            return this;
        }

        public ObjectMetaRequestOptions build() {
            this.withTimeHeader("Expires", this.expires);
            this.withTimeHeader("If-Modified-Since", this.ifModifiedSince);
            this.withTimeHeader("If-Unmodified-Since", this.ifUnmodifiedSince);
            ObjectMetaRequestOptions objectMetaRequestOptions = new ObjectMetaRequestOptions();
            objectMetaRequestOptions.headers = this.headers;
            objectMetaRequestOptions.customMetadata = this.customMetaData;
            return objectMetaRequestOptions;
        }

        private void withTimeHeader(String key, Date date) {
            if (date == null) {
                return;
            }
            this.withHeader(key, DateConverter.dateToRFC1123String(date));
        }
    }
}

